/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQQueueProperty;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsDestinationStats;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsDestination
implements Queue,
Topic,
Serializable,
TemporaryQueue,
TemporaryTopic {
    private int type;
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    private AQjmsDestinationProperty property;
    private Hashtable dest_properties;
    private Hashtable trans_list;
    private boolean secure;
    private boolean is_temp;
    private int temp_cons = 0;

    AQjmsDestination(String string, String string2, int n, int n2, String string3, String string4, boolean bl) throws JMSException {
        this.owner = string;
        this.name = string2;
        this.type = n;
        this.p_data_type = n2 == 2 ? null : string3;
        this.pload_type = n2;
        this.property = new AQjmsDestinationProperty();
        this.table = string4;
        this.trans_list = new Hashtable();
        this.secure = bl;
        this.is_temp = false;
    }

    AQjmsDestination(String string, String string2, int n, int n2, String string3, AQjmsDestinationProperty aQjmsDestinationProperty, String string4, boolean bl) throws JMSException {
        this.owner = string;
        this.name = string2;
        this.type = n;
        this.p_data_type = n2 == 2 ? null : string3;
        this.pload_type = n2;
        this.property = aQjmsDestinationProperty;
        this.table = string4;
        this.trans_list = new Hashtable();
        this.secure = bl;
        this.is_temp = false;
    }

    public String getQueueName() throws JMSException {
        if (this.type == 10) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getTopicName() throws JMSException {
        if (this.type == 20) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    String getName() {
        return this.name;
    }

    public String getQueueOwner() throws JMSException {
        return this.owner;
    }

    public String getTopicOwner() throws JMSException {
        return this.owner;
    }

    String getAdtType() {
        return this.p_data_type;
    }

    void setAdtType(String string) {
        this.p_data_type = string;
    }

    int getPloadType() {
        return this.pload_type;
    }

    String getQueueTableName() {
        return this.table;
    }

    AQjmsDestinationProperty getProperty() {
        return this.property;
    }

    public String getCompleteName() {
        Object object = null;
        object = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return object;
    }

    public String getCompleteTableName() {
        Object object = null;
        object = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.table : this.table;
        return object;
    }

    public String toString() {
        Object object = null;
        object = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return object;
    }

    public void start(Session session, boolean bl, boolean bl2) throws JMSException {
        this.start(session, bl, bl2, false);
    }

    public void start(Session session, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.start(bl, bl2, bl3);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void stop(Session session, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        this.stop(session, bl, bl2, bl3, false);
    }

    public void stop(Session session, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.stop(bl, bl2, bl3, bl4);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void alter(Session session, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.alterQueue(aQjmsDestinationProperty);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void drop(Session session) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.drop();
            aQOracleQueue.close();
            ((AQjmsSession)session).disableConsumerExceptionListenerForQ(this.getCompleteName());
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void schedulePropagation(Session session, String string, Date date, Double d, String string2, Double d2) throws JMSException {
        this.schedulePropagation(session, string, null, date, d, string2, d2);
    }

    public void schedulePropagation(Session session, String string, String string2, Date date, Double d, String string3, Double d2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.schedulePropagation(string, string2, date, d, string3, d2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void unschedulePropagation(Session session, String string) throws JMSException {
        this.unschedulePropagation(session, string, null);
    }

    public void unschedulePropagation(Session session, String string, String string2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.unschedulePropagation(string, string2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void alterPropagationSchedule(Session session, String string, Double d, String string2, Double d2) throws JMSException {
        this.alterPropagationSchedule(session, string, null, d, string2, d2);
    }

    public void alterPropagationSchedule(Session session, String string, String string2, Double d, String string3, Double d2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.alterPropagationSchedule(string, string2, d, string3, d2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void enablePropagationSchedule(Session session, String string) throws JMSException {
        this.enablePropagationSchedule(session, string, null);
    }

    public void enablePropagationSchedule(Session session, String string, String string2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.enablePropagationSchedule(string, string2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void disablePropagationSchedule(Session session, String string) throws JMSException {
        this.disablePropagationSchedule(session, string, null);
    }

    public void disablePropagationSchedule(Session session, String string, String string2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.disablePropagationSchedule(string, string2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void grantQueuePrivilege(Session session, String string, String string2, boolean bl) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.grantQueuePrivilege(string, string2, bl);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void grantTopicPrivilege(Session session, String string, String string2, boolean bl) throws JMSException {
        this.grantQueuePrivilege(session, string, string2, bl);
    }

    public void revokeQueuePrivilege(Session session, String string, String string2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.revokeQueuePrivilege(string, string2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void revokeTopicPrivilege(Session session, String string, String string2) throws JMSException {
        this.revokeQueuePrivilege(session, string, string2);
    }

    boolean isQueue() {
        return this.type == 10;
    }

    boolean isTopic() {
        return this.type == 20;
    }

    public boolean isSecure() {
        return this.secure;
    }

    Hashtable getTransTable() {
        return this.trans_list;
    }

    void setTransTable(Hashtable hashtable) {
        this.trans_list = hashtable;
    }

    public AQjmsDestination cloneDestination() throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        aQjmsDestination = new AQjmsDestination(this.owner, this.name, this.type, this.pload_type, this.p_data_type, this.table, this.secure);
        aQjmsDestination.setTransTable((Hashtable)this.trans_list.clone());
        return aQjmsDestination;
    }

    boolean isTemp() {
        return this.is_temp;
    }

    void makeTemp() {
        this.is_temp = true;
    }

    public void delete() throws JMSException {
        if (this.is_temp) {
            if (this.temp_cons > 0) {
                AQjmsError.throwEx(241);
            }
            AQjmsConnection.findCloseTemp(this);
        }
    }

    synchronized void addConsForTempDest() {
        if (this.is_temp) {
            ++this.temp_cons;
        }
    }

    synchronized void removeConsForTempDest() {
        if (this.is_temp) {
            --this.temp_cons;
        }
    }

    final boolean isSharded() {
        return this.property.isSharded();
    }

    final boolean isMigrating() {
        return this.property.isMigrating();
    }

    final boolean isJson() {
        return this.property.isJson();
    }

    public synchronized AQjmsDestinationStats queryStats(AQjmsSession aQjmsSession) throws JMSException {
        AQjmsDestinationStats aQjmsDestinationStats = this.queryStats(aQjmsSession, 3);
        return aQjmsDestinationStats;
    }

    public synchronized AQjmsDestinationStats queryStats(AQjmsSession aQjmsSession, int n) throws JMSException {
        if (this.type == 20) {
            AQjmsError.throwEx(107, "queryStats on TOPIC");
        }
        switch (n) {
            case 1: {
                return this.queryGVStats(aQjmsSession);
            }
            case 2: {
                return this.queryApproxProc(aQjmsSession);
            }
            case 3: {
                return this.queryAQView(aQjmsSession);
            }
            case 4: {
                return this.queryApproxExactProc(aQjmsSession);
            }
            case 5: {
                return this.queryAQViewFull(aQjmsSession);
            }
        }
        return this.queryGVStats(aQjmsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryAQView(AQjmsSession aQjmsSession) throws JMSException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        AQjmsDestinationStats aQjmsDestinationStats = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 3;
        try {
            connection = aQjmsSession.getDBConnection();
            string = " select count(*), MSG_STATE from (  SELECT  decode(qt.state, 3, 'EXPIRED',    decode(mod(qt_l.flags  - 1 ,7), 0, 'PROCESSED',                                   1, 'UNDELIVERABLE',                                   2, 'PROCESSED',                                   3, 'PROCESSED',                                   4, 'ROLBACKREADY',                                   5, 'RETRYEXPIRED',                                  -1, 'READY',        decode(qt.state, 0, 'READY','UNDELIVERABLE'))) MSG_STATE FROM " + this.owner + "." + this.name + " qt , " + this.owner + ".AQ$_" + this.name + "_L qt_l  WHERE qt.msgid = qt_l.msgid(+)) qv group by MSG_STATE";
            if (statement == null) {
                statement = connection.prepareStatement(string);
            }
            int n2 = 0;
            boolean bl = false;
            while (n2 < 2 && !bl) {
                try {
                    AQjmsSession aQjmsSession2 = aQjmsSession;
                    synchronized (aQjmsSession2) {
                        resultSet = statement.executeQuery();
                    }
                    bl = true;
                }
                catch (SQLException sQLException) {
                    AQjmsException aQjmsException = new AQjmsException(sQLException);
                    if (aQjmsException.getErrorNumber() == 8103 && n2 == 0) {
                        ++n2;
                        continue;
                    }
                    throw sQLException;
                }
            }
            while (resultSet != null && resultSet.next()) {
                l4 = resultSet.getLong(1);
                String string2 = resultSet.getString(2);
                if (string2.equalsIgnoreCase("PROCESSED")) {
                    l += l4;
                    l2 = l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("READY")) {
                    l += l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("ROLBACKREADY")) {
                    l += l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("RETRYEXPIRED")) {
                    l += l4;
                    l3 += l4;
                    continue;
                }
                if (!string2.equalsIgnoreCase("EXPIRED")) continue;
                l += l4;
                l3 += l4;
            }
            aQjmsDestinationStats = new AQjmsDestinationStats(this.name, this.owner, this.type, l, l2, l3, n);
        }
        catch (SQLException sQLException) {
            AQjmsException aQjmsException = new AQjmsException(sQLException);
            AQOracleDebug.traceEx(3, "AQjmsDestination.queryAQView", sQLException);
            throw aQjmsException;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return aQjmsDestinationStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryAQViewFull(AQjmsSession aQjmsSession) throws JMSException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        AQjmsDestinationStats aQjmsDestinationStats = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 3;
        try {
            connection = aQjmsSession.getDBConnection();
            string = "SELECT COUNT(*), MSG_STATE FROM " + this.owner.toUpperCase() + ".AQ$" + this.name.toUpperCase() + " group by MSG_STATE";
            if (statement == null) {
                statement = connection.prepareStatement(string);
            }
            AQjmsSession aQjmsSession2 = aQjmsSession;
            synchronized (aQjmsSession2) {
                resultSet = statement.executeQuery();
            }
            while (resultSet != null && resultSet.next()) {
                l4 = resultSet.getLong(1);
                String string2 = resultSet.getString(2);
                if (string2.equalsIgnoreCase("PROCESSED")) {
                    l += l4;
                    l2 = l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("READY")) {
                    l += l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("ROLBACKREADY")) {
                    l += l4;
                    continue;
                }
                if (string2.equalsIgnoreCase("RETRYEXPIRED")) {
                    l += l4;
                    l3 += l4;
                    continue;
                }
                if (!string2.equalsIgnoreCase("EXPIRED")) continue;
                l += l4;
                l3 += l4;
            }
            aQjmsDestinationStats = new AQjmsDestinationStats(this.name, this.owner, this.type, l, l2, l3, n);
        }
        catch (SQLException sQLException) {
            AQjmsException aQjmsException = new AQjmsException(sQLException);
            AQOracleDebug.traceEx(3, "AQjmsDestination.queryAQViewFull", sQLException);
            throw aQjmsException;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return aQjmsDestinationStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryGVStats(AQjmsSession aQjmsSession) throws JMSException {
        AQjmsDestinationStats aQjmsDestinationStats;
        block22: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string = null;
            aQjmsDestinationStats = null;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            int n = 1;
            try {
                connection = aQjmsSession.getDBConnection();
                string = "select sum(enqueued_msgs), sum(dequeued_msgs), sum(MSGS_MADE_EXPIRED), queue_name  from gv$persistent_queues where QUEUE_SCHEMA = :1 and  queue_name = :2 group by queue_name";
                if (statement == null) {
                    statement = connection.prepareStatement(string);
                }
                statement.setString(1, this.owner.toUpperCase());
                statement.setString(2, this.name.toUpperCase());
                Object object = aQjmsSession;
                synchronized (object) {
                    resultSet = statement.executeQuery();
                }
                if (resultSet != null && resultSet.next()) {
                    l = resultSet.getLong(1);
                    l2 = resultSet.getLong(2);
                    l3 = resultSet.getLong(3);
                    aQjmsDestinationStats = new AQjmsDestinationStats(this.name, this.owner, this.type, l, l2, l3, n);
                    break block22;
                }
                object = new AQjmsException("Queue statistics cannot be calculated until next publish or receive operation.", 1403);
                throw object;
            }
            catch (SQLException sQLException) {
                AQjmsException aQjmsException = null;
                int n2 = sQLException.getErrorCode();
                if (n2 == 942) {
                    String string2 = "Grant SELECT_CATALOG_ROLE to " + this.owner;
                    aQjmsException = new AQjmsException(string2, sQLException);
                    AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + string2, sQLException);
                } else {
                    aQjmsException = new AQjmsException(sQLException);
                    AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth", sQLException);
                }
                throw aQjmsException;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return aQjmsDestinationStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryApproxExactProc(AQjmsSession aQjmsSession) throws JMSException {
        String string = "Declare   qschm     varchar2(120);   qname     varchar2(120);  enq_count   number(10); deq_count number(10);   subshrows number;  partnum number;  partname varchar2(50);  dqflag number;  qtid number;  q_cursor  integer ;  q_cursor2 integer ; sqlstmt varchar2(500); sqlstmt2 varchar2(500); qdummy   integer ;begin  qschm := ?;   qname := ?;   select TABLE_OBJNO into qtid from system.aq$_queues where name = qname; deq_count := 0;   sqlstmt := 'select distinct partition#, partname, rowmarker from sys.aq$_dequeue_log_partition_map lm where queue = ' || qtid || ' and SUBSHARD <> -1 order by partition#';   q_cursor := dbms_sql.open_cursor ;  dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; dbms_sql.define_column(q_cursor, 1, partnum);  dbms_sql.define_column(q_cursor, 2, partname, 50);  dbms_sql.define_column(q_cursor, 3, dqflag);  qdummy := dbms_sql.execute (q_cursor);  LOOP    if (dbms_sql.fetch_rows(q_cursor) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor, 1, partnum);    dbms_sql.column_value(q_cursor, 2, partname);    dbms_sql.column_value(q_cursor, 3, dqflag);    sqlstmt2 := 'select count(*) from ' || qschm || '.AQ$_' || qname || '_L partition (' ||  partname || ')' ||' where flags = ' || dqflag;    q_cursor2 := dbms_sql.open_cursor ;    dbms_sql.parse(q_cursor2, sqlstmt2, dbms_sql.v7) ;     dbms_sql.define_column(q_cursor2, 1, subshrows);    qdummy := dbms_sql.execute (q_cursor2);    LOOP      if (dbms_sql.fetch_rows(q_cursor2) = 0) then exit;      end if;     dbms_sql.column_value(q_cursor2, 1, subshrows);     deq_count := deq_count + subshrows;    END LOOP;   dbms_sql.close_cursor(q_cursor2);  END LOOP; dbms_sql.close_cursor(q_cursor);  enq_count := 0;  sqlstmt := 'select distinct partition#, partname from sys.aq$_queue_partition_map where queue = ' || qtid  || ' and shard <> -1';  q_cursor := dbms_sql.open_cursor ;  dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ;  dbms_sql.define_column(q_cursor, 1, partnum);  dbms_sql.define_column(q_cursor, 2, partname, 50); qdummy := dbms_sql.execute (q_cursor);  LOOP   if (dbms_sql.fetch_rows(q_cursor) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor, 1, partnum);    dbms_sql.column_value(q_cursor, 2, partname);    sqlstmt2 := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || partname || ')';   q_cursor2 := dbms_sql.open_cursor ;   dbms_sql.parse(q_cursor2, sqlstmt2, dbms_sql.v7) ;   dbms_sql.define_column(q_cursor2, 1, subshrows);  qdummy := dbms_sql.execute (q_cursor2);   LOOP     if (dbms_sql.fetch_rows(q_cursor2) = 0) then exit;    end if;    dbms_sql.column_value(q_cursor2, 1, subshrows);     enq_count := enq_count + subshrows;   END LOOP;   dbms_sql.close_cursor(q_cursor2);  END LOOP;  dbms_sql.close_cursor(q_cursor); ? := enq_count;   ? := deq_count; end; ";
        CallableStatement callableStatement = null;
        Connection connection = null;
        AQjmsDestinationStats aQjmsDestinationStats = null;
        int n = 2;
        try {
            connection = aQjmsSession.getDBConnection();
            callableStatement = connection.prepareCall(string);
            callableStatement.setString(1, this.owner.toUpperCase());
            callableStatement.setString(2, this.name.toUpperCase());
            callableStatement.registerOutParameter(3, -5);
            callableStatement.registerOutParameter(4, -5);
            AQjmsSession aQjmsSession2 = aQjmsSession;
            synchronized (aQjmsSession2) {
                callableStatement.execute();
            }
            long l = callableStatement.getLong(3);
            long l2 = callableStatement.getLong(4);
            aQjmsDestinationStats = new AQjmsDestinationStats(this.name, this.owner, this.type, l, l2, n);
        }
        catch (SQLException sQLException) {
            AQjmsException aQjmsException = null;
            int n2 = sQLException.getErrorCode();
            if (n2 == 942) {
                String string2 = "Grant select on system.aq$_queues, sys.aq$_dequeue_log_partition_map and sys.aq$_queue_partition_map to " + this.owner;
                aQjmsException = new AQjmsException(string2, sQLException);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + string2, sQLException);
            } else {
                aQjmsException = new AQjmsException(sQLException);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth", sQLException);
            }
            throw aQjmsException;
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return aQjmsDestinationStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AQjmsDestinationStats queryApproxProc(AQjmsSession aQjmsSession) throws JMSException {
        String string = "Declare TYPE shard_info IS RECORD \n(q_nummapped_subsh number,\n q_maxmapped_subsh number,\n qpartname varchar2(128),\n qunbound_idx number, \n lwm_subsh number, \n dqlog_nummapped_subsh number, \n dqlog_maxmapped_subsh number,\n dqpartname varchar2(128),\n dqunbound_idx number,\n dqflag number); \n TYPE shard_arr IS TABLE OF shard_info INDEX BY VARCHAR2(32);\nqschm  varchar2(120); \nqname  varchar2(120); \nenq_count number; \ndeq_count number; \nshrd     shard_arr; \nshrdelem shard_info; \nq_cursor          integer; \nsqlstmt varchar2(1024); \nqdummy            integer; \nqid        number; \nqtid       number; \nismulti    number; \nsubshardSz number; \nshrdid     number; \npriority   number; \nsubshrdid  number; \nsubid      number; \nlwm        number; \nSUBSHROWS  number; \nqpartname varchar2(128); \nqUNBOUND_IDX number; \ndqpartname varchar2(128); \ndqflag number; \ndqUNBOUND_IDX number; \nitr varchar2(32); \nmultiplyFactor number; \nstrtDqSn number; \nendDqSn number; \nmcon_error   exception; \npragma exception_init (mcon_error, -25257); \n begin \nqschm := ?; \nqname := ?;enq_count := 0;\ndeq_count := 0;\nselect o.object_id, decode(qt.RECIPIENTS, 'SINGLE', 0, 1) into qtid, ismulti \n from user_objects o, user_queue_tables qt\n where o.OBJECT_NAME=qname and o.OBJECT_TYPE='TABLE' and o.OBJECT_NAME = qt.QUEUE_TABLE; \n if ismulti = 1 then \n   raise mcon_error; \n else \n  subid := 0; \n end if; \nselect qid into qid from user_queues where name=qname; \n dbms_aqadm.get_queue_parameter(qname, 'SUBSHARD_SIZE', subshardSz); \n sqlstmt := \n'select q.priority, q.shard, q.subshard, q.partname, q.unbound_idx, dq.partname, dq.rowmarker, dq.unbound_idx \n from sys.aq$_queue_partition_map q, sys.aq$_dequeue_log_partition_map dq \n where q.queue = dq.queue(+) and q.partition# = dq.queue_part#(+) and q.subshard = dq.subshard(+)  and q.queue = '|| qtid ||' and q.shard <> -1 and  (dq.subscriber_id = '|| subid ||' or dq.subscriber_id is null)';\nq_cursor := dbms_sql.open_cursor ; \ndbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \ndbms_sql.define_column(q_cursor, 1, priority); \ndbms_sql.define_column(q_cursor, 2, shrdid); \ndbms_sql.define_column(q_cursor, 3, subshrdid); \ndbms_sql.define_column(q_cursor, 4, qpartname, 128); \ndbms_sql.define_column(q_cursor, 5, qunbound_idx); \ndbms_sql.define_column(q_cursor, 6, dqpartname, 128); \ndbms_sql.define_column(q_cursor, 7, dqflag); \ndbms_sql.define_column(q_cursor, 8, dqunbound_idx); \nqdummy := dbms_sql.execute (q_cursor); \nLOOP \n  if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n  end if; \n  dbms_sql.column_value(q_cursor, 1, priority); \n  dbms_sql.column_value(q_cursor, 2, shrdid); \n  dbms_sql.column_value(q_cursor, 3, subshrdid); \n  dbms_sql.column_value(q_cursor, 4, qpartname); \n  dbms_sql.column_value(q_cursor, 5, qunbound_idx); \n  dbms_sql.column_value(q_cursor, 6, dqpartname); \n  dbms_sql.column_value(q_cursor, 7, dqflag); \n  dbms_sql.column_value(q_cursor, 8, dqunbound_idx); \n if (not shrd.exists(shrdid || ',' || priority)) then \n    shrdelem.q_nummapped_subsh := 1; \n      shrdelem.q_maxmapped_subsh := subshrdid; \n    shrdelem.qpartname := qpartname; \n     shrdelem.qunbound_idx := qunbound_idx; \n    shrdelem.lwm_subsh := 0; \n    if (dqflag is null) then \n      shrdelem.dqlog_nummapped_subsh := 0; \n      shrdelem.dqlog_maxmapped_subsh := -1; \n      shrdelem.dqpartname := ''; \n      shrdelem.dqunbound_idx := 0; \n      shrdelem.dqflag := 0; \n    else \n      shrdelem.dqlog_nummapped_subsh := 1; \n      shrdelem.dqlog_maxmapped_subsh := subshrdid; \n      shrdelem.dqpartname := dqpartname; \n      shrdelem.dqunbound_idx := dqunbound_idx; \n      shrdelem.dqflag := dqflag; \n    end if; \n    shrd(shrdid || ',' || priority) := shrdelem; \n  else \n   shrdelem := shrd(shrdid || ',' || priority); \n      shrd(shrdid || ',' || priority).q_nummapped_subsh := shrdelem.q_nummapped_subsh + 1; \n      if (shrdelem.q_maxmapped_subsh = -1 or shrdelem.q_maxmapped_subsh < subshrdid) then \n        shrd(shrdid || ',' || priority).q_maxmapped_subsh := subshrdid; \n        shrd(shrdid || ',' || priority).qpartname := qpartname; \n        shrd(shrdid || ',' || priority).qunbound_idx := qunbound_idx; \n      end if; \n      if (dqflag is not null) then \n        shrd(shrdid || ',' || priority).dqlog_nummapped_subsh := shrdelem.dqlog_nummapped_subsh + 1; \n        if (shrdelem.dqlog_maxmapped_subsh = -1 or shrdelem.dqlog_maxmapped_subsh < subshrdid) then \n         shrd(shrdid || ',' || priority).dqlog_maxmapped_subsh := subshrdid; \n           shrd(shrdid || ',' || priority).dqpartname := dqpartname; \n         shrd(shrdid || ',' || priority).dqunbound_idx := dqunbound_idx; \n         shrd(shrdid || ',' || priority).dqflag := dqflag; \n       end if; \n     end if; \n end if; \nEND LOOP; \nitr := shrd.first; \nwhile (itr is not null) \nloop \n  shrdelem := shrd(itr); \n  if (shrdelem.q_nummapped_subsh > 0) then \n    if (shrdelem.dqlog_nummapped_subsh > 0) then \n     deq_count := deq_count + ((shrdelem.dqlog_nummapped_subsh -1) * subshardSz); \n      if shrdelem.dqUnbound_Idx = -1 then \n        multiplyFactor := 0; \n      else \n        multiplyFactor := shrdelem.dqUnbound_Idx; \n      end if; \n      strtDqSn := (0 + (subshardSz * (multiplyFactor))); \n      endDqSn := (subshardSz + (subshardSz * (multiplyFactor))); \n      sqlstmt := 'select count(*) from ' || qschm || '.AQ$_' || qname || '_L partition (' ||  shrdelem.dqpartname || ')' \n||' where flags = ' || shrdelem.dqflag || ' and seq_num >= ' || strtDqSn || ' and seq_num < ' || endDqSn; \n      q_cursor := dbms_sql.open_cursor ; \n      dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \n      dbms_sql.define_column(q_cursor, 1, subshrows); \n      qdummy := dbms_sql.execute (q_cursor); \n      LOOP \n        if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n        end if; \n        dbms_sql.column_value(q_cursor, 1, subshrows); \n        deq_count := deq_count + subshrows; \n      END LOOP; \n      dbms_sql.close_cursor(q_cursor); \n    end if; \n    enq_count := enq_count + ((shrdelem.q_nummapped_subsh -1) * subshardSz); \n    if shrdelem.qunbound_Idx = -1 then \n      sqlstmt := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || shrdelem.qpartname || ')'; \n    else \n      sqlstmt := 'select count(*) from ' || qschm || '.' || qname || ' partition (' || shrdelem.qpartname || ') \n where subshard = ' || shrdelem.q_maxmapped_subsh; \n   end if; \n    q_cursor := dbms_sql.open_cursor ; \n    dbms_sql.parse(q_cursor, sqlstmt, dbms_sql.v7) ; \n    dbms_sql.define_column(q_cursor, 1, subshrows); \n    qdummy := dbms_sql.execute (q_cursor); \n    LOOP \n      if (dbms_sql.fetch_rows(q_cursor) = 0) then exit; \n      end if; \n      dbms_sql.column_value(q_cursor, 1, subshrows); \n      enq_count := enq_count + subshrows; \n    END LOOP; \n    dbms_sql.close_cursor(q_cursor); \n  end if; \n  itr := shrd.next(itr); \nend loop; \n ? := enq_count; \n  ? := deq_count; \nend;";
        CallableStatement callableStatement = null;
        Connection connection = null;
        AQjmsDestinationStats aQjmsDestinationStats = null;
        int n = 2;
        try {
            connection = aQjmsSession.getDBConnection();
            callableStatement = connection.prepareCall(string);
            callableStatement.setString(1, this.owner.toUpperCase());
            callableStatement.setString(2, this.name.toUpperCase());
            callableStatement.registerOutParameter(3, -5);
            callableStatement.registerOutParameter(4, -5);
            AQjmsSession aQjmsSession2 = aQjmsSession;
            synchronized (aQjmsSession2) {
                callableStatement.execute();
            }
            long l = callableStatement.getLong(3);
            long l2 = callableStatement.getLong(4);
            aQjmsDestinationStats = new AQjmsDestinationStats(this.name, this.owner, this.type, l, l2, n);
        }
        catch (SQLException sQLException) {
            AQjmsException aQjmsException = null;
            int n2 = sQLException.getErrorCode();
            if (n2 == 942) {
                String string2 = "Grant select on sys.aq$_dequeue_log_partition_map and sys.aq$_queue_partition_map to " + this.owner;
                aQjmsException = new AQjmsException(string2, sQLException);
                AQOracleDebug.traceEx(3, "AQjmsDestination.getDepth: " + string2, sQLException);
            } else {
                aQjmsException = new AQjmsException(sQLException);
                AQOracleDebug.traceEx(3, "AQjmsDestination.queryApproxProc", sQLException);
            }
            throw aQjmsException;
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return aQjmsDestinationStats;
    }
}

