/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;
import oracle.jms.WebLogicHelper;

public class AQjmsQueueConnectionFactory
extends AQjmsConnectionFactory
implements QueueConnectionFactory,
Serializable {
    AQjmsQueueConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        this.data_source = null;
        if (string3 != null) {
            if (string3.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (string3.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (string3.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, string3);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "hostname: " + string + "  oracle_sid: " + string2 + "  port_no: " + n + "  driver: " + string3);
    }

    AQjmsQueueConnectionFactory(String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "with jdbc connect string");
    }

    AQjmsQueueConnectionFactory(DataSource dataSource) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dataSource;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "data source object: " + dataSource);
    }

    AQjmsQueueConnectionFactory(DataSource dataSource, String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dataSource;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "with both ds and jdbc connect string");
    }

    AQjmsQueueConnectionFactory(String string) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(string, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "data source name: " + string);
    }

    public AQjmsQueueConnectionFactory() {
    }

    public QueueConnection createQueueConnection() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, null, null, 10);
        } else {
            aQjmsConnection = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10));
        }
        aQjmsConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Connection created successfully");
        return aQjmsConnection;
    }

    public QueueConnection createQueueConnectionInternal() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 10) : (this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10));
        aQjmsConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnectionInternal", "Connection created successfully");
        return aQjmsConnection;
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "with user/pwd");
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            aQjmsConnection = new AQjmsConnection(this.data_source, string, string2, 10);
        } else {
            Properties properties = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (string != null || string2 != null) {
                        properties = (Properties)this.jdbc_info.clone();
                        properties.put("user", string);
                        properties.put("password", string2);
                    } else {
                        properties = this.jdbc_info;
                    }
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, properties, 10);
                } else {
                    aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, string, string2, 10);
                }
            } else {
                aQjmsConnection = this.data_source != null ? new AQjmsConnection(this.data_source, string, string2, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 10);
            }
        }
        aQjmsConnection.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/userName/password", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(Connection connection) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(Connection connection, boolean bl) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 10);
        aQjmsConnection.setCompliant(bl);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(OracleOCIConnectionPool oracleOCIConnectionPool) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/OCI_conn_pool", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(OracleOCIConnectionPool oracleOCIConnectionPool, boolean bl) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 10);
        aQjmsConnection.setCompliant(bl);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/OCI_conn_pool", "Connection created successfully");
        return aQjmsConnection;
    }

    @Override
    boolean getCompliant() {
        return this.compliant;
    }

    @Override
    void setCompliant(boolean bl) {
        this.compliant = bl;
        AQjmsOracleDebug.trace(4, "AQjmsQueueConnectionFactory.setCompliant", "Current <compliant> is set to:" + bl);
    }
}

