/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.jms.plsql.MsgEntity;
import oracle.jms.plsql.TypeConversion;
import oracle.jms.plsql.TypeConversionException;
import oracle.jms.plsql.WrongAccessModeException;

class StreamMsgEntity
extends MsgEntity {
    private int accessMode;
    private byte[] data;
    private ObjectInputStream objectInput;
    private ByteArrayOutputStream byteOutput;
    private ObjectOutputStream objectOutput;

    StreamMsgEntity() throws IOException {
        this.byteOutput = new ByteArrayOutputStream();
        this.objectOutput = new ObjectOutputStream(this.byteOutput);
        this.accessMode = 1;
    }

    StreamMsgEntity(byte[] byArray) throws IOException {
        this.data = byArray;
        this.objectInput = new ObjectInputStream(new ByteArrayInputStream(byArray));
        this.accessMode = 0;
    }

    @Override
    void clean() throws IOException {
        if (this.accessMode == 0) {
            if (this.objectInput != null) {
                this.objectInput.close();
                this.objectInput = null;
            }
            this.data = null;
        } else {
            if (this.objectOutput != null) {
                this.objectOutput.close();
                this.objectOutput = null;
            }
            if (this.byteOutput != null) {
                this.byteOutput.close();
                this.byteOutput = null;
            }
            this.data = null;
        }
    }

    int getMode() {
        return this.accessMode;
    }

    void reset() throws IOException {
        if (this.accessMode == 0) {
            this.objectInput.close();
            this.objectInput = new ObjectInputStream(new ByteArrayInputStream(this.data));
        } else {
            this.objectOutput.close();
            this.data = this.byteOutput.toByteArray();
            this.objectOutput = null;
            this.byteOutput = null;
            this.objectInput = new ObjectInputStream(new ByteArrayInputStream(this.data));
            this.accessMode = 0;
        }
    }

    byte[] flush() throws IOException {
        if (this.accessMode == 1) {
            this.data = this.byteOutput.toByteArray();
        }
        return this.data;
    }

    Object readObject(int n) throws WrongAccessModeException, TypeConversionException, ClassNotFoundException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            Object object = this.objectInput.readObject();
            if (object == null) {
                return null;
            }
            return TypeConversion.jmsConvert(object, n);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    Object readObject() throws WrongAccessModeException, ClassNotFoundException, IOException {
        if (this.accessMode == 1) {
            throw new WrongAccessModeException();
        }
        try {
            return this.objectInput.readObject();
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    void writeObject(Object object) throws WrongAccessModeException, IOException {
        if (this.accessMode == 0) {
            throw new WrongAccessModeException();
        }
        this.objectOutput.writeObject(object);
    }
}

