/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.StreamMessage;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsUtil;

public class AQjmsStreamMessage
extends AQjmsMessage
implements StreamMessage {
    private byte[] m_bytesData = new byte[0];
    private ByteArrayInputStream m_byteArrayFieldStream;
    private Object m_pushbackObject = null;
    private boolean m_pushbackFlag = false;
    private ObjectInputStream m_inObjectStream;
    private ByteArrayOutputStream m_outByteArrayStream;
    private ObjectOutputStream m_outObjectStream;
    private boolean m_dirty = false;

    AQjmsStreamMessage() throws JMSException {
        super(true);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
        this.access_mode = 1;
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
        this.access_mode = 1;
    }

    AQjmsStreamMessage(AQjmsMessage aQjmsMessage) throws JMSException {
        super(aQjmsMessage);
        try {
            this.m_outByteArrayStream = new ByteArrayOutputStream();
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, AQjmsStreamMessage_C aQjmsStreamMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsStreamMessage_C.getHeader();
            this.readStreamMessageContainer(aQjmsStreamMessage_C);
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.header_ext = aQjmsGenMessage_C.getHeader();
            this.readGenMessageContainer(aQjmsGenMessage_C);
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, byte[] byArray) throws JMSException {
        super(aQjmsSession, true);
        if (byArray != null) {
            this.m_bytesData = byArray;
        }
        try {
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.access_mode = 0;
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, byte[] byArray, boolean bl) throws JMSException {
        super(aQjmsSession, true);
        this.access_mode = 0;
    }

    byte[] getBytesData() {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }

    public boolean readBoolean() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readBoolean");
        }
        Object object = this.readObject();
        boolean bl = false;
        if (object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object == null || object instanceof String) {
            bl = Boolean.valueOf((String)object);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return bl;
    }

    public byte readByte() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readByte");
        }
        Object object = this.readObject();
        byte by = 0;
        if (object instanceof Boolean || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Byte) {
            by = (Byte)object;
        } else if (object == null || object instanceof String) {
            try {
                by = Byte.valueOf((String)object);
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return by;
    }

    public short readShort() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readShort");
        }
        Object object = this.readObject();
        short s = 0;
        if (object instanceof Boolean || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Short) {
            s = (Short)object;
        } else if (object instanceof Byte) {
            s = ((Byte)object).shortValue();
        } else if (object == null || object instanceof String) {
            try {
                s = Short.valueOf((String)object);
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return s;
    }

    public char readChar() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readChar");
        }
        Object object = this.readObject();
        char c = '\u0000';
        if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else {
            if (object == null) {
                this.pushback(object);
                throw new NullPointerException("reading a null value as a char");
            }
            if (object instanceof Character) {
                c = ((Character)object).charValue();
            } else {
                AQjmsError.throwMsgFormatEx(161, "invalid type");
            }
        }
        return c;
    }

    public int readInt() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readInt");
        }
        Object object = this.readObject();
        int n = 0;
        if (object instanceof Boolean || object instanceof Character || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Byte) {
            n = ((Byte)object).intValue();
        } else if (object instanceof Short) {
            n = ((Short)object).intValue();
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object == null || object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return n;
    }

    public long readLong() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readLong");
        }
        Object object = this.readObject();
        long l = 0L;
        if (object instanceof Boolean || object instanceof Character || object instanceof Float || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Byte) {
            l = ((Byte)object).longValue();
        } else if (object instanceof Short) {
            l = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            l = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object == null || object instanceof String) {
            try {
                l = Long.valueOf((String)object);
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return l;
    }

    public float readFloat() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readFloat");
        }
        Object object = this.readObject();
        float f = 0.0f;
        if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Float) {
            f = ((Float)object).floatValue();
        } else if (object == null || object instanceof String) {
            try {
                f = Float.valueOf((String)object).floatValue();
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return f;
    }

    public double readDouble() throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readDouble");
        }
        Object object = this.readObject();
        double d = 0.0;
        if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else if (object instanceof Float) {
            d = ((Float)object).doubleValue();
        } else if (object instanceof Double) {
            d = (Double)object;
        } else if (object == null || object instanceof String) {
            try {
                d = Double.valueOf((String)object);
            }
            catch (RuntimeException runtimeException) {
                this.pushback(object);
                throw runtimeException;
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return d;
    }

    public String readString() throws JMSException {
        Object object;
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readString");
        }
        if ((object = this.readObject()) == null) {
            return (String)object;
        }
        String string = null;
        if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            string = object.toString();
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof byte[]) {
            this.pushback(object);
            AQjmsError.throwMsgFormatEx(161, null);
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid type");
        }
        return string;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readBytes");
        }
        if (this.m_byteArrayFieldStream == null) {
            Object object = this.readObject();
            if (object == null) {
                return -1;
            }
            if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String) {
                this.pushback(object);
                AQjmsError.throwMsgFormatEx(161, null);
            } else if (!(object instanceof byte[])) {
                AQjmsError.throwMsgFormatEx(161, "invalid type");
            }
            this.m_byteArrayFieldStream = new ByteArrayInputStream((byte[])object);
        }
        if (byArray == null) {
            return -1;
        }
        int n = 0;
        try {
            n = this.m_byteArrayFieldStream.read(byArray);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        if (n == -1) {
            this.clearByteArrayFieldStream();
        }
        return n;
    }

    public Object readObject() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        if (this.isLargeBody()) {
            this.invalidReadWithStreaming("readObject");
        }
        if (this.isReadingByteArrayField()) {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        if (this.m_pushbackFlag) {
            Object object = this.m_pushbackObject;
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            return object;
        }
        try {
            return this.m_inObjectStream.readObject();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(109, (Throwable)classNotFoundException);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        return null;
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Boolean(bl));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeByte(byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Byte(by));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeShort(short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Short(s));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeChar(char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Character(c));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeInt(int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Integer(n));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeLong(long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Long(l));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeFloat(float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Float(f));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeDouble(double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(new Double(d));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeString(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(string);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outObjectStream.writeObject(byArray);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        try {
            this.m_outObjectStream.writeObject(byArray2);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.m_dirty = true;
    }

    public void writeObject(Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (object == null || object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[]) {
            try {
                this.m_outObjectStream.writeObject(object);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, (Throwable)iOException);
            }
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    @Override
    public void setInputStream(InputStream inputStream) throws JMSException {
        super.setInputStream(inputStream);
    }

    public OutputStream getBody(OutputStream outputStream) throws JMSException {
        return this.getBody(outputStream, 0, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, int n) throws JMSException {
        return this.getBody(outputStream, n, 0L);
    }

    public OutputStream getBody(OutputStream outputStream, long l) throws JMSException {
        return this.getBody(outputStream, 0, l);
    }

    @Override
    public OutputStream getBody(OutputStream outputStream, int n, long l) throws JMSException {
        return super.getBody(outputStream, n, l);
    }

    public void reset() throws JMSException {
        if (this.access_mode == 1) {
            this.updateBytesDataFromStream();
            this.m_outByteArrayStream = null;
            this.m_outObjectStream = null;
            this.m_dirty = false;
        } else {
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            this.clearByteArrayFieldStream();
        }
        try {
            this.m_inObjectStream = new ObjectInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.setAccessMode(0);
    }

    @Override
    public void clearBody() throws JMSException {
        if (this.access_mode == 0) {
            this.m_inObjectStream = null;
            this.m_pushbackFlag = false;
            this.m_pushbackObject = null;
            this.clearByteArrayFieldStream();
        }
        this.m_bytesData = new byte[0];
        this.m_dirty = false;
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        try {
            this.m_outObjectStream = new ObjectOutputStream(this.m_outByteArrayStream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, (Throwable)iOException);
        }
        this.setAccessMode(1);
    }

    @Override
    OracleData getMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsStreamMessage_C aQjmsStreamMessage_C = new AQjmsStreamMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsStreamMessage_C, 2, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getMessageCont", "exit");
        return aQjmsStreamMessage_C;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession aQjmsSession, boolean bl, boolean bl2) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsGenMessage_C aQjmsGenMessage_C = new AQjmsGenMessage_C();
        boolean[] blArray = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(aQjmsGenMessage_C, 2, this.header_ext, this.m_bytesData, aQjmsSession, bl, blArray, bl2);
        this.setWriteLobLater(blArray[0]);
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.getGenMessageCont", "exit");
        return aQjmsGenMessage_C;
    }

    @Override
    void writeLob(AQjmsSession aQjmsSession, String string, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, aQjmsSession, string, byArray, bl);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.writeLob", "exit");
    }

    private void readStreamMessageContainer(AQjmsStreamMessage_C aQjmsStreamMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsStreamMessage_C.getBytesLen(), aQjmsStreamMessage_C.getBytesLob(), aQjmsStreamMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C aQjmsGenMessage_C) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(aQjmsGenMessage_C.getBytesLen(), aQjmsGenMessage_C.getBytesLob(), aQjmsGenMessage_C.getBytesRaw());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromStream() {
        if (this.m_dirty) {
            this.m_bytesData = this.m_outByteArrayStream.toByteArray();
            this.m_dirty = false;
        }
    }

    private void pushback(Object object) {
        this.m_pushbackObject = object;
        this.m_pushbackFlag = true;
    }

    private void clearByteArrayFieldStream() {
        if (this.m_byteArrayFieldStream != null) {
            try {
                this.m_byteArrayFieldStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_byteArrayFieldStream = null;
        }
    }

    private boolean isReadingByteArrayField() {
        return this.m_byteArrayFieldStream != null;
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }
}

