/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.sql.XAConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsDBConnMgr;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

class AQjmsGeneralDBConnection {
    private static final String ORACLE_DRIVER_DEFAULT_URL = "jdbc:oracle:kprb:";
    private AQjmsDBConnMgr m_connMgr = null;
    private Connection m_dbConn = null;
    private XAConnection m_xaConn = null;
    private boolean m_isExternal;
    private boolean m_force;
    final String providerKey;

    AQjmsGeneralDBConnection(AQjmsDBConnMgr aQjmsDBConnMgr, Connection connection, boolean bl, boolean bl2) throws JMSException {
        this.m_connMgr = aQjmsDBConnMgr;
        this.m_dbConn = connection;
        this.m_isExternal = bl;
        this.m_force = bl2;
        this.providerKey = this.getProviderKey();
    }

    AQjmsGeneralDBConnection(AQjmsDBConnMgr aQjmsDBConnMgr, XAConnection xAConnection, boolean bl, boolean bl2) throws JMSException {
        this.m_connMgr = aQjmsDBConnMgr;
        this.m_xaConn = xAConnection;
        this.m_isExternal = bl;
        this.m_force = bl2;
        this.providerKey = this.getProviderKey();
    }

    Connection getDBConnection() throws JMSException {
        if (this.m_dbConn == null) {
            try {
                this.m_dbConn = this.m_xaConn.getConnection();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
        return this.m_dbConn;
    }

    private String getProviderKey() throws JMSException {
        try {
            String string;
            OracleConnection oracleConnection = (OracleConnection)this.getDBConnection();
            String string2 = oracleConnection.getURL();
            int n = string2.indexOf(64);
            if (n < 0) {
                if (!ORACLE_DRIVER_DEFAULT_URL.equals(string2) && !"jdbc:default:connection:".equals(string2)) {
                    AQjmsError.throwEx(112);
                }
                string = ORACLE_DRIVER_DEFAULT_URL;
            } else {
                string = string2.substring(n);
            }
            return string.toUpperCase();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    XAConnection getXAConnection() {
        return this.m_xaConn;
    }

    boolean isExternal() {
        return this.m_isExternal;
    }

    void close() throws JMSException {
        Throwable throwable;
        block10: {
            throwable = null;
            if (this.m_isExternal) {
                AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "do not close external connection");
                if (!this.m_force) {
                    AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "external connection used with non-force flag, call connMgr's releaseExternalConnection");
                    this.m_connMgr.releaseExternalConnection();
                }
            } else {
                try {
                    if (this.m_dbConn != null) {
                        AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "close DB connection");
                        this.m_dbConn.close();
                    }
                }
                catch (Throwable throwable2) {
                    AQjmsOracleDebug.traceEx(2, "AQjmsGeneralDBConnection.close: close db connection", throwable2);
                    throwable = throwable2;
                }
                try {
                    if (this.m_xaConn != null) {
                        AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "close XA connection");
                        this.m_xaConn.close();
                    }
                }
                catch (Throwable throwable3) {
                    AQjmsOracleDebug.traceEx(2, "AQjmsGeneralDBConnection.close: close db connection", throwable3);
                    if (throwable != null) break block10;
                    throwable = throwable3;
                }
            }
        }
        this.m_dbConn = null;
        this.m_xaConn = null;
        this.m_connMgr = null;
        if (throwable != null) {
            AQjmsError.throwEx("Error in close AQjmsGeneralDBConnection", throwable);
        }
    }
}

