/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoaqdeq
extends T4CTTIfun {
    static final int AQTTC_DEQ_OPTS_DEFAULT = 0;
    static final int AQTTC_DEQ_OPTS_ON_COMMIT = 1;
    static final int AQTTC_DEQ_OPTS_IMMEDIATE = 2;
    static final int AQTTC_DEQ_OPTS_FOREVER = 4;
    static final int AQTTC_DEQ_OPTS_BROWSE = 8;
    static final int AQTTC_DEQ_OPTS_LOCKED = 16;
    static final int AQTTC_DEQ_OPTS_REMOVE = 32;
    static final int AQTTC_DEQ_OPTS_REMOVE_NO_DATA = 64;
    static final int AQTTC_DEQ_OPTS_BUFFERED = 128;
    static final int AQTTC_DEQ_OPT_PERS_BUFF = 256;
    static final int AQTCC_DEQ_STREAMING_ENABLED = 1;
    static final int AQDEQVER_DEFAULT = 1;
    static final int AQDEQVER_12_2 = 2;
    static final int AQDEQVER_12_1 = 1;
    private T4Ctoh toh = null;
    private T4CTTIaqm aqm = null;
    private T4CTTIaqjms aqjms = null;
    private byte[] payloadToid = null;
    private byte[] payload = null;
    private int aqdeqver = 0;
    private byte[] dequeuedMessageId = null;
    private byte[] queueNameBytes = null;
    private byte[] consumerNameBytes = null;
    private byte[] correlationBytes = null;
    private byte[] conditionBytes = null;
    private byte[] jmsPropertyBytes = null;
    private boolean hasAMessageBeenDequeued = false;
    private String queueName;
    private JMSDequeueOptions dequeueOptions = null;
    private AQMessagePropertiesI aqMessageProperties = null;
    private JMSMessagePropertiesI jmsMessageProperties = null;
    private OutputStream streamPayload = null;
    private boolean isStreamMode = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    T4CTTIoaqdeq(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)185);
        this.toh = new T4Ctoh(t4CConnection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
    }

    void doJMSDeq(String string, JMSDequeueOptions jMSDequeueOptions, byte[] byArray, AQMessagePropertiesI aQMessagePropertiesI, JMSMessagePropertiesI jMSMessagePropertiesI, OutputStream outputStream) throws SQLException, IOException {
        this.streamPayload = outputStream;
        this.setStreamMode(true);
        this.doJMSDeqRPC(string, jMSDequeueOptions, byArray, aQMessagePropertiesI, jMSMessagePropertiesI);
    }

    private void setStreamMode(boolean bl) {
        this.isStreamMode = bl;
    }

    void doJMSDeq(String string, JMSDequeueOptions jMSDequeueOptions, byte[] byArray, AQMessagePropertiesI aQMessagePropertiesI, JMSMessagePropertiesI jMSMessagePropertiesI) throws SQLException, IOException {
        this.setStreamMode(false);
        this.streamPayload = null;
        this.doJMSDeqRPC(string, jMSDequeueOptions, byArray, aQMessagePropertiesI, jMSMessagePropertiesI);
    }

    private void doJMSDeqRPC(String string, JMSDequeueOptions jMSDequeueOptions, byte[] byArray, AQMessagePropertiesI aQMessagePropertiesI, JMSMessagePropertiesI jMSMessagePropertiesI) throws SQLException, IOException {
        this.queueName = string;
        this.dequeueOptions = jMSDequeueOptions;
        this.payloadToid = byArray;
        this.aqMessageProperties = aQMessagePropertiesI;
        this.jmsMessageProperties = jMSMessagePropertiesI;
        this.queueNameBytes = (byte[])(this.queueName != null && this.queueName.length() != 0 ? this.meg.conv.StringToCharBytes(this.queueName) : null);
        String string2 = this.dequeueOptions.getConsumerName();
        this.consumerNameBytes = (byte[])(string2 != null && string2.length() > 0 ? this.meg.conv.StringToCharBytes(string2) : null);
        String string3 = this.dequeueOptions.getCorrelation();
        this.correlationBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
        String string4 = this.dequeueOptions.getCondition();
        this.conditionBytes = (byte[])(string4 != null && string4.length() > 0 ? this.meg.conv.StringToCharBytes(string4) : null);
        this.hasAMessageBeenDequeued = false;
        this.dequeuedMessageId = null;
        this.payload = null;
        try {
            this.aqdeqver = this.connection.getVersionNumber() >= 12200 && TypeDescriptor.isV2available(byArray) ? 2 : 1;
        }
        catch (Exception exception) {
            this.aqdeqver = 1;
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.consumerNameBytes != null && this.consumerNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.consumerNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        byte[] byArray = this.dequeueOptions.getDequeueMessageId();
        boolean bl = false;
        if (byArray != null && byArray.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(byArray.length);
            bl = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.correlationBytes != null && this.correlationBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.correlationBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int n2 = 0;
        n2 = this.connection.autocommit ? 2 : 1;
        n2 |= this.dequeueOptions.getDeliveryMode().getCode();
        n2 |= this.dequeueOptions.getDequeueMode().getCode();
        n2 |= this.dequeueOptions.getVisibility().getCode();
        if (this.dequeueOptions.getWait() == 4) {
            this.meg.marshalUB4(n2 |= 4);
            this.meg.marshalSB4(-1);
        } else {
            this.meg.marshalUB4(n2);
            this.meg.marshalSB4(this.dequeueOptions.getWait());
        }
        if (this.conditionBytes != null && this.conditionBytes.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.conditionBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.payloadToid != null && this.payloadToid.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.payloadToid.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB2(this.aqdeqver);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalNULLPTR();
        if (this.dequeueOptions.isRetrieveMessageId()) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int n3 = this.isStreamEnabled() ? 1 : this.dequeueOptions.getStreamingMode().getCode();
        this.meg.marshalUB4(n3);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalCHR(this.queueNameBytes);
        }
        if (this.consumerNameBytes != null && this.consumerNameBytes.length != 0) {
            this.meg.marshalCHR(this.consumerNameBytes);
        }
        if (bl) {
            this.meg.marshalB1Array(byArray);
        }
        if (this.correlationBytes != null && this.correlationBytes.length != 0) {
            this.meg.marshalCHR(this.correlationBytes);
        }
        if (this.conditionBytes != null && this.conditionBytes.length > 0) {
            this.meg.marshalCHR(this.conditionBytes);
        }
        this.meg.marshalB1Array(this.payloadToid);
    }

    private boolean isStreamEnabled() {
        return this.isStreamMode;
    }

    private void processStreamPayload() throws SQLException, IOException {
        byte by = 0;
        long l2 = 0L;
        this.setStreamMode(false);
        Byte by2 = 3;
        Byte by3 = 0;
        while ((by = (byte)this.meg.unmarshalUB1()) != by2) {
            l2 = this.meg.unmarshalSB8();
            if (l2 <= 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            byte[] byArray = new byte[(int)l2];
            this.meg.unmarshalBuffer(byArray, 0, byArray.length);
            this.streamPayload.write(byArray);
            if (by != by3) continue;
        }
        this.streamPayload.close();
        this.streamPayload = null;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int n2;
        int n3;
        Object object;
        this.hasAMessageBeenDequeued = true;
        int n4 = (int)this.meg.unmarshalUB4();
        if (n4 > 0) {
            this.aqm.initToDefaultValues();
            this.aqm.receive();
            this.aqMessageProperties.setPriority(this.aqm.aqmpri);
            this.aqMessageProperties.setDelay(this.aqm.aqmdel);
            this.aqMessageProperties.setExpiration(this.aqm.aqmexp);
            if (this.aqm.aqmcorBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
                this.aqMessageProperties.setCorrelation((String)object);
            }
            this.aqMessageProperties.setAttempts(this.aqm.aqmatt);
            if (this.aqm.aqmeqnBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
                this.aqMessageProperties.setExceptionQueue((String)object);
            }
            this.aqMessageProperties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
            if (this.aqm.aqmeqt != null) {
                this.aqMessageProperties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
            }
            object = new AQAgentI();
            if (this.aqm.senderAgentName != null) {
                ((AQAgentI)object).setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
            }
            if (this.aqm.senderAgentAddress != null) {
                ((AQAgentI)object).setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
            }
            ((AQAgentI)object).setProtocol(this.aqm.senderAgentProtocol);
            this.aqMessageProperties.setSender((AQAgent)object);
            this.aqMessageProperties.setPreviousQueueMessageId(this.aqm.originalMsgId);
            this.aqMessageProperties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
            if (this.aqm.aqmetiBytes != null) {
                String string = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
                this.aqMessageProperties.setTransactionGroup(string);
            }
        }
        if (this.dequeueOptions.isRetrieveMessageId()) {
            object = new byte[16];
            this.meg.unmarshalBuffer((byte[])object, 0, 16);
            this.dequeuedMessageId = object;
        }
        if ((n3 = (int)this.meg.unmarshalUB4()) > 0) {
            this.payload = new byte[n3];
            this.meg.unmarshalBuffer(this.payload, 0, this.payload.length);
        }
        if ((n2 = (int)this.meg.unmarshalUB4()) > 0) {
            this.aqjms = new T4CTTIaqjms(this.connection);
            this.aqjms.receive();
            String string = this.meg.conv.CharBytesToString(this.aqjms.aqjmshdrprop, this.aqjms.aqjmshdrprop.length, true);
            this.jmsMessageProperties.setHeaderProperties(string);
            String string2 = this.meg.conv.CharBytesToString(this.aqjms.aqjmsuserprop, this.aqjms.aqjmsuserprop.length, true);
            this.jmsMessageProperties.setUserProperties(string2);
            this.jmsMessageProperties.setJMSMessageType(JMSMessageProperties.JMSMessageType.getJMSMessageType(this.aqjms.aqjmsflags));
        }
    }

    boolean isHasAMessageBeenDequeued() {
        return this.hasAMessageBeenDequeued;
    }

    byte[] getPayload() {
        return this.payload;
    }

    byte[] getDequeuedMessageId() {
        return this.dequeuedMessageId;
    }

    AQMessagePropertiesI getAQMessageProperties() {
        return this.aqMessageProperties;
    }

    public JMSMessagePropertiesI getJMSMessageProperties() {
        return this.jmsMessageProperties;
    }

    @Override
    void readOAC() throws SQLException, IOException {
        if (this.isStreamEnabled()) {
            this.processStreamPayload();
        }
    }

    static {
        try {
            $$$methodRef$$$14 = T4CTTIoaqdeq.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIoaqdeq.class.getDeclaredMethod("readOAC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoaqdeq.class.getDeclaredMethod("getJMSMessageProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoaqdeq.class.getDeclaredMethod("getAQMessageProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoaqdeq.class.getDeclaredMethod("getDequeuedMessageId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoaqdeq.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoaqdeq.class.getDeclaredMethod("isHasAMessageBeenDequeued", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoaqdeq.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoaqdeq.class.getDeclaredMethod("processStreamPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoaqdeq.class.getDeclaredMethod("isStreamEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoaqdeq.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoaqdeq.class.getDeclaredMethod("doJMSDeqRPC", String.class, JMSDequeueOptions.class, byte[].class, AQMessagePropertiesI.class, JMSMessagePropertiesI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoaqdeq.class.getDeclaredMethod("doJMSDeq", String.class, JMSDequeueOptions.class, byte[].class, AQMessagePropertiesI.class, JMSMessagePropertiesI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoaqdeq.class.getDeclaredMethod("setStreamMode", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoaqdeq.class.getDeclaredMethod("doJMSDeq", String.class, JMSDequeueOptions.class, byte[].class, AQMessagePropertiesI.class, JMSMessagePropertiesI.class, OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

