/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public String protocol;
    public String host;
    public int port;
    public String addr;
    public String sid;
    public String service_name;
    public String instance_name;
    public int delayBetweenRetry;
    public int tdu;
    public int sdu;
    public StringBuilder conn_data = new StringBuilder(200);
    public String sslServerCertDN;
    public String origSSLServerCertDN;
    public String origServiceName;
    public String origSid;
    public boolean done;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    private NTAdapter getNT(Properties properties) throws NetException {
        block7: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("tcps")) {
                    this.nt = new TcpsNTAdapter(this.addr, properties);
                    this.origSSLServerCertDN = this.sslServerCertDN;
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
                    this.nt.setOption(108, stringArray);
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("exadirect") || this.protocol.equalsIgnoreCase("msgqlt")) {
                    this.nt = new MQLNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                throw new NetException(21, "protocol: " + this.protocol);
            }
            catch (NLException nLException) {
                throw new NetException(501);
            }
            catch (Exception exception) {
                throw (NetException)new NetException(21).initCause(exception);
            }
        }
        return this.nt;
    }

    public void connect(Properties properties, NounIntf nounIntf) throws IOException {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        this.nt = this.getNT(properties);
        this.nt.connect(nounIntf);
    }

    private void populateProtocol() throws NLException {
        NVPair nVPair = null;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = new NVFactory().createNVPair(this.addr);
        nVPair = nVNavigator.findNVPair(nVPair2, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nVPair.getAtom();
    }

    public void restoreFromOrigCoption(ConnOption connOption) throws IOException {
        this.origSSLServerCertDN = connOption.origSSLServerCertDN;
        this.origServiceName = connOption.origServiceName;
        this.origSid = connOption.origSid;
        this.conn_data = connOption.conn_data;
        if (this.protocol.equalsIgnoreCase("tcps")) {
            String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
            this.nt.setOption(108, stringArray);
        }
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", protocol=" + this.protocol + ", service_name=" + this.service_name + "\naddr=" + this.addr + "\nconn_data=" + this.conn_data + "\nsslServerCertDN=" + this.sslServerCertDN + ", origSSLServerCertDN=" + this.origSSLServerCertDN + ", origServiceName=" + this.origServiceName + ", origSid=" + this.origSid + ", done=" + this.done;
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }

    static {
        try {
            $$$methodRef$$$5 = ConnOption.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ConnOption.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ConnOption.class.getDeclaredMethod("restoreFromOrigCoption", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ConnOption.class.getDeclaredMethod("populateProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnOption.class.getDeclaredMethod("connect", Properties.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnOption.class.getDeclaredMethod("getNT", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

