/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.LogicalConnectionImpl;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD;
    private static final Method CREATEARRAYOF_METHOD;
    private static final Method CREATESTRUCT_METHOD;
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private Object logicalProxy = null;
    boolean autoCommitBeforeOutage = true;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;

    protected TxnReplayableConnection() {
        this.thisProxyNameInLog = "CONN" + this.thisProxyNameInLog;
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setAutoCommit", args={Boolean.class})})
    protected void preForSetAutoCommit(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.autoCommitBeforeOutage = (Boolean)objectArray[0];
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void preForAbort(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        String string;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = string = stackTraceElementArray != null && stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getClassName() : "";
        this.isClosedAndNoReplay = !string.startsWith("oracle.ucp") || this.isClosedAndNoReplay || !this.abortCalledBeforeLatestClose;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="createARRAY", args={String.class, Object.class}), @Signature(name="createBlob", args={byte[].class}), @Signature(name="createBlobWithUnpickledBytes", args={byte[].class}), @Signature(name="createBfile", args={byte[].class}), @Signature(name="createClob", args={byte[].class}), @Signature(name="createClob", args={byte[].class, short.class}), @Signature(name="createClobWithUnpickledBytes", args={byte[].class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void postForAbort(Method method) {
        this.abortCalledBeforeLatestClose = true;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(txnFailoverManagerImpl);
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public void setSessionStateConsistency(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateConsistency(bl);
    }

    @Override
    public void setSessionStateRestoration(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateRestoration(bl);
    }

    @Override
    public Object getProxyObject() throws SQLException {
        return this.logicalProxy;
    }

    @Override
    public void setProxyObject(Object object) throws SQLException {
        this.logicalProxy = object;
    }

    @Override
    public void setProxyObject(Object object, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        this.logicalProxy = object;
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public OracleConnectionBuilderImpl getConnectionBuilder() {
        return this.originalConnectionBuilder;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.failoverMngr.endRequest();
        OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
        oracleConnection.endRequest();
        this.abortCalledBeforeLatestClose = false;
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    public ARRAY createARRAY(String string, Object object) throws SQLException {
        Object object2 = !object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object);
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            ARRAY aRRAY = oracleConnection.createARRAY(string, object2);
            return (ARRAY)this.postForAll(method, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2 = (Object[])this.unwrapProxies(objectArray);
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method method = CREATEARRAYOF_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            ProxyFactory proxyFactory = this.failoverMngr.getProxyFactory();
            if (proxyFactory != null) {
                return (Array)this.postForAll(method, proxyFactory.proxyFor(array));
            }
            this.failoverMngr.disableReplayInternal(method, 370, "Replay disabled", null);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            ProxyFactory proxyFactory = this.failoverMngr.getProxyFactory();
            if (proxyFactory != null) {
                return (Struct)this.postForAll(method, proxyFactory.proxyFor(struct));
            }
            this.failoverMngr.disableReplayInternal(method, 370, "Replay disabled", null);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    Object unwrapProxies(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            if (n2 > 0) {
                Object[] objectArray2 = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray2[i2] = this.unwrapProxies(objectArray[i2]);
                }
                return objectArray2;
            }
            return object;
        }
        if (object instanceof TxnReplayableBase) {
            return ((TxnReplayableBase)object).getDelegate();
        }
        return object;
    }

    boolean isElementTypePrimitive(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        return this.failoverMngr.getReplayStatistics(statisticsReportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        this.failoverMngr.clearReplayStatistics(statisticsReportType);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnectionImpl logicalConnectionImpl = new LogicalConnectionImpl(oraclePooledConnection, (OracleConnection)((Object)this), bl);
        return logicalConnectionImpl;
    }

    static {
        try {
            $$$methodRef$$$38 = TxnReplayableConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = TxnReplayableConnection.class.getDeclaredMethod("getLogicalConnection", OraclePooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = TxnReplayableConnection.class.getDeclaredMethod("clearReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = TxnReplayableConnection.class.getDeclaredMethod("getReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = TxnReplayableConnection.class.getDeclaredMethod("isElementTypePrimitive", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = TxnReplayableConnection.class.getDeclaredMethod("unwrapProxies", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = TxnReplayableConnection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnReplayableConnection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnReplayableConnection.class.getDeclaredMethod("createOracleArray", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnReplayableConnection.class.getDeclaredMethod("createARRAY", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnReplayableConnection.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnReplayableConnection.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnReplayableConnection.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnReplayableConnection.class.getDeclaredMethod("getConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnReplayableConnection.class.getDeclaredMethod("setProxyObject", Object.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnReplayableConnection.class.getDeclaredMethod("setProxyObject", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnReplayableConnection.class.getDeclaredMethod("getProxyObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnReplayableConnection.class.getDeclaredMethod("setSessionStateRestoration", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnReplayableConnection.class.getDeclaredMethod("setSessionStateConsistency", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableConnection.class.getDeclaredMethod("initialize", OracleDataSource.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableConnection.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableConnection.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableConnection.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableConnection.class.getDeclaredMethod("postForCancel", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableConnection.class.getDeclaredMethod("postForClosure", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableConnection.class.getDeclaredMethod("postForAbort", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableConnection.class.getDeclaredMethod("preForMethodWithConcreteClass", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableConnection.class.getDeclaredMethod("preForOpenProxySession", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableConnection.class.getDeclaredMethod("preForCancel", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableConnection.class.getDeclaredMethod("preForClosure", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableConnection.class.getDeclaredMethod("preForAbort", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableConnection.class.getDeclaredMethod("preForSetAutoCommit", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableConnection.class.getDeclaredMethod("preForStatementCreation", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableConnection.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableConnection.class.getDeclaredMethod("getCreateStructMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableConnection.class.getDeclaredMethod("getCreateArrayOfMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableConnection.class.getDeclaredMethod("getCreateARRAYMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
        CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
        CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
    }
}

