/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.util.BequeathModeMediator;
import oracle.jdbc.util.OracleEnvironment;
import oracle.jdbc.util.OracleServerProcessWrapper;
import oracle.net.ns.NetException;
import oracle.net.ns.SocketChannelFacade;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;

public class BequeathAdapter
implements NTAdapter {
    private static final int DEFAULT_NEGOCIATION_MAX_TIME = 3000000;
    private final OracleServerProcessWrapper wrapper;
    private final String tnsDescriptor;
    private int negociationMaxTime = 3000000;
    private static final String CLASS_NAME = BequeathAdapter.class.getName();
    private static final String DEFAULT_TNS_DESCRIPTOR = "(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=beq)))";

    public BequeathAdapter(String SID, String oracleHome, String tnsDescriptor, Properties properties) throws IOException {
        if (SID == null) {
            throw new IllegalArgumentException("SID cannot be null");
        }
        if (properties != null && properties.getProperty("oracle.net.CONNECT_TIMEOUT") != null) {
            this.negociationMaxTime = Integer.parseInt(properties.getProperty("oracle.net.CONNECT_TIMEOUT"));
        }
        try {
            this.wrapper = new OracleServerProcessWrapper(oracleHome);
            this.wrapper.addEnvironment(OracleEnvironment.SID.getEnvName(), SID);
        }
        catch (IOException e) {
            throw (NetException)new NetException(18999).initCause(e);
        }
        this.tnsDescriptor = tnsDescriptor != null ? tnsDescriptor : DEFAULT_TNS_DESCRIPTOR;
    }

    public void setAdapterEnvironment(Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException("envs cannot be null");
        }
        envs.forEach((k, v) -> this.wrapper.addEnvironment((String)k, (String)v));
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.BEQ;
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException {
        this.wrapper.start(this.tnsDescriptor);
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "server process wrapper started, initiate communication", null, null);
        try {
            this.initiateCommunication();
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "server process communication initiated", null, null);
        }
        catch (IOException e) {
            CommonDiagnosable.getInstance().debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "connect", "Error initiating communication with server process", null, e);
            this.wrapper.terminate();
            throw e;
        }
    }

    private void initiateCommunication() throws IOException {
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initiateCommunication", "initiate communication with server process", null, null);
        BequeathModeMediator mediator = new BequeathModeMediator(this.wrapper.getInputStream(), this.wrapper.getOutputStream());
        TimerTask task = TimeoutInterruptHandler.scheduleTask(Thread.currentThread()::interrupt, this.negociationMaxTime);
        try {
            mediator.startMediation();
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initiateCommunication", "mediator thread started", null, null);
        }
        catch (Exception e) {
            CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initiateCommunication", "mediator got exception", null, null);
            if (e instanceof InterruptedException) {
                throw (NetException)new NetException(17828).initCause(e);
            }
            throw (NetException)new NetException(17820).initCause(e);
        }
        finally {
            if (task != null) {
                task.cancel();
            }
        }
        if (mediator.getStatus().getState() == BequeathModeMediator.MediationStatus.State.FAILED) {
            CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initiateCommunication", "mediation has failed", (String)null, null, (Object)((Exception)mediator.getStatus().getDetails()));
            throw new IOException("mediation has failed", (Exception)mediator.getStatus().getDetails());
        }
        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initiateCommunication", "communication with server process done", null, null);
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.wrapper.stop();
        }
        catch (IOException e) {
            throw (NetException)new NetException(17827).initCause(e);
        }
    }

    @Override
    public SocketChannel getSocketChannel() {
        try {
            return new SocketChannelFacade(this.wrapper.getInputStream(), this.wrapper.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get SocketChannel for bequeath adapter");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.wrapper.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.wrapper.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        return null;
    }

    @Override
    public void abort() throws IOException, NetException {
        this.wrapper.terminate();
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        return false;
    }

    @Override
    public void setReadTimeoutIfRequired(Properties prop) throws IOException, NetException {
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return false;
    }

    @Override
    public InetAddress getInetAddress() {
        return InetAddress.getLoopbackAddress();
    }
}

