/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;

public class Address
implements SchemaObject {
    public String addr;
    public String prot;
    public String httpsProxy;
    public int httpsProxyPort;
    protected SchemaObjectFactoryInterface f = null;

    public Address(SchemaObjectFactoryInterface f) {
        this.f = f;
    }

    @Override
    public int isA() {
        return 0;
    }

    @Override
    public String isA_String() {
        return "ADDRESS";
    }

    @Override
    public void initFromString(String s) throws NLException, SOException {
        NVPair nvp = new NVFactory().createNVPair(s);
        this.initFromNVPair(nvp);
    }

    @Override
    public void initFromNVPair(NVPair nvp) throws SOException {
        this.init();
        if (nvp == null || !nvp.getName().equalsIgnoreCase("address")) {
            throw new SOException("Null or unexpected name");
        }
        NVNavigator nav = new NVNavigator();
        NVPair protnvp = nav.findNVPair(nvp, "PROTOCOL");
        if (protnvp == null) {
            throw new SOException("PROTOCOL is not specified");
        }
        this.prot = protnvp.getAtom();
        if (this.addr == null) {
            this.addr = nvp.toString();
        }
    }

    @Override
    public String toString() {
        return this.addr;
    }

    public String getProtocol() {
        return this.prot;
    }

    protected void init() {
        this.addr = null;
        this.prot = null;
        this.httpsProxy = null;
        this.httpsProxyPort = -1;
    }
}

