/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleXAConnectionBuilder;
import oracle.jdbc.datasource.OracleXAConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public abstract class OracleXAConnectionBuilderImpl
implements OracleXAConnectionBuilder {
    protected String user = null;
    protected String password = null;
    protected String serviceName = null;
    protected String instanceName = null;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;
    protected GSSCredential gssCredential = null;
    protected SSLContext sslContext = null;

    @Override
    public abstract OracleXAConnection build() throws SQLException;

    @Override
    public OracleXAConnectionBuilderImpl password(@Blind String string) {
        this.password = string;
        return this;
    }

    @Override
    public OracleXAConnectionBuilderImpl user(String string) {
        this.user = string;
        return this;
    }

    public OracleXAConnectionBuilderImpl serviceName(String string) {
        this.serviceName = string;
        return this;
    }

    public OracleXAConnectionBuilderImpl instanceName(String string) {
        this.instanceName = string;
        return this;
    }

    @Override
    public OracleXAConnectionBuilderImpl shardingKey(OracleShardingKey oracleShardingKey) {
        this.shardingKey = oracleShardingKey;
        return this;
    }

    @Override
    public OracleXAConnectionBuilderImpl superShardingKey(OracleShardingKey oracleShardingKey) {
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this;
    }

    @Override
    public OracleXAConnectionBuilderImpl gssCredential(GSSCredential gSSCredential) {
        if (gSSCredential == null) {
            throw new NullPointerException();
        }
        this.gssCredential = gSSCredential;
        return this;
    }

    @Override
    public OracleXAConnectionBuilderImpl sslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String getUser() {
        return this.user;
    }

    @Blind
    public String getPassword() {
        return this.password;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public OracleConnectionBuilderImpl getOracleConnectionBuilder(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) {
        oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
        if (this.sslContext != null) {
            oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.sslContext(this.sslContext);
        }
        if (this.gssCredential != null) {
            oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.gssCredential(this.gssCredential);
        }
        return oracleConnectionBuilderImpl;
    }
}

