/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleRef;
import oracle.sql.DatumWithConnection;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends DatumWithConnection
implements OracleRef,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String typename;
    transient StructDescriptor descriptor;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.typename == null) {
                if (this.descriptor != null) {
                    this.typename = this.descriptor.getName();
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 52);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.typename);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.typename;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.typename = string;
        this.descriptor = null;
        this.setPhysicalConnectionOf(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Map map) throws SQLException {
        try {
            STRUCT sTRUCT;
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object = (sTRUCT = this.getSTRUCT()) != null ? sTRUCT.toJdbc(map) : null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws SQLException {
        try {
            STRUCT sTRUCT;
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object = (sTRUCT = this.getSTRUCT()) != null ? sTRUCT.toJdbc() : null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            STRUCT sTRUCT;
            try {
                STRUCT sTRUCT2;
                block33: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    sTRUCT2 = null;
                    OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(:1) from dual");
                    oraclePreparedStatement.setRowPrefetch(1);
                    oraclePreparedStatement.setREF(1, this);
                    OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                    try {
                        if (oracleResultSet.next()) {
                            sTRUCT2 = oracleResultSet.getSTRUCT(1);
                            break block33;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 52);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    finally {
                        oracleResultSet.close();
                        oracleResultSet = null;
                        oraclePreparedStatement.close();
                        oraclePreparedStatement = null;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sTRUCT2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                sTRUCT = sTRUCT2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object object) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            block38: {
                try {
                    STRUCT sTRUCT;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((sTRUCT = STRUCT.toSTRUCT(object, this.getInternalConnection())).getInternalConnection() != this.getInternalConnection()) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 77 + "Incompatible connection object");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible connection object");
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 77 + "Incompatible type");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible type");
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    byte[] byArray = sTRUCT.toBytes();
                    byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
                    CallableStatement callableStatement = null;
                    try {
                        callableStatement = this.getInternalConnection().prepareCall("begin :1 := dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
                        callableStatement.registerOutParameter(1, 2);
                        callableStatement.setBytes(2, this.shareBytes());
                        callableStatement.setInt(3, 0);
                        callableStatement.setBytes(4, byArray2);
                        callableStatement.setBytes(5, byArray);
                        callableStatement.execute();
                        int n2 = 0;
                        n2 = callableStatement.getInt(1);
                        if (n2 == 0) break block38;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 77 + "ORA-" + n2);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "ORA-" + n2);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    finally {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                        callableStatement = null;
                    }
                }
                finally {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = this.getDescriptor();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + structDescriptor);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor2 = structDescriptor;
            return structDescriptor2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.descriptor == null) {
                this.descriptor = StructDescriptor.createDescriptor(this.typename, (Connection)this.getInternalConnection());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.descriptor);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StructDescriptor structDescriptor = this.descriptor;
            return structDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLTypeName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.getBaseTypeName();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Map map) throws SQLException {
        try {
            STRUCT sTRUCT;
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object = (sTRUCT = this.getSTRUCT()) != null ? sTRUCT.toJdbc(map) : null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() throws SQLException {
        try {
            STRUCT sTRUCT;
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object = (sTRUCT = this.getSTRUCT()) != null ? sTRUCT.toJdbc() : null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
                preparedStatement.setRef(1, this);
                preparedStatement.setObject(2, object);
                preparedStatement.execute();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJdbc() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF = this;
            return rEF;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleTo(Class clazz) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new REF[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF = null;
            try {
                rEF = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.lang.CloneNotSupportedException: " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new CloneNotSupportedException(sQLException.getMessage());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF2 = rEF;
            return rEF2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            try {
                bl = object instanceof REF && super.equals(object) && this.getBaseTypeName().equals(((REF)object).getSQLTypeName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    public int hashCode() {
        int n2;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n2 = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        n2 *= 256;
                        n2 += byArray[8 + i2] & 0xFF;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                for (int i3 = 0; i3 < 4 && i3 < byArray.length; ++i3) {
                    n2 *= 256;
                    n2 += byArray[6 + i3] & 0xFF;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            for (int i4 = 0; i4 < 4; ++i4) {
                n2 *= 256;
                n2 += byArray[8 + i4] & 0xFF;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(objectOutputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            objectOutputStream.writeObject(this.shareBytes());
            try {
                objectOutputStream.writeUTF(this.getBaseTypeName());
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        REF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.io.IOException: " + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IOException(sQLException.getMessage());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.typename = objectInputStream.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = super.getJavaSqlConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    REF.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.REF"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

