/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(string, connection, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 60ArrayDescriptor.createDescriptor: Invalid argument + 'name' should not be an empty string and 'conn' should not be null.");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 60, "ArrayDescriptor.createDescriptor: Invalid argument,'name' should not be an empty string and 'conn' should not be null.");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        return ArrayDescriptor.createDescriptor(sQLName, connection);
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return ArrayDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        ArrayDescriptor arrayDescriptor = null;
        if (!bl2) {
            arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
        }
        if (arrayDescriptor == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
            if (bl) {
                arrayDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        String string = oracleTypeCOLLECTION.getFullName();
        OracleConnection oracleConnection = oracleTypeCOLLECTION.getConnection();
        ArrayDescriptor arrayDescriptor = (ArrayDescriptor)oracleConnection.getDescriptor(string);
        if (arrayDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeCOLLECTION.getSchemaName(), oracleTypeCOLLECTION.getSimpleName(), oracleTypeCOLLECTION.getConnection());
            arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, (Object)arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        oracleTypeADT.init(byArray2, oracleConnection);
        OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
        return new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super((short)122, string, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)122, sQLName, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, sQLName, oracleTypeCOLLECTION, connection);
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, oracleTypeCOLLECTION, connection);
    }

    ArrayDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)122);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleTypeMetaData.Kind getKind() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleTypeMetaData.Kind.ARRAY));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeMetaData.Kind kind = OracleTypeMetaData.Kind.ARRAY;
            return kind;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaseName() throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            switch (this.getBaseType()) {
                case 12: {
                    string = "VARCHAR";
                    break;
                }
                case 1: {
                    string = "CHAR";
                    break;
                }
                case -2: {
                    string = "RAW";
                    break;
                }
                case 6: {
                    string = "FLOAT";
                    break;
                }
                case 2: {
                    string = "NUMBER";
                    break;
                }
                case 8: {
                    string = "DOUBLE";
                    break;
                }
                case 3: {
                    string = "DECIMAL";
                    break;
                }
                case 91: {
                    string = "DATE";
                    break;
                }
                case 93: {
                    string = "TIMESTAMP";
                    break;
                }
                case -101: {
                    string = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                case -102: {
                    string = "TIMESTAMP WITH LOCAL TIME ZONE";
                    break;
                }
                case 2004: {
                    string = "BLOB";
                    break;
                }
                case 2005: {
                    string = "CLOB";
                    break;
                }
                case -13: {
                    string = "BFILE";
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    object = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = ((OracleNamedType)object).getFullName();
                    break;
                }
                case 2006: {
                    object = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = "REF " + ((OracleTypeREF)object).getFullName();
                    break;
                }
                case 100: {
                    string = "BINARY_FLOAT";
                    break;
                }
                case 101: {
                    string = "BINARY_DOUBLE";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = string;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.pickler;
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        return OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getArrayType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxLength() throws SQLException {
        try {
            long l2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2 = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l4 = l2;
            return l4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.descType(stringBuffer, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            structDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            arrayDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            opaqueDescriptor.descType(stringBuffer, n2 + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int toLength(ARRAY aRRAY) throws SQLException {
        if (aRRAY.numElems != -1) return aRRAY.numElems;
        if (aRRAY.datumArray != null) {
            aRRAY.numElems = aRRAY.datumArray.length;
            return aRRAY.numElems;
        }
        if (aRRAY.objArray != null) {
            if (aRRAY.objArray instanceof Object[]) {
                aRRAY.numElems = ((Object[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof int[]) {
                aRRAY.numElems = ((long[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof long[]) {
                aRRAY.numElems = ((float[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof float[]) {
                aRRAY.numElems = ((double[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof double[]) {
                aRRAY.numElems = ((boolean[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof boolean[]) {
                aRRAY.numElems = ((int[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof byte[]) {
                aRRAY.numElems = ((byte[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else if (aRRAY.objArray instanceof short[]) {
                aRRAY.numElems = ((short[])aRRAY.objArray).length;
                return aRRAY.numElems;
            } else {
                if (!(aRRAY.objArray instanceof char[])) return aRRAY.numElems;
                aRRAY.numElems = ((char[])aRRAY.objArray).length;
            }
            return aRRAY.numElems;
        }
        if (aRRAY.locator != null) {
            aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
            return aRRAY.numElems;
        }
        if (aRRAY.shareBytes() != null) {
            this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 0, null);
            if (aRRAY.numElems != -1) return aRRAY.numElems;
            if (aRRAY.locator != null) {
                aRRAY.numElems = this.toLengthFromLocator(aRRAY.locator);
                return aRRAY.numElems;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Unable to get array length");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toBytes(ARRAY aRRAY, boolean bl) throws SQLException {
        byte[] byArray = aRRAY.shareBytes();
        if (byArray == null) {
            if (aRRAY.datumArray != null || aRRAY.locator != null) {
                byArray = this.pickler.linearize(aRRAY);
                if (bl) return byArray;
                aRRAY.setShareBytes(null);
                return byArray;
            }
            if (aRRAY.objArray != null) {
                aRRAY.datumArray = this.toOracleArray(aRRAY.objArray, 1L, -1);
                byArray = this.pickler.linearize(aRRAY);
                if (bl) return byArray;
                aRRAY.datumArray = null;
                aRRAY.setShareBytes(null);
                return byArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (aRRAY.imageLength == 0L || aRRAY.imageOffset == 0L && aRRAY.imageLength == (long)byArray.length) return byArray;
        byte[] byArray2 = new byte[(int)aRRAY.imageLength];
        System.arraycopy(byArray, (int)aRRAY.imageOffset, byArray2, 0, (int)aRRAY.imageLength);
        aRRAY.setImage(byArray2, 0L, 0L);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Datum[] toOracleArray(ARRAY aRRAY, long l2, int n2, boolean bl) throws SQLException {
        try {
            Datum[] datumArray;
            block44: {
                block42: {
                    block45: {
                        block43: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.enter()) {
                                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aRRAY) + ", " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            if ((datumArray = aRRAY.datumArray) != null) break block42;
                            if (aRRAY.objArray == null) break block43;
                            datumArray = this.toOracleArray(aRRAY.objArray, l2, n2);
                            break block44;
                        }
                        if (aRRAY.locator == null) break block45;
                        datumArray = this.toOracleArrayFromLocator(aRRAY.locator, l2, n2, null);
                        break block44;
                    }
                    if (aRRAY.shareBytes() != null) {
                        this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, 1, null);
                        datumArray = aRRAY.locator != null ? this.toOracleArrayFromLocator(aRRAY.locator, l2, n2, null) : aRRAY.datumArray;
                        if (!bl) {
                            aRRAY.datumArray = null;
                        }
                        break block44;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status.");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.");
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                if (l2 > (long)datumArray.length) {
                    Datum[] datumArray2 = new Datum[]{};
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Datum[] datumArray3 = datumArray2;
                    return datumArray3;
                }
                int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                System.arraycopy(aRRAY.datumArray, (int)l2 - 1, datumArray, 0, n3);
            }
            Datum[] datumArray4 = null;
            if (bl) {
                aRRAY.datumArray = datumArray;
                datumArray4 = (Datum[])datumArray.clone();
            } else {
                datumArray4 = datumArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray4);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray5 = datumArray4;
            return datumArray5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] toJavaArray(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aRRAY) + ", " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(map) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = null;
            if (aRRAY.objArray != null) {
                objectArray = (Object[])((Object[])aRRAY.objArray).clone();
                int n3 = objectArray.length;
                int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
                if (n4 <= 0) {
                    Object[] objectArray2 = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    Object[] objectArray3 = objectArray2;
                    return objectArray3;
                }
                objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                System.arraycopy(aRRAY.objArray, (int)l2 - 1, objectArray, 0, n4);
            } else {
                if (aRRAY.datumArray != null) {
                    objectArray = (Object[])this.toJavaArray(aRRAY.datumArray, l2, n2, map);
                } else if (aRRAY.locator != null) {
                    objectArray = this.toArrayFromLocator(aRRAY.locator, l2, n2, map);
                } else if (aRRAY.shareBytes() != null) {
                    this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, 2, map);
                    objectArray = aRRAY.locator != null ? this.toArrayFromLocator(aRRAY.locator, l2, n2, map) : (Object[])aRRAY.objArray;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                aRRAY.objArray = bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null ? objectArray.clone() : null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray4 = objectArray;
            return objectArray4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Datum[] datumArray = null;
        if (n4 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n4];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                datumArray[n5] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n5;
            }
            resultSet.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Object[] objectArray = null;
        if (n4 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                objectArray[n5] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n5;
            }
            resultSet.close();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSet(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aRRAY) + ", " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = null;
            if (aRRAY.datumArray != null) {
                resultSet = this.toResultSet(aRRAY.datumArray, l2, n2, map);
            } else if (aRRAY.locator != null) {
                resultSet = this.toResultSetFromLocator(aRRAY.locator, l2, n2, map);
            } else if (aRRAY.objArray != null) {
                resultSet = this.toResultSet(this.toOracleArray(aRRAY.objArray, l2, n2), 1L, -1, map);
            } else if (aRRAY.shareBytes() != null) {
                if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(aRRAY.shareBytes(), (int)aRRAY.imageOffset)) {
                    resultSet = this.toResultSetFromImage(aRRAY, l2, n2, map);
                } else {
                    this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, 1, null);
                    if (aRRAY.locator != null) {
                        resultSet = this.toResultSetFromLocator(aRRAY.locator, l2, n2, map);
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
            if (resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unable to create array ResultSet");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public ResultSet toResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = null;
        resultSet = n2 == -1 ? this.connection.newArrayDataResultSet(datumArray, l2, datumArray.length, map) : this.connection.newArrayDataResultSet(datumArray, l2, n2, map);
        return resultSet;
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayLocatorResultSet(this, byArray, l2, n2, map);
        return resultSet;
    }

    public ResultSet toResultSetFromImage(ARRAY aRRAY, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = this.connection.newArrayDataResultSet(aRRAY, l2, n2, map);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] makeJavaArray(int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        switch (n3) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = new BigDecimal[n2];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new String[n2];
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = new Timestamp[n2];
                break;
            }
            case 2002: 
            case 2008: {
                objectArray = new Object[n2];
                break;
            }
            case -13: {
                objectArray = new BFILE[n2];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n2];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n2];
                break;
            }
            case -3: 
            case -2: {
                objectArray = (Object[])new byte[n2][];
                break;
            }
            case 2006: {
                objectArray = new REF[n2];
                break;
            }
            case 2003: {
                objectArray = new Object[n2];
                break;
            }
            case 100: {
                objectArray = new Float[n2];
                break;
            }
            case 101: {
                objectArray = new Double[n2];
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 1" + "makeJavaArray doesn't support type " + n3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 1, "makeJavaArray doesn't support type " + n3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, (Object)null);
        aRRAY.setLocator(byArray);
        int n2 = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (!oracleResultSet.next()) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Fail to access array storage table");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        n2 = oracleResultSet.getInt(1);
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n2;
    }

    Datum[] toOracleArray(Object object, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            OracleType oracleType = this.getElementType();
            datumArray = oracleType.toDatumArray(object, this.connection, l2, n2);
        }
        return datumArray;
    }

    private Object toJavaArray(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n3 < 0) {
            n3 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT sTRUCT = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                sTRUCT = (STRUCT)datumArray[(int)l2 + i2 - 1];
                objectArray[i2] = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
            }
        } else {
            Datum datum = null;
            for (int i3 = 0; i3 < n3; ++i3) {
                datum = datumArray[(int)l2 + i3 - 1];
                objectArray[i3] = datum != null ? datum.toJdbc() : null;
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toNumericArray(Datum[] datumArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n4 < 0) {
            n4 = 0;
        }
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    Datum datum = datumArray[(int)l2 + i2 - 1];
                    if (datum == null) continue;
                    nArray[i2] = datum.intValue();
                }
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    Datum datum = datumArray[(int)l2 + i3 - 1];
                    if (datum == null) continue;
                    dArray[i3] = datum.doubleValue();
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    Datum datum = datumArray[(int)l2 + i4 - 1];
                    if (datum == null) continue;
                    fArray[i4] = datum.floatValue();
                }
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                for (int i5 = 0; i5 < n4; ++i5) {
                    Datum datum = datumArray[(int)l2 + i5 - 1];
                    if (datum == null) continue;
                    lArray[i5] = datum.longValue();
                }
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                for (int i6 = 0; i6 < n4; ++i6) {
                    Datum datum = datumArray[(int)l2 + i6 - 1];
                    if (datum == null) continue;
                    sArray[i6] = ((NUMBER)datum).shortValue();
                }
                objectArray = sArray;
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toNumericArrayFromLocator(byte[] byArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, null);
        int n5 = 0;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                while (resultSet.next() && n5 < n4) {
                    nArray[n5++] = ((OracleResultSet)resultSet).getInt(2);
                }
                resultSet.close();
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                while (resultSet.next() && n5 < n4) {
                    dArray[n5++] = ((OracleResultSet)resultSet).getDouble(2);
                }
                resultSet.close();
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                while (resultSet.next() && n5 < n4) {
                    fArray[n5++] = ((OracleResultSet)resultSet).getFloat(2);
                }
                resultSet.close();
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                while (resultSet.next() && n5 < n4) {
                    lArray[n5++] = ((OracleResultSet)resultSet).getLong(2);
                }
                resultSet.close();
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                while (resultSet.next() && n5 < n4) {
                    sArray[n5++] = ((OracleResultSet)resultSet).getShort(2);
                }
                resultSet.close();
                objectArray = sArray;
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object toNumericArray(ARRAY aRRAY, long l2, int n2, int n3, boolean bl) throws SQLException {
        try {
            OracleType oracleType;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aRRAY) + ", " + OracleLog.argument(l2) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!((oracleType = this.getElementType()) instanceof OracleTypeNUMBER) && !(oracleType instanceof OracleTypeFLOAT)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object object = null;
            if (aRRAY.objArray != null) {
                int n4;
                if (n3 == 4 && aRRAY.objArray instanceof int[]) {
                    n4 = ((int[])aRRAY.objArray).length;
                    if (l2 > (long)n4) {
                        int[] nArray = new int[]{};
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        int[] nArray2 = nArray;
                        return nArray2;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    int[] nArray = new int[n4];
                    System.arraycopy(aRRAY.objArray, (int)l2 - 1, nArray, 0, n4);
                    object = nArray;
                } else if (n3 == 5 && aRRAY.objArray instanceof double[]) {
                    n4 = ((double[])aRRAY.objArray).length;
                    if (l2 > (long)n4) {
                        double[] dArray = new double[]{};
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        double[] dArray2 = dArray;
                        return dArray2;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    double[] dArray = new double[n4];
                    System.arraycopy(aRRAY.objArray, (int)l2 - 1, dArray, 0, n4);
                    object = dArray;
                } else if (n3 == 6 && aRRAY.objArray instanceof float[]) {
                    n4 = ((float[])aRRAY.objArray).length;
                    if (l2 > (long)n4) {
                        float[] fArray = new float[]{};
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + fArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        float[] fArray2 = fArray;
                        return fArray2;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    float[] fArray = new float[n4];
                    System.arraycopy(aRRAY.objArray, (int)l2 - 1, fArray, 0, n4);
                    object = fArray;
                } else if (n3 == 7 && aRRAY.objArray instanceof long[]) {
                    n4 = ((long[])aRRAY.objArray).length;
                    if (l2 > (long)n4) {
                        long[] lArray = new long[]{};
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        long[] lArray2 = lArray;
                        return lArray2;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    long[] lArray = new long[n4];
                    System.arraycopy(aRRAY.objArray, (int)l2 - 1, lArray, 0, n4);
                    object = lArray;
                } else if (n3 == 8 && aRRAY.objArray instanceof short[]) {
                    n4 = ((short[])aRRAY.objArray).length;
                    if (l2 > (long)n4) {
                        short[] sArray = new short[]{};
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        short[] sArray2 = sArray;
                        return sArray2;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    short[] sArray = new short[n4];
                    System.arraycopy(aRRAY.objArray, (int)l2 - 1, sArray, 0, n4);
                    object = sArray;
                }
            } else {
                if (aRRAY.datumArray != null) {
                    object = this.toNumericArray(aRRAY.datumArray, l2, n2, n3);
                } else if (aRRAY.locator != null) {
                    object = this.toNumericArrayFromLocator(aRRAY.locator, l2, n2, n3);
                } else if (aRRAY.shareBytes() != null) {
                    this.pickler.unlinearize(aRRAY.shareBytes(), aRRAY.imageOffset, aRRAY, l2, n2, n3, null);
                    object = aRRAY.locator != null ? this.toNumericArrayFromLocator(aRRAY.locator, l2, n2, n3) : aRRAY.objArray;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!bl) {
                    aRRAY.objArray = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getName(), (Connection)this.connection);
            oracleTypeADT.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.toid = ((OracleTypeADT)this.pickler).getTOID();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 60 + "Unable to resolve type: \"" + this.getName() + "\"");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return oracleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = 2003;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, datumArray);
        return this.pickler.linearize(aRRAY);
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        byte[] byArray = this.toBytes(datumArray);
        return byArray;
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
        int n2 = this.toLength(aRRAY);
        return n2;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        Datum[] datumArray = null;
        if (byArray != null) {
            ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
            datumArray = this.toOracleArray(aRRAY, 1L, -1, false);
        }
        return datumArray;
    }

    public Datum[] toArray(Object object) throws SQLException {
        Datum[] datumArray = this.toOracleArray(object, 1L, -1);
        return datumArray;
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, 1L, -1, map, false);
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, l2, n2, map, false);
        }
        return resultSet;
    }

    @Override
    String tagName() {
        return "ArrayDescriptor";
    }

    public static int getCacheStyle(ARRAY aRRAY) throws SQLException {
        int n2 = 2;
        if (aRRAY.getAutoIndexing() && (aRRAY.getAccessDirection() == 2 || aRRAY.getAccessDirection() == 3)) {
            n2 = 1;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.ArrayDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

