/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class Util {
    private static int[] ldsRoundTable = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkNextByte(InputStream inputStream, byte by) throws SQLException {
        block10: {
            try {
                if (inputStream.read() == by) break block10;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: 47parseTDS");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 47, "parseTDS");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readBytes(InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            int n3 = inputStream.read(byArray);
            if (n3 != n2) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void skipBytes(InputStream inputStream, int n2) throws SQLException {
        try {
            inputStream.skip(n2);
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLong(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            return (((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) * 256 + (byArray[2] & 0xFF)) * 256 + (byArray[3] & 0xFF);
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short readShort(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            return (short)((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF));
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte readByte(InputStream inputStream) throws SQLException {
        try {
            return (byte)inputStream.read();
        }
        catch (IOException iOException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Util.logger().log(Level.SEVERE, "         Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    static byte fdoGetSize(byte[] byArray, int n2) {
        byte by = Util.fdoGetEntry(byArray, n2);
        return (byte)(by >> 3 & 0x1F);
    }

    static byte fdoGetAlign(byte[] byArray, int n2) {
        byte by = Util.fdoGetEntry(byArray, n2);
        return (byte)(by & 7);
    }

    static int ldsRound(int n2, int n3) {
        int n4 = ldsRoundTable[n3];
        return (n2 >> n4) + 1 << n4;
    }

    private static byte fdoGetEntry(byte[] byArray, int n2) {
        short s2 = Util.getUnsignedByte(byArray[5]);
        byte by = byArray[6 + s2 + n2];
        return by;
    }

    public static short getUnsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    public static void printByteArray(byte[] byArray) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.Util"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

