/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class OracleTypeCLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1122821330765834411L;
    static int fixedDataSize = 86;
    transient OracleConnection connection;
    int form;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeCLOB() {
    }

    public OracleTypeCLOB(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        CLOB cLOB = null;
        if (object != null) {
            if (object instanceof CLOB) {
                cLOB = (CLOB)object;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeCLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return cLOB;
    }

    @Override
    public int getTypeCode() {
        return this.form == 2 ? 2011 : 2005;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            return this.connection.createClobWithUnpickledBytes(byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeCLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + byArray);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
    }

    @Override
    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    public void setForm(int n2) {
        this.form = n2;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeCLOB"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

