/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.internal.OracleConnection;

class OracleSavepoint
implements oracle.jdbc.OracleSavepoint {
    private static final int MAX_ID_VALUE = 0x7FFFFFFE;
    private static final int INVALID_ID_VALUE = -1;
    static final int NAMED_SAVEPOINT_TYPE = 2;
    static final int UNNAMED_SAVEPOINT_TYPE = 1;
    static final int UNKNOWN_SAVEPOINT_TYPE = 0;
    private static int s_seedId = 0;
    private int m_id = -1;
    private String m_name = null;
    private int m_type = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleSavepoint() {
        this.m_type = 1;
        this.m_id = this.getNextId();
        this.m_name = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleSavepoint(String string) throws SQLException {
        if (string != null && string.length() != 0 && !OracleSql.isValidObjectName(string)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSavepoint.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.m_type = 2;
        this.m_name = string;
        this.m_id = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSavepointId() throws SQLException {
        if (this.m_type == 2) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSavepoint.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 118);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 118);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSavepointName() throws SQLException {
        if (this.m_type == 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSavepoint.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 119);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 119);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.m_name;
    }

    int getType() {
        return this.m_type;
    }

    private synchronized int getNextId() {
        s_seedId = (s_seedId + 1) % 0x7FFFFFFE;
        return s_seedId;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleSavepoint"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

