/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new IllegalArgumentException();
        }
        this.lobOffset = l2;
        this.clob = cLOB;
        this.markedByte = -1L;
        this.endOfStream = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needBytes(int n2) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                int n3;
                block50: {
                    if (!this.endOfStream) {
                        try {
                            if (n2 > this.currentBufferSize) {
                                PhysicalConnection physicalConnection;
                                this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                                PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                synchronized (physicalConnection2) {
                                    this.resizableBuffer = physicalConnection.getByteBuffer(this.currentBufferSize);
                                    this.charBuf = physicalConnection.getCharBuffer(this.currentBufferSize);
                                }
                            }
                            this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                            for (n3 = 0; n3 < this.count; n3 += 1) {
                                this.resizableBuffer[n3] = (byte)this.charBuf[n3];
                            }
                            if (this.count < this.currentBufferSize) {
                                this.endOfStream = true;
                            }
                            if (this.count <= 0) break block50;
                            this.pos = 0;
                            this.lobOffset += (long)this.count;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            n3 = 1;
                            return n3 != 0;
                        }
                        catch (SQLException sQLException) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            IOException iOException = DatabaseError.createIOException(sQLException);
                            iOException.fillInStackTrace();
                            throw iOException;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n3 = 0;
                return n3 != 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureOpen() throws IOException {
        block10: {
            try {
                if (!this.closed) break block10;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + DatabaseError.findMessage(196, null));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public void markInternal(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + DatabaseError.findMessage(195, null));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IOException(DatabaseError.findMessage(195, null));
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l2) throws IOException {
        try {
            long l3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            long l4 = 0L;
            if ((long)(this.count - this.pos) >= l2) {
                this.pos = (int)((long)this.pos + l2);
                l4 += l2;
            } else {
                l4 += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    l3 = 0L;
                    l3 = this.clob.length() - this.lobOffset + 1L;
                    if (l3 >= l2 - l4) {
                        this.lobOffset += l2 - l4;
                        l4 += l2 - l4;
                    } else {
                        this.lobOffset += l3;
                        l4 += l3;
                    }
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l4);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l3 = l4;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            super.close();
        }
        finally {
            try {
                PhysicalConnection physicalConnection;
                PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection2) {
                    if (this.charBuf != null) {
                        physicalConnection.cacheBuffer(this.charBuf);
                        this.charBuf = null;
                    }
                    if (this.resizableBuffer != null) {
                        physicalConnection.cacheBuffer(this.resizableBuffer);
                        this.resizableBuffer = null;
                    }
                    this.currentBufferSize = 0;
                }
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

