/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.internal.OracleStatement;

class AutoKeyInfo
extends OracleResultSetMetaData {
    String originalSql;
    String newSql;
    String tableName;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    int sqlParserParamCount;
    String[] sqlParserParamList;
    boolean useNamedParameter;
    int current_argument;
    String[] columnNames;
    int[] columnIndexes;
    int numColumns;
    String[] tableColumnNames;
    int[] tableColumnTypes;
    int[] tableMaxLengths;
    boolean[] tableNullables;
    short[] tableFormOfUses;
    int[] tablePrecisions;
    int[] tableScales;
    String[] tableTypeNames;
    int autoKeyType;
    static final int KEYFLAG = 0;
    static final int COLUMNAME = 1;
    static final int COLUMNINDEX = 2;
    static final char QMARK = '?';
    int[] returnTypes;
    Accessor[] returnAccessors;
    private static final ThreadLocal<OracleSql> SQL_PARSER = new ThreadLocal(){

        protected OracleSql initialValue() {
            return new OracleSql(null);
        }
    };
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    AutoKeyInfo(String string) {
        this.originalSql = string;
        this.autoKeyType = 0;
    }

    AutoKeyInfo(String string, String[] stringArray) {
        this.originalSql = string;
        this.columnNames = stringArray;
        this.autoKeyType = 1;
    }

    AutoKeyInfo(String string, int[] nArray) {
        this.originalSql = string;
        this.columnIndexes = nArray;
        this.autoKeyType = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSql() throws SQLException {
        if (this.originalSql == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleSql oracleSql = SQL_PARSER.get();
        oracleSql.initialize(this.originalSql);
        this.sqlKind = oracleSql.getSqlKind();
        if (this.sqlKind == OracleStatement.SqlKind.INSERT) {
            this.sqlParserParamCount = oracleSql.getParameterCount();
            this.sqlParserParamList = oracleSql.getParameterList();
            if (this.sqlParserParamList == OracleSql.EMPTY_LIST) {
                this.useNamedParameter = false;
            } else {
                this.useNamedParameter = true;
                this.current_argument = this.sqlParserParamCount;
            }
        }
    }

    private String generateUniqueNamedParameter() {
        String string;
        boolean bl;
        block0: do {
            bl = false;
            string = Integer.toString(++this.current_argument).intern();
            for (int i2 = 0; i2 < this.sqlParserParamCount; ++i2) {
                if (this.sqlParserParamList[i2] != string) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        return ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNewSql() throws SQLException {
        try {
            if (this.newSql != null) {
                return this.newSql;
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.parseSql();
            }
            switch (this.autoKeyType) {
                case 0: {
                    this.newSql = this.originalSql + " RETURNING ROWID INTO " + (this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
                    this.returnTypes = new int[1];
                    this.returnTypes[0] = 104;
                    break;
                }
                case 1: {
                    this.getNewSqlByColumnName();
                    break;
                }
                case 2: {
                    this.getNewSqlByColumnIndexes();
                }
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.sqlParserParamList = null;
            return this.newSql;
        }
        catch (Exception exception) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exception);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exception);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private String getNewSqlByColumnName() throws SQLException {
        int n2;
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n2 = 0; n2 < this.columnNames.length; ++n2) {
            int n3;
            this.returnTypes[n2] = n3 = this.getReturnParamTypeCode(n2, this.columnNames[n2], this.columnIndexes);
            stringBuffer.append(this.columnNames[n2]);
            if (n2 >= this.columnNames.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n2 = 0; n2 < this.columnNames.length - 1; ++n2) {
            stringBuffer.append((this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        stringBuffer.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewSqlByColumnIndexes() throws SQLException {
        int n2;
        this.returnTypes = new int[this.columnIndexes.length];
        StringBuffer stringBuffer = new StringBuffer(this.originalSql);
        stringBuffer.append(" RETURNING ");
        for (n2 = 0; n2 < this.columnIndexes.length; ++n2) {
            int n3 = this.columnIndexes[n2] - 1;
            if (n3 < 0 || n3 > this.tableColumnNames.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n4 = this.tableColumnTypes[n3];
            String string = this.tableColumnNames[n3];
            this.returnTypes[n2] = n4;
            stringBuffer.append(string);
            if (n2 >= this.columnIndexes.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" INTO ");
        for (n2 = 0; n2 < this.columnIndexes.length - 1; ++n2) {
            stringBuffer.append((this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?')) + ", ");
        }
        stringBuffer.append(this.useNamedParameter ? this.generateUniqueNamedParameter() : Character.valueOf('?'));
        this.newSql = new String(stringBuffer);
        return this.newSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getReturnParamTypeCode(int n2, String string, int[] nArray) throws SQLException {
        for (int i2 = 0; i2 < this.tableColumnNames.length; ++i2) {
            if (!string.equalsIgnoreCase(this.tableColumnNames[i2])) continue;
            nArray[n2] = i2 + 1;
            return this.tableColumnTypes[i2];
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    final boolean isInsertSqlStmt() throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.parseSql();
        }
        return this.sqlKind == OracleStatement.SqlKind.INSERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTableName() throws SQLException {
        int n2;
        int n3;
        if (this.tableName != null) {
            return this.tableName;
        }
        String string = this.originalSql.trim().toUpperCase();
        int n4 = string.indexOf("INSERT");
        if ((n4 = string.indexOf("INTO", n4)) < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = string.length();
        for (n3 = n4 + 5; n3 < n5 && string.charAt(n3) == ' '; ++n3) {
        }
        if (n3 >= n5) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        for (n2 = n3 + 1; n2 < n5 && string.charAt(n2) != ' ' && string.charAt(n2) != '('; ++n2) {
        }
        if (n3 == n2 - 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.tableName = string.substring(n3, n2);
        return this.tableName;
    }

    void allocateSpaceForDescribedData(int n2) throws SQLException {
        this.numColumns = n2;
        this.tableColumnNames = new String[n2];
        this.tableColumnTypes = new int[n2];
        this.tableMaxLengths = new int[n2];
        this.tableNullables = new boolean[n2];
        this.tableFormOfUses = new short[n2];
        this.tablePrecisions = new int[n2];
        this.tableScales = new int[n2];
        this.tableTypeNames = new String[n2];
    }

    void fillDescribedData(int n2, String string, int n3, int n4, boolean bl, short s2, int n5, int n6, String string2) throws SQLException {
        this.tableColumnNames[n2] = string;
        this.tableColumnTypes[n2] = n3;
        this.tableMaxLengths[n2] = n4;
        this.tableNullables[n2] = bl;
        this.tableFormOfUses[n2] = s2;
        this.tablePrecisions[n2] = n5;
        this.tableScales[n2] = n6;
        this.tableTypeNames[n2] = string2;
    }

    void initMetaData(OracleReturnResultSet oracleReturnResultSet) throws SQLException {
        if (this.returnAccessors != null) {
            return;
        }
        this.returnAccessors = oracleReturnResultSet.returnAccessors;
        switch (this.autoKeyType) {
            case 0: {
                this.initMetaDataKeyFlag();
                break;
            }
            case 1: 
            case 2: {
                this.initMetaDataColumnIndexes();
            }
        }
    }

    void initMetaDataKeyFlag() throws SQLException {
        this.returnAccessors[0].columnName = "ROWID";
        this.returnAccessors[0].describeType = 104;
        this.returnAccessors[0].describeMaxLength = 4;
        this.returnAccessors[0].nullable = true;
        this.returnAccessors[0].precision = 0;
        this.returnAccessors[0].scale = 0;
        this.returnAccessors[0].formOfUse = 0;
    }

    void initMetaDataColumnIndexes() throws SQLException {
        for (int i2 = 0; i2 < this.returnAccessors.length; ++i2) {
            Accessor accessor = this.returnAccessors[i2];
            int n2 = this.columnIndexes[i2] - 1;
            accessor.columnName = this.tableColumnNames[n2];
            accessor.describeType = this.tableColumnTypes[n2];
            accessor.describeMaxLength = this.tableMaxLengths[n2];
            accessor.nullable = this.tableNullables[n2];
            accessor.precision = this.tablePrecisions[n2];
            accessor.scale = this.tablePrecisions[n2];
            accessor.formOfUse = this.tableFormOfUses[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getValidColumnIndex(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2 - 1;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.returnAccessors.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.returnAccessors[n2 - 1].columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.returnAccessors.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    AutoKeyInfo.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getTableName();
    }

    @Override
    Accessor[] getDescription() throws SQLException {
        return this.returnAccessors;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.AutoKeyInfo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

