/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.SocketException;
import java.util.Properties;
import oracle.dms.instrument.NounIntf;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public int port;
    public int tdu;
    public int sdu;
    public String protocol;
    public String host;
    public String sid;
    public String addr;
    public String service_name;
    public String instance_name;
    public StringBuffer conn_data = new StringBuffer();
    public String sslServerCertDN;
    public String origSSLServerCertDN;
    public String origServiceName;
    public String origSid;
    public boolean done;

    private NTAdapter getNT(Properties properties) throws NetException {
        block6: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block6;
                }
                if (this.protocol.equalsIgnoreCase("tcps")) {
                    this.nt = new TcpsNTAdapter(this.addr, properties);
                    this.origSSLServerCertDN = this.sslServerCertDN;
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
                    this.nt.setOption(8, stringArray);
                    break block6;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block6;
                }
                throw new NetException(21);
            }
            catch (NLException nLException) {
                throw new NetException(501);
            }
            catch (Exception exception) {
                throw new NetException(21);
            }
        }
        return this.nt;
    }

    public void connect(Properties properties, NounIntf nounIntf) throws IOException {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        this.nt = this.getNT(properties);
        this.nt.connect(nounIntf);
    }

    private void populateProtocol() throws NLException {
        NVPair nVPair = null;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = new NVFactory().createNVPair(this.addr);
        nVPair = nVNavigator.findNVPair(nVPair2, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nVPair.getAtom();
    }

    public void restoreFromOrigCoption(ConnOption connOption) throws IOException {
        this.origSSLServerCertDN = connOption.origSSLServerCertDN;
        this.origServiceName = connOption.origServiceName;
        this.origSid = connOption.origSid;
        this.conn_data = connOption.conn_data;
        if (this.protocol.equalsIgnoreCase("tcps")) {
            String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
            this.nt.setOption(8, stringArray);
        }
    }

    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", protocol=" + this.protocol + ", service_name=" + this.service_name + "\naddr=" + this.addr + "\nconn_data=" + this.conn_data + "\nsslServerCertDN=" + this.sslServerCertDN + ", origSSLServerCertDN=" + this.origSSLServerCertDN + ", origServiceName=" + this.origServiceName + ", origSid=" + this.origSid + ", done=" + this.done;
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }
}

