/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;

public abstract class OracleXADataSource
extends OracleConnectionPoolDataSource
implements XADataSource {
    protected boolean useNativeXA = false;
    protected boolean thinUseNativeXA = true;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXADataSource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.dataSourceName = "OracleXADataSource";
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public abstract XAConnection getXAConnection() throws SQLException;

    public abstract XAConnection getXAConnection(String var1, String var2) throws SQLException;

    public abstract XAConnection getXAConnection(Properties var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNativeXA(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.useNativeXA = bl;
            this.thinUseNativeXA = bl;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized boolean getNativeXA() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.useNativeXA);
                    }
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = this.useNativeXA;
            Object var6_8 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleXADataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        super.copy(oracleDataSource);
        ((OracleXADataSource)oracleDataSource).useNativeXA = this.useNativeXA;
        ((OracleXADataSource)oracleDataSource).thinUseNativeXA = this.thinUseNativeXA;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

