/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleFilteredRowSet() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Predicate predicate) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(predicate));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.predicate = predicate;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Predicate getFilter() {
        Predicate predicate;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.predicate);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            predicate = this.predicate;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.rowCount <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var4_9 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var12_12 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_17 = null;
                    OracleLog.recursiveExit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.presentRow >= this.rowCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var6_32 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_33 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl3 = false;
                Object var12_13 = null;
                if (!TRACE) return bl3;
                if (!OracleLog.recursiveEnter()) return bl3;
                try {}
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_19 = null;
                OracleLog.recursiveExit();
                return bl3;
            }
            boolean bl4 = false;
            do {
                ++this.presentRow;
                if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
                bl4 = true;
                break;
            } while (this.presentRow <= this.rowCount);
            if (bl4) {
                this.notifyCursorMoved();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var8_35 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_36 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl5 = true;
                Object var12_14 = null;
                if (!TRACE) return bl5;
                if (!OracleLog.recursiveEnter()) return bl5;
                try {}
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_21 = null;
                OracleLog.recursiveExit();
                return bl5;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var10_38 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var12_15 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var14_23 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        block45: {
            boolean bl;
            block43: {
                block41: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            }
                            Object var2_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (this.rowsetType == 1003) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleFilteredRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 344);
                                Object var4_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_11 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 344);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (this.rowCount > 0) break block41;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                            Object var6_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    boolean bl2 = false;
                    Object var14_16 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var16_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var16_22 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return bl2;
                }
                if (this.presentRow > 1) break block43;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var8_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl3 = false;
                Object var14_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl3;
            }
            try {
                boolean bl4 = false;
                do {
                    --this.presentRow;
                    if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
                    bl4 = true;
                    break;
                } while (this.presentRow >= 1);
                if (!bl4) break block45;
                this.notifyCursorMoved();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var10_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_40 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl = true;
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_29 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_25 = null;
                }
                catch (Throwable throwable) {
                    Object var16_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                Object var12_42 = null;
            }
            catch (Throwable throwable) {
                Object var12_43 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var14_19 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_27 = null;
            }
            catch (Throwable throwable) {
                Object var16_28 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n2) throws SQLException {
        block45: {
            boolean bl;
            int n3;
            int n4;
            block42: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowsetType == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleFilteredRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 344);
                            Object var5_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 344);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 != 0 && Math.abs(n2) <= this.rowCount) break block42;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var7_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl2 = false;
                Object var15_18 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl2;
            }
            try {
                n4 = n2 < 0 ? this.rowCount + n2 + 1 : n2;
                this.presentRow = 0;
                for (n3 = 0; n3 < n4 && this.presentRow <= this.rowCount; ++n3) {
                    if (this.next()) {
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                            Object var9_38 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_39 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    bl = false;
                    Object var15_19 = null;
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_31 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var17_32 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl;
            }
            if (n3 != n4) break block45;
            this.notifyCursorMoved();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    Object var11_41 = null;
                }
                catch (Throwable throwable) {
                    Object var11_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl3 = true;
            Object var15_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_27 = null;
                }
                catch (Throwable throwable) {
                    Object var17_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl3;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                Object var13_44 = null;
            }
            catch (Throwable throwable) {
                Object var13_45 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var15_21 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleFilteredRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_29 = null;
            }
            catch (Throwable throwable) {
                Object var17_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n2)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleFilteredRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 345);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 345);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleFilteredRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

