/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = -2066958142885801470L;
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag;
    private int updateRowPosition;
    private boolean updateRowFlag;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param;
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean executeCalled = false;
    private boolean driverManagerInitialized = false;
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private static final int MAX_BYTE_BUFFER_SIZE = 1024;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSet() throws SQLException {
        try {
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.presentRow = 0;
            this.previousColumnWasNull = false;
            this.param = new Vector();
            this.rows = new Vector();
            this.sqlWarning = new SQLWarning();
            try {
                this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
            }
            catch (SyncFactoryException syncFactoryException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 304);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 304);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setReader(new OracleCachedRowSetReader());
            this.setWriter(new OracleCachedRowSetWriter());
            this.currentPage = 0;
            this.pageSize = 0;
            this.isPopulateDone = false;
            this.keyColumns = null;
            this.tableName = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection() throws SQLException {
        Connection connection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    connection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Connection connection2 = this.getConnectionInternal();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection2);
                    }
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            connection = connection2;
            Object var6_8 = null;
            if (!TRACE) return connection;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return connection;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return connection;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + namingException.getMessage());
                            Object var6_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (this.getUrl() != null) {
                String string3;
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                            Object var8_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_15 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement getStatement() throws SQLException {
        Statement statement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    statement = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 305);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 305);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Statement statement2 = this.resultSet.getStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + statement2);
                    }
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            statement = statement2;
            Object var8_12 = null;
            if (!TRACE) return statement;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return statement;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return statement;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetReader getReader() {
        RowSetReader rowSetReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.reader);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetReader = this.reader;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rowSetReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetWriter getWriter() {
        RowSetWriter rowSetWriter;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.writer);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetWriter = this.writer;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rowSetWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.rowsetType == 1005) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 306);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 306);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            switch (n2) {
                case 1000: 
                case 1002: {
                    this.presentRow = 0;
                    break;
                }
                case 1001: {
                    if (this.rowsetType == 1003) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 307);
                                Object var7_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_12 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 307);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    this.presentRow = this.rowCount + 1;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 308);
                            Object var9_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 308);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            super.setFetchDirection(n2);
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommand(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            super.setCommand(string);
            this.osql = string == null || string.equals("") ? null : new OracleSqlForRowSet(string);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(RowSetReader rowSetReader) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetReader));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.reader = rowSetReader;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(RowSetWriter rowSetWriter) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetWriter));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.writer = rowSetWriter;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getColumnIndex(String string) throws SQLException {
        int n2;
        if (string == null || string.equals("")) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + string);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        string = string.toUpperCase();
        for (n2 = 0; n2 < this.metaData.length && !string.equals(this.metaData[n2]); ++n2) {
        }
        if (n2 >= this.metaData.length) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6 + string);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, string);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 1 || n2 > this.colCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 310 + "" + n2);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 310, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
        this.presentRow = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized InputStream getStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = null;
            PipedOutputStream pipedOutputStream = null;
            bufferedReader = new BufferedReader((Reader)object);
            int n3 = 0;
            PipedInputStream pipedInputStream = new PipedInputStream();
            pipedOutputStream = new PipedOutputStream(pipedInputStream);
            while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                pipedOutputStream.write(n3);
            }
            PipedInputStream pipedInputStream2 = pipedInputStream;
            Object var11_11 = null;
            try {
                if (bufferedReader != null) {
                    ((Reader)bufferedReader).close();
                }
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                        Object var14_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                if (pipedOutputStream == null) return pipedInputStream2;
                pipedOutputStream.close();
                return pipedInputStream2;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                        Object var16_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (IOException iOException) {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException.getMessage());
                            Object var9_33 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    try {
                        if (bufferedReader != null) {
                            ((Reader)bufferedReader).close();
                        }
                    }
                    catch (IOException iOException2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException2.getMessage());
                                Object var14_19 = null;
                            }
                            catch (Throwable throwable2) {
                                Object var14_20 = null;
                                OracleLog.recursiveExit();
                                throw throwable2;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException2.getMessage());
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    try {
                        if (pipedOutputStream == null) throw throwable;
                        pipedOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException3) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 311 + iOException3.getMessage());
                                Object var16_29 = null;
                            }
                            catch (Throwable throwable3) {
                                Object var16_30 = null;
                                OracleLog.recursiveExit();
                                throw throwable3;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 311, iOException3.getMessage());
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 312);
                Object var18_37 = null;
            }
            catch (Throwable throwable) {
                Object var18_38 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 312);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private final Calendar getSessionCalendar(Connection connection) {
        Calendar calendar;
        String string = ((OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setID(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private boolean isStreamType(int n2) {
        return n2 == 2004 || n2 == 2005 || n2 == -4 || n2 == -1;
    }

    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isExecuteCalled() {
        return this.executeCalled;
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 313);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 313);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean next() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.rowCount < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var4_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var20_17 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_26 = null;
                    OracleLog.recursiveExit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var22_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
                if (this.presentRow + 1 <= this.rowCount) {
                    ++this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl3 = this.next();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl3);
                                }
                                Object var6_53 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var6_54 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        boolean bl4 = bl3;
                        Object var20_18 = null;
                        if (!TRACE) return bl4;
                        if (!OracleLog.recursiveEnter()) return bl4;
                        try {}
                        catch (Throwable throwable) {
                            Object var22_29 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var22_28 = null;
                        OracleLog.recursiveExit();
                        return bl4;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            Object var8_56 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var8_57 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl5 = true;
                    Object var20_19 = null;
                    if (!TRACE) return bl5;
                    if (!OracleLog.recursiveEnter()) return bl5;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_30 = null;
                    OracleLog.recursiveExit();
                    return bl5;
                }
                this.presentRow = this.rowCount + 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var10_59 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_60 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl6 = false;
                Object var20_20 = null;
                if (!TRACE) return bl6;
                if (!OracleLog.recursiveEnter()) return bl6;
                try {}
                catch (Throwable throwable) {
                    Object var22_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_32 = null;
                OracleLog.recursiveExit();
                return bl6;
            }
            if (this.fetchDirection == 1001) {
                if (this.presentRow - 1 > 0) {
                    --this.presentRow;
                    if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                        boolean bl7 = this.next();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl7);
                                }
                                Object var12_62 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var12_63 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        boolean bl8 = bl7;
                        Object var20_21 = null;
                        if (!TRACE) return bl8;
                        if (!OracleLog.recursiveEnter()) return bl8;
                        try {}
                        catch (Throwable throwable) {
                            Object var22_35 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var22_34 = null;
                        OracleLog.recursiveExit();
                        return bl8;
                    }
                    this.notifyCursorMoved();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                            Object var14_65 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var14_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl9 = true;
                    Object var20_22 = null;
                    if (!TRACE) return bl9;
                    if (!OracleLog.recursiveEnter()) return bl9;
                    try {}
                    catch (Throwable throwable) {
                        Object var22_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_36 = null;
                    OracleLog.recursiveExit();
                    return bl9;
                }
                this.presentRow = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var16_68 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var16_69 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl10 = false;
                Object var20_23 = null;
                if (!TRACE) return bl10;
                if (!OracleLog.recursiveEnter()) return bl10;
                try {}
                catch (Throwable throwable) {
                    Object var22_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_38 = null;
                OracleLog.recursiveExit();
                return bl10;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var18_71 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var18_72 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var20_24 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var20_25 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var22_43 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var22_42 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var22_41 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var22_40 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean previous() throws SQLException {
        block59: {
            block60: {
                block61: {
                    block56: {
                        block57: {
                            block58: {
                                block55: {
                                    boolean bl;
                                    try {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                if (OracleLog.enter()) {
                                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                                                }
                                                Object var2_1 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var2_2 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if (this.rowCount >= 0) break block55;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                if (OracleLog.isPublic()) {
                                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                                }
                                                Object var4_14 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_15 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        bl = false;
                                        Object var20_17 = null;
                                        if (!TRACE) return bl;
                                    }
                                    catch (Throwable throwable) {
                                        Object var20_25 = null;
                                        if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                                        try {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var22_42 = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var22_43 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable2;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                            throw throwable;
                                        }
                                    }
                                    if (!OracleLog.recursiveEnter()) return bl;
                                    try {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var22_26 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_27 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    return bl;
                                }
                                if (this.fetchDirection != 1001) break block56;
                                if (this.presentRow + 1 > this.rowCount) break block57;
                                ++this.presentRow;
                                if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block58;
                                boolean bl = this.previous();
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.isPublic()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                                        }
                                        Object var6_53 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_54 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                boolean bl2 = bl;
                                Object var20_18 = null;
                                if (!TRACE) return bl2;
                                if (!OracleLog.recursiveEnter()) return bl2;
                                try {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var22_28 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var22_29 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                return bl2;
                            }
                            this.notifyCursorMoved();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    }
                                    Object var8_56 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var8_57 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            boolean bl = true;
                            Object var20_19 = null;
                            if (!TRACE) return bl;
                            if (!OracleLog.recursiveEnter()) return bl;
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var22_30 = null;
                            }
                            catch (Throwable throwable) {
                                Object var22_31 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            return bl;
                        }
                        this.presentRow = this.rowCount + 1;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                }
                                Object var10_59 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_60 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        boolean bl = false;
                        Object var20_20 = null;
                        if (!TRACE) return bl;
                        if (!OracleLog.recursiveEnter()) return bl;
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var22_32 = null;
                        }
                        catch (Throwable throwable) {
                            Object var22_33 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        return bl;
                    }
                    if (this.fetchDirection != 1000 && this.fetchDirection != 1002) break block59;
                    if (this.presentRow - 1 <= 0) break block60;
                    --this.presentRow;
                    if (this.showDeleted || !this.getCurrentRow().isRowDeleted()) break block61;
                    boolean bl = this.previous();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                            }
                            Object var12_62 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_63 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    boolean bl3 = bl;
                    Object var20_21 = null;
                    if (!TRACE) return bl3;
                    if (!OracleLog.recursiveEnter()) return bl3;
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var22_34 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_35 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    return bl3;
                }
                this.notifyCursorMoved();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var14_65 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_66 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl = true;
                Object var20_22 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_36 = null;
                }
                catch (Throwable throwable) {
                    Object var22_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                return bl;
            }
            this.presentRow = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var16_68 = null;
                }
                catch (Throwable throwable) {
                    Object var16_69 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl = false;
            Object var20_23 = null;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_38 = null;
            }
            catch (Throwable throwable) {
                Object var22_39 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                Object var18_71 = null;
            }
            catch (Throwable throwable) {
                Object var18_72 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var20_24 = null;
        if (!TRACE) return bl;
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var22_40 = null;
        }
        catch (Throwable throwable) {
            Object var22_41 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        try {
            boolean bl2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl3 = bl2 = this.rowCount > 0 && this.presentRow == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_13 = null;
            }
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        try {
            boolean bl2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl3 = bl2 = this.rowCount > 0 && this.presentRow == this.rowCount + 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        boolean bl;
        try {
            boolean bl2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl3 = bl2 = this.presentRow == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        boolean bl;
        try {
            boolean bl2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl3 = bl2 = this.presentRow == this.rowCount;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.presentRow = 0;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.presentRow = this.rowCount + 1;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean first() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean bl2 = this.absolute(1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = bl2;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean last() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.absolute(-1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_13 = null;
            }
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n2) throws SQLException {
        block26: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowsetType == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 314);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 314);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n2 != 0 && Math.abs(n2) <= this.rowCount) break block26;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl = false;
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var13_21 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var13_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.notifyCursorMoved();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                Object var9_26 = null;
            }
            catch (Throwable throwable) {
                Object var9_27 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = true;
        Object var11_15 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean relative(int n2) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.absolute(this.presentRow + n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populate(ResultSet resultSet) throws SQLException {
        try {
            int n2;
            OracleRow oracleRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet));
                    }
                    oracleRow = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.rows == null) {
                this.rows = new Vector(50, 10);
            } else {
                this.rows.clear();
            }
            this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
            this.colCount = this.rowsetMetaData.getColumnCount();
            this.metaData = new String[this.colCount];
            for (n2 = 0; n2 < this.colCount; ++n2) {
                this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
            }
            if (!(resultSet instanceof OracleCachedRowSet)) {
                this.populateInit(resultSet);
            }
            n2 = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
            this.rowCount = 0;
            oracleRow = null;
            int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
            if (resultSet.getType() != 1003 && this.rows.size() == 0 && n2 == 0) {
                resultSet.afterLast();
            }
            boolean bl = false;
            while (this.rowCount < n3) {
                if (n2 != 0) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                } else if (!resultSet.previous()) {
                    bl = true;
                    break;
                }
                oracleRow = new OracleRow(this.colCount);
                for (int i2 = 1; i2 <= this.colCount; ++i2) {
                    Object object = null;
                    try {
                        object = resultSet.getObject(i2, this.typeMap);
                    }
                    catch (Exception exception) {
                        object = resultSet.getObject(i2);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        object = resultSet.getObject(i2);
                    }
                    if (object instanceof Clob || object instanceof CLOB) {
                        oracleRow.setColumnValue(i2, new OracleSerialClob((Clob)object));
                    } else if (object instanceof Blob || object instanceof BLOB) {
                        oracleRow.setColumnValue(i2, new OracleSerialBlob((Blob)object));
                    } else {
                        oracleRow.setColumnValue(i2, object);
                    }
                    oracleRow.markOriginalNull(i2, resultSet.wasNull());
                }
                if (n2 != 0) {
                    this.rows.add(oracleRow);
                } else {
                    this.rows.add(1, oracleRow);
                }
                ++this.rowCount;
            }
            if (bl || n2 != 0 && resultSet.isAfterLast() || n2 == 0 && resultSet.isBeforeFirst()) {
                this.isPopulateDone = true;
            }
            this.connection = null;
            this.notifyRowSetChanged();
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearParameters() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.param = null;
            this.param = new Vector();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.previousColumnWasNull);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.previousColumnWasNull;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.release();
            this.isClosed = true;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlWarning);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            sQLWarning = this.sqlWarning;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearWarnings() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.sqlWarning = null;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetMetaData);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            resultSetMetaData = this.rowsetMetaData;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = this.getColumnIndex(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getParams() throws SQLException {
        Object[] objectArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    objectArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object[] objectArray2 = this.param.toArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            objectArray = objectArray2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetMetaData));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rowsetMetaData = rowSetMetaData;
            if (rowSetMetaData != null) {
                this.colCount = rowSetMetaData.getColumnCount();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void execute() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.isConnectionStayingOpenForTxnControl = false;
            this.getReader().readData(this);
            this.executeCalled = true;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptChanges() throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                this.getWriter().writeData(this);
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SyncProviderException: " + sQLException.getMessage());
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new SyncProviderException(sQLException.getMessage());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptChanges(Connection connection) throws SyncProviderException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = connection;
            this.isConnectionStayingOpenForTxnControl = true;
            this.acceptChanges();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Object clone() throws CloneNotSupportedException {
        try {
            CachedRowSet cachedRowSet;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    cachedRowSet = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                CachedRowSet cachedRowSet2 = this.createCopy();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cachedRowSet2);
                        }
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                cachedRowSet = cachedRowSet2;
            }
            catch (SQLException sQLException) {
                if (!TRACE) throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
                if (!OracleLog.recursiveEnter()) throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing CloneNotSupportedException: " + "SQL Error occured while cloning: " + sQLException.getMessage());
                    Object var6_17 = null;
                    OracleLog.recursiveExit();
                    throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
                }
                catch (Throwable throwable) {
                    Object var6_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_9 = null;
            if (!TRACE) return cachedRowSet;
            if (!OracleLog.recursiveEnter()) return cachedRowSet;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_11 = null;
                OracleLog.recursiveExit();
                return cachedRowSet;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = (OracleCachedRowSet)this.createShared();
            int n2 = this.rows.size();
            oracleCachedRowSet2.rows = new Vector(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                oracleCachedRowSet2.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet2);
                    }
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            oracleCachedRowSet = oracleCachedRowSet2;
            Object var7_11 = null;
            if (!TRACE) return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return oracleCachedRowSet;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowSet createShared() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = new OracleCachedRowSet();
            oracleCachedRowSet2.rows = this.rows;
            oracleCachedRowSet2.setDataSource(this.getDataSource());
            oracleCachedRowSet2.setDataSourceName(this.getDataSourceName());
            oracleCachedRowSet2.setUsername(this.getUsername());
            oracleCachedRowSet2.setPassword(this.getPassword());
            oracleCachedRowSet2.setUrl(this.getUrl());
            oracleCachedRowSet2.setTypeMap(this.getTypeMap());
            oracleCachedRowSet2.setMaxFieldSize(this.getMaxFieldSize());
            oracleCachedRowSet2.setMaxRows(this.getMaxRows());
            oracleCachedRowSet2.setQueryTimeout(this.getQueryTimeout());
            oracleCachedRowSet2.setFetchSize(this.getFetchSize());
            oracleCachedRowSet2.setEscapeProcessing(this.getEscapeProcessing());
            oracleCachedRowSet2.setConcurrency(this.getConcurrency());
            oracleCachedRowSet2.setReadOnly(this.readOnly);
            this.rowsetType = this.getType();
            this.fetchDirection = this.getFetchDirection();
            oracleCachedRowSet2.setCommand(this.getCommand());
            oracleCachedRowSet2.setTransactionIsolation(this.getTransactionIsolation());
            oracleCachedRowSet2.presentRow = this.presentRow;
            oracleCachedRowSet2.colCount = this.colCount;
            oracleCachedRowSet2.rowCount = this.rowCount;
            oracleCachedRowSet2.showDeleted = this.showDeleted;
            oracleCachedRowSet2.syncProvider = this.syncProvider;
            oracleCachedRowSet2.currentPage = this.currentPage;
            oracleCachedRowSet2.pageSize = this.pageSize;
            oracleCachedRowSet2.tableName = this.tableName == null ? null : this.tableName;
            oracleCachedRowSet2.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
            int n3 = this.listener.size();
            for (n2 = 0; n2 < n3; ++n2) {
                oracleCachedRowSet2.listener.add(this.listener.elementAt(n2));
            }
            oracleCachedRowSet2.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
            n3 = this.param.size();
            for (n2 = 0; n2 < n3; ++n2) {
                oracleCachedRowSet2.param.add(this.param.elementAt(n2));
            }
            oracleCachedRowSet2.metaData = new String[this.metaData.length];
            System.arraycopy(this.metaData, 0, oracleCachedRowSet2.metaData, 0, this.metaData.length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet2);
                    }
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = oracleCachedRowSet2;
            Object var7_11 = null;
            if (!TRACE) return oracleCachedRowSet;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_15 = null;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleCachedRowSet;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rows = null;
            this.rows = new Vector();
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            this.rowCount = 0;
            this.presentRow = 0;
            this.notifyRowSetChanged();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreOriginal() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl = false;
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
                if (oracleRow.isRowInserted()) {
                    this.rows.remove(i2);
                    --this.rowCount;
                    --i2;
                    bl = true;
                    continue;
                }
                if (oracleRow.isRowUpdated()) {
                    oracleRow.setRowUpdated(false);
                    bl = true;
                    continue;
                }
                if (!oracleRow.isRowDeleted()) continue;
                oracleRow.setRowDeleted(false);
                bl = true;
            }
            if (!bl) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 315);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 315);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.notifyRowSetChanged();
            this.presentRow = 0;
            Object var7_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_15 = null;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection() throws SQLException {
        Collection collection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
            try {
                for (int i2 = 0; i2 < this.rowCount; ++i2) {
                    map.put(i2, ((OracleRow)this.rows.elementAt(i2)).toCollection());
                }
            }
            catch (Exception exception) {
                map = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 316);
                        Object var4_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 316);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Collection collection2 = map.values();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + collection2);
                    }
                    Object var6_13 = null;
                }
                catch (Throwable throwable) {
                    Object var6_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            collection = collection2;
            Object var8_16 = null;
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_18 = null;
            }
            catch (Throwable throwable) {
                Object var10_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection(int n2) throws SQLException {
        Vector<Object> vector;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 < 1 || n2 > this.colCount) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + n2);
                        Object var5_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Vector<Object> vector2 = new Vector<Object>(this.rowCount);
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
                Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
                vector2.add(object);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + vector2);
                    }
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            vector = vector2;
            Object var9_17 = null;
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_19 = null;
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection(String string) throws SQLException {
        Collection collection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    collection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Collection collection2 = this.toCollection(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + collection2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            collection = collection2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        block22: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.presentRow <= this.rowCount) break block22;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                        }
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = this.rowCount;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.presentRow);
                }
                Object var6_21 = null;
            }
            catch (Throwable throwable) {
                Object var6_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = this.presentRow;
        Object var8_10 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelRowInsert() throws SQLException {
        try {
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    var2_1 = null;
                }
                catch (Throwable var1_3) {
                    var2_2 = null;
                    OracleLog.recursiveExit();
                    throw var1_3;
                }
                OracleLog.recursiveExit();
            }
            if (this.getCurrentRow().isRowInserted()) {
                this.rows.remove(--this.presentRow);
                --this.rowCount;
            } else {
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                        var4_5 = null;
                    }
                    catch (Throwable var3_7) {
                        var4_6 = null;
                        OracleLog.recursiveExit();
                        throw var3_7;
                    }
                    OracleLog.recursiveExit();
                }
                var1_4 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                var1_4.fillInStackTrace();
                throw var1_4;
            }
            this.notifyRowChanged();
            var6_8 = null;
            if (OracleCachedRowSet.TRACE == false) return;
            ** GOTO lbl55
        }
        catch (Throwable var5_16) {
            var6_9 = null;
            if (OracleCachedRowSet.TRACE == false) throw var5_16;
            if (OracleLog.recursiveEnter() == false) throw var5_16;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var8_12 = null;
            }
            catch (Throwable var7_15) {
                var8_13 = null;
                OracleLog.recursiveExit();
                throw var7_15;
            }
lbl55:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return;
            try {}
            catch (Throwable var7_14) {
                var8_11 = null;
                OracleLog.recursiveExit();
                throw var7_14;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var8_10 = null;
            OracleLog.recursiveExit();
            return;
            OracleLog.recursiveExit();
            throw var5_16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowDelete() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.getCurrentRow().isRowDeleted()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 318);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 318);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.getCurrentRow().setRowDeleted(false);
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.getCurrentRow().isRowUpdated()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(false);
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 317);
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 317);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.insertRow.isRowFullyPopulated()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 320);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 320);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRow.insertRow();
            this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
            this.insertRowFlag = false;
            ++this.rowCount;
            this.notifyRowChanged();
            Object var10_16 = null;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.updateRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 319);
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 319);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.updateRowFlag = false;
            this.getCurrentRow().setRowUpdated(true);
            this.notifyRowChanged();
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.getCurrentRow().setRowDeleted(true);
            this.notifyRowChanged();
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        try {
            OracleRow oracleRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((oracleRow = this.getCurrentRow()).isRowUpdated()) {
                oracleRow.cancelRowUpdates();
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRow = new OracleRow(this.colCount, true);
            this.insertRowFlag = true;
            this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isReadOnly()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 309);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 309);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.insertRowFlag = false;
            this.updateRowFlag = false;
            this.absolute(this.presentRow);
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowUpdated() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.getCurrentRow().isRowUpdated();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rowInserted() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean bl2 = this.getCurrentRow().isRowInserted();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = bl2;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean rowDeleted() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean bl2 = this.getCurrentRow().isRowDeleted();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = bl2;
            Object var6_9 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_11 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            OracleRow oracleRow;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    oracleRow = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = new OracleCachedRowSet();
            oracleCachedRowSet2.rowsetMetaData = this.rowsetMetaData;
            oracleCachedRowSet2.rowCount = 1;
            oracleCachedRowSet2.colCount = this.colCount;
            oracleCachedRowSet2.presentRow = 0;
            oracleCachedRowSet2.setReader(null);
            oracleCachedRowSet2.setWriter(null);
            oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
            oracleCachedRowSet2.rows.add(oracleRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = oracleCachedRowSet2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getOriginal() throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
            oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
            oracleCachedRowSet.rowCount = this.rowCount;
            oracleCachedRowSet.colCount = this.colCount;
            oracleCachedRowSet.presentRow = 0;
            oracleCachedRowSet.setType(1004);
            oracleCachedRowSet.setConcurrency(1008);
            oracleCachedRowSet.setReader(null);
            oracleCachedRowSet.setWriter(null);
            int n2 = this.rowsetMetaData.getColumnCount();
            OracleRow oracleRow = null;
            object = this.rows.iterator();
            while (object.hasNext()) {
                oracleRow = new OracleRow(n2, ((OracleRow)object.next()).getOriginalRow());
                oracleCachedRowSet.rows.add(oracleRow);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet);
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = oracleCachedRowSet;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, null);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n2, int n3, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(string));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{n3, string};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, bl);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setByte(int n2, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(by));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, new Byte(by));
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void setShort(int n2, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(s2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, s2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, n3);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void setLong(int var1_1, long var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int n2, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, Float.valueOf(f2));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDouble(int n2, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                    }
                    Object var5_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, d2);
            Object var7_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bigDecimal));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, bigDecimal);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, string);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(byArray));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, byArray);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n2, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, date);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setTime(int n2, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, time);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObject(int n2, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, object);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRef(int n2, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(ref));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, ref);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setBlob(int n2, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(blob));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, blob);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n2, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clob));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, clob);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(int n2, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(array));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, array);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 2};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(calendar));
                    }
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{time, calendar};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(calendar));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{timestamp, calendar};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, timestamp);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 3};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{inputStream, n3, 1};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{reader, n3, 4};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{object, n3, n4};
            this.param.add(n2 - 1, objectArray);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{object, n3};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n2, java.sql.Date date, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(calendar));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkParamIndex(n2);
            Object[] objectArray = new Object[]{date, calendar};
            this.param.add(n2 - 1, objectArray);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setURL(int n2, URL uRL) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(uRL));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkParamIndex(n2);
            this.param.add(n2 - 1, uRL.toString());
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(int n2) throws SQLException {
        Object object;
        try {
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    object2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = this.presentRow * this.colCount + n2 - 1;
            object2 = null;
            object2 = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
            boolean bl = this.previousColumnWasNull = object2 == null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private synchronized Number getNumber(int n2) throws SQLException {
        try {
            Object object;
            Serializable serializable;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    serializable = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof BigDecimal || object instanceof Number) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Number)object);
                        }
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                serializable = (Number)object;
                Object var15_13 = null;
                if (!TRACE) return serializable;
                if (!OracleLog.recursiveEnter()) return serializable;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_17 = null;
                    OracleLog.recursiveExit();
                    return serializable;
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (object instanceof Boolean) {
                serializable = Integer.valueOf((Boolean)object != false ? 1 : 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + serializable);
                        }
                        Object var7_29 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Number number = serializable;
                Object var15_14 = null;
                if (!TRACE) return number;
                if (!OracleLog.recursiveEnter()) return number;
                try {}
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_19 = null;
                OracleLog.recursiveExit();
                return number;
            }
            if (object instanceof String) {
                Serializable serializable2;
                try {
                    serializable = new BigDecimal((String)object);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + serializable);
                            }
                            Object var9_32 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_33 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    serializable2 = serializable;
                }
                catch (NumberFormatException numberFormatException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                            Object var11_35 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var11_36 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Object var15_15 = null;
                if (!TRACE) return serializable2;
                if (!OracleLog.recursiveEnter()) return serializable2;
                try {}
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_21 = null;
                OracleLog.recursiveExit();
                return serializable2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    Object var13_38 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            ((Throwable)serializable).fillInStackTrace();
            throw serializable;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object2 = this.getObject(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        SQLException sQLException;
        block37: {
            boolean bl;
            Object object;
            block35: {
                block33: {
                    boolean bl2;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.enter()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                                }
                                sQLException = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        if ((object = this.getObject(n2)) != null) break block33;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                                }
                                Object var5_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        bl2 = false;
                        Object var13_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var15_24 = null;
                            }
                            catch (Throwable throwable2) {
                                Object var15_25 = null;
                                OracleLog.recursiveExit();
                                throw throwable2;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        throw throwable;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var15_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return bl2;
                }
                if (!(object instanceof Boolean)) break block35;
                boolean bl3 = (Boolean)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl3);
                        }
                        Object var7_30 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                boolean bl4 = bl3;
                Object var13_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return bl4;
            }
            if (!(object instanceof Number)) break block37;
            boolean bl5 = bl = ((Number)object).doubleValue() != 0.0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                    Object var9_33 = null;
                }
                catch (Throwable throwable) {
                    Object var9_34 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl6 = bl;
            Object var13_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_22 = null;
                }
                catch (Throwable throwable) {
                    Object var15_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl6;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var11_36 = null;
            }
            catch (Throwable throwable) {
                Object var11_37 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        Serializable serializable;
        block68: {
            Object object;
            block66: {
                block64: {
                    block62: {
                        block60: {
                            block58: {
                                byte by;
                                try {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            if (OracleLog.enter()) {
                                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                                            }
                                            serializable = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_3 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    if ((object = this.getObject(n2)) != null) break block58;
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            if (OracleLog.isPublic()) {
                                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                                            }
                                            Object var5_9 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_10 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    by = 0;
                                    Object var21_21 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var21_27 = null;
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var23_40 = null;
                                        }
                                        catch (Throwable throwable2) {
                                            Object var23_41 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable2;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    throw throwable;
                                }
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var23_28 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_29 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                return by;
                            }
                            if (!(object instanceof BigDecimal)) break block60;
                            serializable = (BigDecimal)object;
                            if (((BigDecimal)serializable).compareTo(new BigDecimal(127)) == 1 || ((BigDecimal)serializable).compareTo(new BigDecimal(-128)) == -1) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26);
                                        Object var7_49 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_50 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26);
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            byte by = ((Number)serializable).byteValue();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                                    }
                                    Object var9_52 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_53 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            byte by2 = by;
                            Object var21_22 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var23_30 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var23_31 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return by2;
                        }
                        if (!(object instanceof Number)) break block62;
                        byte by = ((Number)object).byteValue();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                                }
                                Object var11_55 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_56 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        byte by3 = by;
                        Object var21_23 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var23_32 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_33 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return by3;
                    }
                    if (!(object instanceof String)) break block64;
                    byte by = ((String)object).getBytes()[0];
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                            }
                            Object var13_58 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_59 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    byte by4 = by;
                    Object var21_24 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var23_34 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_35 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return by4;
                }
                if (!(object instanceof OracleSerialBlob)) break block66;
                serializable = (OracleSerialBlob)object;
                byte by = ((OracleSerialBlob)serializable).getBytes(1L, 1)[0];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                        }
                        Object var15_61 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_62 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byte by5 = by;
                Object var21_25 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var23_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_37 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return by5;
            }
            if (!(object instanceof OracleSerialClob)) break block68;
            serializable = (OracleSerialClob)object;
            byte by = ((OracleSerialClob)serializable).getSubString(1L, 1).getBytes()[0];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                    }
                    Object var17_64 = null;
                }
                catch (Throwable throwable) {
                    Object var17_65 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte by6 = by;
            Object var21_26 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_38 = null;
                }
                catch (Throwable throwable) {
                    Object var23_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return by6;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var19_67 = null;
            }
            catch (Throwable throwable) {
                Object var19_68 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        ((Throwable)serializable).fillInStackTrace();
        throw serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        short s2;
        try {
            Number number;
            short s3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short s4 = s3 = (number = this.getNumber(n2)) == null ? (short)0 : number.shortValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = s3;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int getInt(int n2) throws SQLException {
        int n3;
        try {
            Number number;
            int n4;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n5 = n4 = (number = this.getNumber(n2)) == null ? 0 : number.intValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n4);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n3 = n4;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        long l2;
        try {
            Number number;
            long l3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long l4 = l3 = (number = this.getNumber(n2)) == null ? 0L : number.longValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l3);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = l3;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        float f2;
        try {
            Number number;
            float f3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            float f4 = f3 = (number = this.getNumber(n2)) == null ? 0.0f : number.floatValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            f2 = f3;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        double d2;
        try {
            Number number;
            double d3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            double d4 = d3 = (number = this.getNumber(n2)) == null ? 0.0 : number.doubleValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d3);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            d2 = d3;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Number number;
        BigDecimal bigDecimal;
        block22: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        bigDecimal = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((number = this.getNumber(n2)) != null && !(number instanceof BigDecimal)) break block22;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BigDecimal)number);
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bigDecimal = (BigDecimal)number;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_17 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bigDecimal;
        }
        bigDecimal = new BigDecimal(number.doubleValue());
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                }
                Object var7_22 = null;
            }
            catch (Throwable throwable) {
                Object var7_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        BigDecimal bigDecimal2 = bigDecimal;
        Object var9_11 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bigDecimal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    bigDecimal = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BigDecimal bigDecimal2 = this.getBigDecimal(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bigDecimal = bigDecimal2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.Date getDate(int n2) throws SQLException {
        try {
            Object object;
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    object2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (java.sql.Date)object);
                        }
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                object2 = (java.sql.Date)object;
                Object var19_17 = null;
                if (!TRACE) return object2;
                if (!OracleLog.recursiveEnter()) return object2;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var21_24 = null;
                    OracleLog.recursiveExit();
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var21_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (object instanceof Time) {
                object2 = (Time)object;
                java.sql.Date date = new java.sql.Date(((Date)object2).getTime());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                        Object var7_45 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_46 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                java.sql.Date date2 = date;
                Object var19_18 = null;
                if (!TRACE) return date2;
                if (!OracleLog.recursiveEnter()) return date2;
                try {}
                catch (Throwable throwable) {
                    Object var21_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_26 = null;
                OracleLog.recursiveExit();
                return date2;
            }
            if (object instanceof Date) {
                object2 = (Date)object;
                java.sql.Date date = new java.sql.Date(((Date)object2).getYear(), ((Date)object2).getMonth(), ((Date)object2).getDate());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                        Object var9_48 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_49 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                java.sql.Date date3 = date;
                Object var19_19 = null;
                if (!TRACE) return date3;
                if (!OracleLog.recursiveEnter()) return date3;
                try {}
                catch (Throwable throwable) {
                    Object var21_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_28 = null;
                OracleLog.recursiveExit();
                return date3;
            }
            if (object instanceof TIMESTAMP) {
                object2 = ((TIMESTAMP)object).dateValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                        Object var11_51 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_52 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Date date = object2;
                Object var19_20 = null;
                if (!TRACE) return date;
                if (!OracleLog.recursiveEnter()) return date;
                try {}
                catch (Throwable throwable) {
                    Object var21_31 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_30 = null;
                OracleLog.recursiveExit();
                return date;
            }
            if (object instanceof TIMESTAMPTZ) {
                object2 = ((TIMESTAMPTZ)object).dateValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                        Object var13_54 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var13_55 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object3 = object2;
                Object var19_21 = null;
                if (!TRACE) return object3;
                if (!OracleLog.recursiveEnter()) return object3;
                try {}
                catch (Throwable throwable) {
                    Object var21_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_32 = null;
                OracleLog.recursiveExit();
                return object3;
            }
            if (object instanceof TIMESTAMPLTZ) {
                object2 = this.getConnectionInternal();
                java.sql.Date date = ((TIMESTAMPLTZ)object).dateValue((Connection)object2, this.getSessionCalendar((Connection)object2));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                        }
                        Object var15_57 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var15_58 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                java.sql.Date date4 = date;
                Object var19_22 = null;
                if (!TRACE) return date4;
                if (!OracleLog.recursiveEnter()) return date4;
                try {}
                catch (Throwable throwable) {
                    Object var21_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_34 = null;
                OracleLog.recursiveExit();
                return date4;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var17_60 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var17_61 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            ((Throwable)object2).fillInStackTrace();
            throw object2;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var21_37 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var21_36 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.Date getDate(int n2, Calendar calendar) throws SQLException {
        java.sql.Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                    date = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            java.sql.Date date2 = this.getDate(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            date = date2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Time getTime(int n2) throws SQLException {
        Object object;
        block45: {
            Object object2;
            block44: {
                block43: {
                    block42: {
                        block41: {
                            try {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.enter()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                                        }
                                        object = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                if ((object2 = this.getObject(n2)) != null) break block41;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.isPublic()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Time)object2);
                                        }
                                        Object var5_6 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_7 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                object = (Time)object2;
                                Object var17_15 = null;
                                if (!TRACE) return object;
                            }
                            catch (Throwable throwable) {
                                Object var17_20 = null;
                                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                                try {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_31 = null;
                                }
                                catch (Throwable throwable2) {
                                    Object var19_32 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable2;
                                }
                                OracleLog.recursiveExit();
                                {
                                    throw throwable;
                                }
                            }
                            if (!OracleLog.recursiveEnter()) return object;
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_22 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            return object;
                        }
                        if (!(object2 instanceof Date)) break block42;
                        object = (Date)object2;
                        Time time = new Time(((Date)object).getHours(), ((Date)object).getMinutes(), ((Date)object).getSeconds());
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                                }
                                Object var7_39 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_40 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        Time time2 = time;
                        Object var17_16 = null;
                        if (!TRACE) return time2;
                        if (!OracleLog.recursiveEnter()) return time2;
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_23 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_24 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        return time2;
                    }
                    if (!(object2 instanceof TIMESTAMP)) break block43;
                    object = ((TIMESTAMP)object2).timeValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                            }
                            Object var9_42 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_43 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    Date date = object;
                    Object var17_17 = null;
                    if (!TRACE) return date;
                    if (!OracleLog.recursiveEnter()) return date;
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    return date;
                }
                if (!(object2 instanceof TIMESTAMPTZ)) break block44;
                object = ((TIMESTAMPTZ)object2).timeValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                        }
                        Object var11_45 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_46 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                Object object3 = object;
                Object var17_18 = null;
                if (!TRACE) return object3;
                if (!OracleLog.recursiveEnter()) return object3;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_27 = null;
                }
                catch (Throwable throwable) {
                    Object var19_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                return object3;
            }
            if (!(object2 instanceof TIMESTAMPLTZ)) break block45;
            object = this.getConnectionInternal();
            Time time = ((TIMESTAMPLTZ)object2).timeValue((Connection)object, this.getSessionCalendar((Connection)object));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                    Object var13_48 = null;
                }
                catch (Throwable throwable) {
                    Object var13_49 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time3 = time;
            Object var17_19 = null;
            if (!TRACE) return time3;
            if (!OracleLog.recursiveEnter()) return time3;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_29 = null;
            }
            catch (Throwable throwable) {
                Object var19_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return time3;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var15_51 = null;
            }
            catch (Throwable throwable) {
                Object var15_52 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time2 = this.getTime(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = time2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object;
        block55: {
            Object object2;
            block53: {
                block51: {
                    block49: {
                        block47: {
                            try {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.enter()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                                        }
                                        object = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_3 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                if ((object2 = this.getObject(n2)) != null && !(object2 instanceof Timestamp)) break block47;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.isPublic()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Timestamp)object2);
                                        }
                                        Object var5_6 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_7 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                object = (Timestamp)object2;
                                Object var17_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var17_19 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var19_30 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        Object var19_31 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable2;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                throw throwable;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var19_20 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var19_21 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return object;
                        }
                        if (!(object2 instanceof Date)) break block49;
                        object = new Timestamp(((Date)object2).getTime());
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                                }
                                Object var7_38 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_39 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        Timestamp timestamp = object;
                        Object var17_15 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var19_22 = null;
                            }
                            catch (Throwable throwable) {
                                Object var19_23 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return timestamp;
                    }
                    if (!(object2 instanceof TIMESTAMP)) break block51;
                    object = ((TIMESTAMP)object2).timestampValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                            }
                            Object var9_41 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_42 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    Timestamp timestamp = object;
                    Object var17_16 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var19_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return timestamp;
                }
                if (!(object2 instanceof TIMESTAMPTZ)) break block53;
                object = ((TIMESTAMPTZ)object2).timestampValue(this.getConnectionInternal());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                        }
                        Object var11_44 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_45 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                Object object3 = object;
                Object var17_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_26 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return object3;
            }
            if (!(object2 instanceof TIMESTAMPLTZ)) break block55;
            object = this.getConnectionInternal();
            Timestamp timestamp = ((TIMESTAMPLTZ)object2).timestampValue((Connection)object, this.getSessionCalendar((Connection)object));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                    Object var13_47 = null;
                }
                catch (Throwable throwable) {
                    Object var13_48 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp2 = timestamp;
            Object var17_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_28 = null;
                }
                catch (Throwable throwable) {
                    Object var19_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return timestamp2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var15_50 = null;
            }
            catch (Throwable throwable) {
                Object var15_51 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                    timestamp = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Timestamp timestamp2 = this.getTimestamp(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp2);
                    }
                    Object var6_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            timestamp = timestamp2;
            Object var8_10 = null;
            if (!TRACE) return timestamp;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return timestamp;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            return timestamp;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        Object object;
        block73: {
            Object object2;
            block71: {
                block69: {
                    block67: {
                        block65: {
                            block63: {
                                block61: {
                                    try {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                if (OracleLog.enter()) {
                                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                                                }
                                                object = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var3_3 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        if ((object2 = this.getObject(n2)) != null) break block61;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                if (OracleLog.isPublic()) {
                                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])object2);
                                                }
                                                Object var5_6 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var5_7 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        object = (byte[])object2;
                                        Object var21_16 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var21_23 = null;
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                                Object var23_38 = null;
                                            }
                                            catch (Throwable throwable2) {
                                                Object var23_39 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable2;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        throw throwable;
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                            Object var23_24 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var23_25 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                        OracleLog.recursiveExit();
                                        {
                                        }
                                    }
                                    return object;
                                }
                                if (!(object2 instanceof byte[])) break block63;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.isPublic()) {
                                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (byte[])object2);
                                        }
                                        Object var7_48 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_49 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                object = (byte[])object2;
                                Object var21_17 = null;
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        Object var23_26 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var23_27 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                return object;
                            }
                            if (!(object2 instanceof String)) break block65;
                            object = ((String)object2).getBytes();
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                                    }
                                    Object var9_51 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_52 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            byte[] byArray = object;
                            Object var21_18 = null;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    Object var23_28 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var23_29 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return byArray;
                        }
                        if (!(object2 instanceof Number)) break block67;
                        object = ((Number)object2).toString().getBytes();
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                                }
                                Object var11_54 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_55 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        byte[] byArray = object;
                        Object var21_19 = null;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                Object var23_30 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_31 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        return byArray;
                    }
                    if (!(object2 instanceof BigDecimal)) break block69;
                    object = ((BigDecimal)object2).toString().getBytes();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                            }
                            Object var13_57 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_58 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    Object object3 = object;
                    Object var21_20 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var23_32 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_33 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    return object3;
                }
                if (!(object2 instanceof OracleSerialBlob)) break block71;
                object = (OracleSerialBlob)object2;
                byte[] byArray = ((OracleSerialBlob)object).getBytes(1L, (int)((OracleSerialBlob)object).length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                        }
                        Object var15_60 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_61 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byte[] byArray2 = byArray;
                Object var21_21 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var23_34 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_35 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return byArray2;
            }
            if (!(object2 instanceof OracleSerialClob)) break block73;
            object = (OracleSerialClob)object2;
            byte[] byArray = ((OracleSerialClob)object).getSubString(1L, (int)((OracleSerialClob)object).length()).getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                    Object var17_63 = null;
                }
                catch (Throwable throwable) {
                    Object var17_64 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] byArray3 = byArray;
            Object var21_22 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_36 = null;
                }
                catch (Throwable throwable) {
                    Object var23_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return byArray3;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var19_66 = null;
            }
            catch (Throwable throwable) {
                Object var19_67 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Ref getRef(int n2) throws SQLException {
        Object object;
        block17: {
            Ref ref;
            try {
                Object object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((object2 = this.getObject(n2)) != null && !(object2 instanceof Ref)) break block17;
                object = (Ref)object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                ref = object;
                Object var9_10 = null;
                if (!TRACE) return ref;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return ref;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return ref;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        Object object;
        block19: {
            Blob blob;
            try {
                Object object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((object2 = this.getObject(n2)) != null && !(object2 instanceof OracleSerialBlob)) break block19;
                object = (Blob)object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                blob = object;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return blob;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Clob getClob(int n2) throws SQLException {
        try {
            Object object;
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    object2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((object = this.getObject(n2)) == null || object instanceof OracleSerialClob) {
                object2 = (Clob)object;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                        }
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Clob clob = object2;
                Object var9_10 = null;
                if (!TRACE) return clob;
                if (!OracleLog.recursiveEnter()) return clob;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                    OracleLog.recursiveExit();
                    return clob;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var7_18 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            ((Throwable)object2).fillInStackTrace();
            throw object2;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        Object object;
        block19: {
            Array array;
            try {
                Object object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((object2 = this.getObject(n2)) != null && !(object2 instanceof Array)) break block19;
                object = (Array)object2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                array = object;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return array;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                Object var7_18 = null;
            }
            catch (Throwable throwable) {
                Object var7_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int n2) throws SQLException {
        try {
            Object object;
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    object2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object);
                        }
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                object2 = (String)object;
                Object var31_23 = null;
                if (!TRACE) return object2;
                if (!OracleLog.recursiveEnter()) return object2;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var33_35 = null;
                    OracleLog.recursiveExit();
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var33_36 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (object instanceof String) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object);
                        }
                        Object var7_71 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_72 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                object2 = (String)object;
                Object var31_24 = null;
                if (!TRACE) return object2;
                if (!OracleLog.recursiveEnter()) return object2;
                try {}
                catch (Throwable throwable) {
                    Object var33_38 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_37 = null;
                OracleLog.recursiveExit();
                return object2;
            }
            if (object instanceof Number || object instanceof BigDecimal) {
                object2 = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var9_76 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_77 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                String string = object2;
                Object var31_25 = null;
                if (!TRACE) return string;
                if (!OracleLog.recursiveEnter()) return string;
                try {}
                catch (Throwable throwable) {
                    Object var33_40 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_39 = null;
                OracleLog.recursiveExit();
                return string;
            }
            if (object instanceof java.sql.Date) {
                object2 = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var11_80 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_81 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                String string = object2;
                Object var31_26 = null;
                if (!TRACE) return string;
                if (!OracleLog.recursiveEnter()) return string;
                try {}
                catch (Throwable throwable) {
                    Object var33_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_41 = null;
                OracleLog.recursiveExit();
                return string;
            }
            if (object instanceof Timestamp) {
                object2 = object.toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var13_83 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var13_84 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                String string = object2;
                Object var31_27 = null;
                if (!TRACE) return string;
                if (!OracleLog.recursiveEnter()) return string;
                try {}
                catch (Throwable throwable) {
                    Object var33_44 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_43 = null;
                OracleLog.recursiveExit();
                return string;
            }
            if (object instanceof byte[]) {
                object2 = new String((byte[])object);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var15_86 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var15_87 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object3 = object2;
                Object var31_28 = null;
                if (!TRACE) return object3;
                if (!OracleLog.recursiveEnter()) return object3;
                try {}
                catch (Throwable throwable) {
                    Object var33_46 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_45 = null;
                OracleLog.recursiveExit();
                return object3;
            }
            if (object instanceof OracleSerialClob) {
                object2 = (OracleSerialClob)object;
                String string = ((OracleSerialClob)object2).getSubString(1L, (int)((OracleSerialClob)object2).length());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                        Object var17_89 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var17_90 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                String string2 = string;
                Object var31_29 = null;
                if (!TRACE) return string2;
                if (!OracleLog.recursiveEnter()) return string2;
                try {}
                catch (Throwable throwable) {
                    Object var33_48 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_47 = null;
                OracleLog.recursiveExit();
                return string2;
            }
            if (object instanceof OracleSerialBlob) {
                object2 = (OracleSerialBlob)object;
                String string = new String(((OracleSerialBlob)object2).getBytes(1L, (int)((OracleSerialBlob)object2).length()));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                        }
                        Object var19_92 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var19_93 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                String string3 = string;
                Object var31_30 = null;
                if (!TRACE) return string3;
                if (!OracleLog.recursiveEnter()) return string3;
                try {}
                catch (Throwable throwable) {
                    Object var33_50 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_49 = null;
                OracleLog.recursiveExit();
                return string3;
            }
            if (object instanceof URL) {
                object2 = ((URL)object).toString();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var21_95 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var21_96 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object4 = object2;
                Object var31_31 = null;
                if (!TRACE) return object4;
                if (!OracleLog.recursiveEnter()) return object4;
                try {}
                catch (Throwable throwable) {
                    Object var33_52 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_51 = null;
                OracleLog.recursiveExit();
                return object4;
            }
            if (object instanceof ROWID) {
                object2 = ((ROWID)object).stringValue();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (String)object2);
                        }
                        Object var23_98 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var23_99 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object5 = object2;
                Object var31_32 = null;
                if (!TRACE) return object5;
                if (!OracleLog.recursiveEnter()) return object5;
                try {}
                catch (Throwable throwable) {
                    Object var33_54 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_53 = null;
                OracleLog.recursiveExit();
                return object5;
            }
            if (object instanceof Reader) {
                String string;
                try {
                    object2 = (Reader)object;
                    char[] cArray = new char[1024];
                    int n3 = 0;
                    StringBuffer stringBuffer = new StringBuffer(1024);
                    while ((n3 = ((Reader)object2).read(cArray)) > 0) {
                        stringBuffer.append(cArray, 0, n3);
                    }
                    String string4 = stringBuffer.substring(0, stringBuffer.length());
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string4);
                            }
                            Object var25_101 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var25_102 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    string = string4;
                }
                catch (IOException iOException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 321 + iOException.getMessage());
                            Object var27_104 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var27_105 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 321, iOException.getMessage());
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Object var31_33 = null;
                if (!TRACE) return string;
                if (!OracleLog.recursiveEnter()) return string;
                try {}
                catch (Throwable throwable) {
                    Object var33_56 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var33_55 = null;
                OracleLog.recursiveExit();
                return string;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    Object var29_107 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var29_108 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
            ((Throwable)object2).fillInStackTrace();
            throw object2;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var33_58 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var33_57 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream;
        try {
            InputStream inputStream2;
            InputStream inputStream3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    inputStream3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream4 = inputStream3 = (inputStream2 = this.getStream(n2)) == null ? null : inputStream2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = inputStream3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object;
        block28: {
            Object object2;
            block26: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                            }
                            object = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if ((object2 = this.getObject(n2)) != null) break block26;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (InputStream)object2);
                            }
                            Object var5_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    object = (InputStream)object2;
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var13_17 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var13_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                return object;
            }
            if (!(object2 instanceof String)) break block28;
            object = new StringBufferInputStream((String)object2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                    Object var7_22 = null;
                }
                catch (Throwable throwable) {
                    Object var7_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object3 = object;
            Object var11_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return object3;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var9_25 = null;
            }
            catch (Throwable throwable) {
                Object var9_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        ((Throwable)object).fillInStackTrace();
        throw object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream;
        try {
            InputStream inputStream2;
            InputStream inputStream3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    inputStream3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream4 = inputStream3 = (inputStream2 = this.getStream(n2)) == null ? null : inputStream2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = inputStream3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            CharArrayReader charArrayReader;
            InputStream inputStream;
            Serializable serializable;
            block25: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                        serializable = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                inputStream = this.getAsciiStream(n2);
                if (inputStream != null) break block25;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        }
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                serializable = null;
                Object var12_12 = null;
                if (!TRACE) return serializable;
                if (!OracleLog.recursiveEnter()) return serializable;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_15 = null;
                    OracleLog.recursiveExit();
                    return serializable;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                serializable = new StringBuffer();
                int n3 = 0;
                while ((n3 = inputStream.read()) != -1) {
                    ((StringBuffer)serializable).append((char)n3);
                }
                char[] cArray = new char[((StringBuffer)serializable).length()];
                ((StringBuffer)serializable).getChars(0, ((StringBuffer)serializable).length(), cArray, 0);
                CharArrayReader charArrayReader2 = new CharArrayReader(cArray);
                cArray = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + charArrayReader2);
                        }
                        Object var8_25 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                charArrayReader = charArrayReader2;
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 322);
                        Object var10_29 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 322);
                ((Throwable)serializable).fillInStackTrace();
                throw serializable;
            }
            Object var12_13 = null;
            if (!TRACE) return charArrayReader;
            if (!OracleLog.recursiveEnter()) return charArrayReader;
            try {}
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_17 = null;
            OracleLog.recursiveExit();
            return charArrayReader;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(String string) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object2 = this.getObject(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.getBoolean(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(String string) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte by2 = this.getByte(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by2);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            by = by2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(String string) throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short s3 = this.getShort(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = s3;
            Object var7_10 = null;
            if (!TRACE) return s2;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return s2;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String string) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = this.getInt(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLong(String string) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            long l3 = this.getLong(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l3);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            l2 = l3;
            Object var7_10 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return l2;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(String string) throws SQLException {
        float f2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            float f3 = this.getFloat(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f3);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            f2 = f3;
            Object var7_10 = null;
            if (!TRACE) return f2;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return f2;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String string) throws SQLException {
        double d2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            double d3 = this.getDouble(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            d2 = d3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                    bigDecimal = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BigDecimal bigDecimal2 = this.getBigDecimal(this.getColumnIndex(string), n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bigDecimal = bigDecimal2;
            Object var8_10 = null;
            if (!TRACE) return bigDecimal;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bigDecimal;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] byArray2 = this.getBytes(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = byArray2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public java.sql.Date getDate(String string) throws SQLException {
        java.sql.Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    date = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            java.sql.Date date2 = this.getDate(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date2);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            date = date2;
            Object var7_9 = null;
            if (!TRACE) return date;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return date;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return date;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String string) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time2 = this.getTime(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = time2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    timestamp = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp2 = this.getTimestamp(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            timestamp = timestamp2;
            Object var7_9 = null;
            if (!TRACE) return timestamp;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return timestamp;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String string, Calendar calendar) throws SQLException {
        Time time;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                    time = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Time time2 = this.getTime(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            time = time2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.Date getDate(String string, Calendar calendar) throws SQLException {
        java.sql.Date date;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                    date = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            java.sql.Date date2 = this.getDate(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            date = date2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(String string) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream2 = this.getAsciiStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = inputStream2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(String string) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            InputStream inputStream2 = this.getUnicodeStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            inputStream = inputStream2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string) throws SQLException {
        String string2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    string2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String string3 = this.getString(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string2 = string3;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public InputStream getBinaryStream(String string) throws SQLException {
        InputStream inputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    inputStream = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            InputStream inputStream2 = this.getBinaryStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream2);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            inputStream = inputStream2;
            Object var7_9 = null;
            if (!TRACE) return inputStream;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return inputStream;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(String string) throws SQLException {
        Reader reader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    reader = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Reader reader2 = this.getCharacterStream(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            reader = reader2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    bigDecimal = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            BigDecimal bigDecimal2 = this.getBigDecimal(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal2);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bigDecimal = bigDecimal2;
            Object var7_9 = null;
            if (!TRACE) return bigDecimal;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bigDecimal;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return bigDecimal;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                    timestamp = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp timestamp2 = this.getTimestamp(this.getColumnIndex(string), calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            timestamp = timestamp2;
            Object var8_10 = null;
            if (!TRACE) return timestamp;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return timestamp;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(map));
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object2 = this.getObject(this.getColumnIndex(string), map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(String string) throws SQLException {
        Ref ref;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    ref = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Ref ref2 = this.getRef(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ref2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ref = ref2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Blob getBlob(String string) throws SQLException {
        Blob blob;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    blob = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Blob blob2 = this.getBlob(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + blob2);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            blob = blob2;
            Object var7_9 = null;
            if (!TRACE) return blob;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return blob;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return blob;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(String string) throws SQLException {
        Clob clob;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    clob = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Clob clob2 = this.getClob(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + clob2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            clob = clob2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return clob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(String string) throws SQLException {
        Array array;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    array = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Array array2 = this.getArray(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + array2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            array = array2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateObject(int n2, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, object, (int[])null);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void updateObject(int n2, Object object, int[] nArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkColumnIndex(n2);
            if (this.insertRowFlag) {
                this.checkAndFilterObject(n2, object);
                this.insertRow.updateObject(n2, object, nArray);
            } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
                this.updateRowFlag = true;
                this.updateRowPosition = this.presentRow;
                this.getCurrentRow().updateObject(n2, object, nArray);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, null);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateCharacterStreamInternal(n2, reader, n3, false);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCharacterStreamInternal(int n2, Reader reader, int n3, boolean bl) throws SQLException {
        this.checkColumnIndex(n2);
        if (n3 < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n4)) {
            try {
                int n5;
                int n6 = 0;
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n5)) != -1; n5 -= n6) {
                    stringBuilder.append(cArray, 0, n6);
                }
                reader.close();
                if (n5 == n3) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        Object var11_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        int n7 = bl ? 4 : 3;
        int[] nArray = new int[]{n3, n7};
        this.updateObject(n2, (Object)reader, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n2));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateTimestamp(this.getColumnIndex(string), timestamp);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void updateBinaryStream(int var1_1, InputStream var2_2, int var3_3) throws SQLException {
        block25: {
            block24: {
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(var1_1) + ", " + OracleLog.argument(var2_2) + ", " + OracleLog.argument(var3_3));
                        }
                        var5_4 = null;
                    }
                    catch (Throwable var4_8) {
                        var5_5 = null;
                        OracleLog.recursiveExit();
                        throw var4_8;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.checkColumnIndex(var1_1);
                if (var3_3 < 0) {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            var7_11 = null;
                        }
                        catch (Throwable var6_14) {
                            var7_12 = null;
                            OracleLog.recursiveExit();
                            throw var6_14;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    var4_9 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    var4_9.fillInStackTrace();
                    throw var4_9;
                }
                var4_10 = this.getMetaData().getColumnType(var1_1);
                if (this.isStreamType(var4_10)) break block26;
                var5_6 = 0;
                var7_13 = new byte[1024];
                var8_17 = new ByteArrayOutputStream(1024);
                for (var6_15 = var3_3; var6_15 > 0 && (var5_6 = var6_15 >= 1024 ? var2_2.read(var7_13) : var2_2.read(var7_13, 0, var6_15)) != -1; var6_15 -= var5_6) {
                    var8_17.write(var7_13, 0, var5_6);
                }
                var2_2.close();
                if (var6_15 != var3_3) break block23;
                this.updateNull(var1_1);
                var12_18 = null;
                if (!OracleCachedRowSet.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var14_21 = null;
                }
                catch (Throwable var13_27) {
                    var14_22 = null;
                    OracleLog.recursiveExit();
                    throw var13_27;
                }
                OracleLog.recursiveExit();
                {
                }
lbl-1000:
                // 2 sources

                {
                    block26: {
                        block23: {
                            return;
                        }
                        try {
                            this.updateBytes(var1_1, var8_17.toByteArray());
                            break block24;
                        }
                        catch (IOException var5_7) {
                            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + var5_7);
                                    var10_30 = null;
                                }
                                catch (Throwable var9_32) {
                                    var10_31 = null;
                                    OracleLog.recursiveExit();
                                    throw var9_32;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            var6_16 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), var5_7);
                            var6_16.fillInStackTrace();
                            throw var6_16;
                        }
                    }
                    var5_4 = new int[]{var3_3, 2};
                    this.updateObject(var1_1, (Object)var2_2, var5_4);
                }
            }
            var12_19 = null;
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var14_23 = null;
                }
                catch (Throwable var13_28) {
                    var14_24 = null;
                    OracleLog.recursiveExit();
                    throw var13_28;
                }
                OracleLog.recursiveExit();
                {
                    break block25;
                }
            }
            break block25;
            catch (Throwable var11_33) {
                var12_20 = null;
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        var14_25 = null;
                    }
                    catch (Throwable var13_29) {
                        var14_26 = null;
                        OracleLog.recursiveExit();
                        throw var13_29;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw var11_33;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try {
            int[] nArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n3));
                    }
                    nArray = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkColumnIndex(n2);
            if (n3 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var7_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n4 = this.getMetaData().getColumnType(n2);
            if (!this.isStreamType(n4)) {
                StringBuilder stringBuilder;
                block22: {
                    try {
                        int n5;
                        int n6 = 0;
                        byte[] byArray = new byte[1024];
                        char[] cArray = new char[1024];
                        stringBuilder = new StringBuilder(1024);
                        for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                            DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                            stringBuilder.append(cArray, 0, n6);
                        }
                        inputStream.close();
                        if (n5 != n3) break block22;
                        this.updateNull(n2);
                    }
                    catch (IOException iOException) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                                Object var11_31 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_32 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    Object var13_19 = null;
                    if (!TRACE) return;
                    if (!OracleLog.recursiveEnter()) return;
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_22 = null;
                        OracleLog.recursiveExit();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var15_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.updateString(n2, stringBuilder.toString());
            }
            nArray = new int[]{n3, 1};
            this.updateObject(n2, (Object)inputStream, nArray);
            Object var13_20 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_27 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_26 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var15_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_24 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)timestamp);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(n2, (Object)bl);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int n2, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(by));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)new Byte(by));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int n2, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(s2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)s2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)n3);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int n2, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(l2));
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)l2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)Float.valueOf(f2));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)d2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bigDecimal));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(n2, (Object)bigDecimal);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)string);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(byArray));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)byArray);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int n2, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)date);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateTime(int n2, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!(object instanceof Number)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateNull(this.getColumnIndex(string));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(String string, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bl));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBoolean(this.getColumnIndex(string), bl);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(String string, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(by));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateByte(this.getColumnIndex(string), by);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(String string, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(s2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateShort(this.getColumnIndex(string), s2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateInt(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateInt(this.getColumnIndex(string), n2);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(String string, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(l2));
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateLong(this.getColumnIndex(string), l2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(String string, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(f2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateFloat(this.getColumnIndex(string), f2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(String string, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(d2));
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateDouble(this.getColumnIndex(string), d2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bigDecimal));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateString(this.getColumnIndex(string), string2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(byArray));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBytes(this.getColumnIndex(string), byArray);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(String string, java.sql.Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateDate(this.getColumnIndex(string), date);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateTime(String string, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateTime(this.getColumnIndex(string), time);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(String string, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(this.getColumnIndex(string), object);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(String string, Object object, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(this.getColumnIndex(string), object, n2);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getURL(int n2) throws SQLException {
        try {
            Object object;
            Serializable serializable;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    serializable = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((object = this.getObject(n2)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)object);
                        }
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                serializable = (URL)object;
                Object var15_11 = null;
                if (!TRACE) return serializable;
                if (!OracleLog.recursiveEnter()) return serializable;
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_15 = null;
                    OracleLog.recursiveExit();
                    return serializable;
                }
                catch (Throwable throwable) {
                    Object var17_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (object instanceof URL) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (URL)object);
                        }
                        Object var7_27 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                serializable = (URL)object;
                Object var15_12 = null;
                if (!TRACE) return serializable;
                if (!OracleLog.recursiveEnter()) return serializable;
                try {}
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_17 = null;
                OracleLog.recursiveExit();
                return serializable;
            }
            if (object instanceof String) {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new URL((String)object));
                            }
                            Object var9_30 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_31 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    serializable = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                            Object var11_33 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var11_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Object var15_13 = null;
                if (!TRACE) return serializable;
                if (!OracleLog.recursiveEnter()) return serializable;
                try {}
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_19 = null;
                OracleLog.recursiveExit();
                return serializable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var13_36 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var13_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            ((Throwable)serializable).fillInStackTrace();
            throw serializable;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var17_22 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(String string) throws SQLException {
        URL uRL;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    uRL = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            URL uRL2 = this.getURL(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + uRL2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            uRL = uRL2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRef(int n2, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(ref));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)ref);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRef(String string, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(ref));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateRef(this.getColumnIndex(string), ref);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void updateBlob(int n2, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(blob));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(n2, (Object)blob);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(String string, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(blob));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateBlob(this.getColumnIndex(string), blob);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateClob(int n2, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clob));
                    }
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateObject(n2, (Object)clob);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(String string, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(clob));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateClob(this.getColumnIndex(string), clob);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void updateArray(int n2, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(array));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateObject(n2, (Object)array);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateArray(String string, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(array));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.updateArray(this.getColumnIndex(string), array);
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getKeyColumns() throws SQLException {
        int[] nArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.keyColumns);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            nArray = this.keyColumns;
            Object var6_8 = null;
            if (!TRACE) return nArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return nArray;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyColumns(int[] nArray) throws SQLException {
        try {
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n2 = 0;
            if (this.rowsetMetaData != null) {
                n2 = this.rowsetMetaData.getColumnCount();
                if (nArray == null || nArray.length > n2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 324);
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 324);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            int n3 = nArray.length;
            this.keyColumns = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray[i2] <= 0 || nArray[i2] > n2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3 + "" + nArray[i2]);
                            Object var7_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + nArray[i2]);
                    sQLException2.fillInStackTrace();
                    throw sQLException2;
                }
                this.keyColumns[i2] = nArray[i2];
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.pageSize);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.pageSize;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 325);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 325);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.pageSize = n2;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncProvider getSyncProvider() throws SQLException {
        SyncProvider syncProvider;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.syncProvider);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            syncProvider = this.syncProvider;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return syncProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setSyncProvider(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.syncProvider = SyncFactory.getInstance(string);
            this.reader = this.syncProvider.getRowSetReader();
            this.writer = this.syncProvider.getRowSetWriter();
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.tableName);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = this.tableName;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableName(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.tableName = string;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    oracleCachedRowSet = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = (OracleCachedRowSet)this.createCopy();
            oracleCachedRowSet2.initializeProperties();
            oracleCachedRowSet2.listener = new Vector();
            try {
                oracleCachedRowSet2.unsetMatchColumn(oracleCachedRowSet2.getMatchColumnIndexes());
                oracleCachedRowSet2.unsetMatchColumn(oracleCachedRowSet2.getMatchColumnNames());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet2);
                    }
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = oracleCachedRowSet2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    oracleCachedRowSet = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet2 = (OracleCachedRowSet)this.createCopy();
            oracleCachedRowSet2.rows = null;
            oracleCachedRowSet2.rowCount = 0;
            oracleCachedRowSet2.currentPage = 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleCachedRowSet2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleCachedRowSet = oracleCachedRowSet2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnUpdated(int n2) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 326);
                        Object var5_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 326);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl2 = this.getCurrentRow().isColumnChanged(n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnUpdated(String string) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.columnUpdated(this.getColumnIndex(string));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Connection connection) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.connection = connection;
            this.execute();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.getConnectionInternal().commit();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.getConnectionInternal().rollback();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(savepoint));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Connection connection = this.getConnectionInternal();
            boolean bl = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                connection.rollback(savepoint);
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                connection.setAutoCommit(bl);
                throw throwable;
            }
            connection.setAutoCommit(bl);
            Object var7_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleSavepoint));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOriginalRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.insertRowFlag) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 327);
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 327);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setOriginalRowInternal(this.presentRow);
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowCount);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.rowCount;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nextPage() throws SQLException {
        try {
            block30: {
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        var2_1 = null;
                    }
                    catch (Throwable var1_4) {
                        var2_2 = null;
                        OracleLog.recursiveExit();
                        throw var1_4;
                    }
                    OracleLog.recursiveExit();
                }
                if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                            var4_9 = null;
                        }
                        catch (Throwable var3_11) {
                            var4_10 = null;
                            OracleLog.recursiveExit();
                            throw var3_11;
                        }
                        OracleLog.recursiveExit();
                    }
                    var1_5 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                    var1_5.fillInStackTrace();
                    throw var1_5;
                }
                if (this.rows.size() == 0 && !this.isPopulateDone) {
                    if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                            var6_12 = null;
                        }
                        catch (Throwable var5_14) {
                            var6_13 = null;
                            OracleLog.recursiveExit();
                            throw var5_14;
                        }
                        OracleLog.recursiveExit();
                    }
                    var1_6 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                    var1_6.fillInStackTrace();
                    throw var1_6;
                }
                if (!this.isExecuteCalled() && !this.isPopulateDone || this.rowCount >= this.pageSize) break block30;
                if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        var8_15 = null;
                    }
                    catch (Throwable var7_17) {
                        var8_16 = null;
                        OracleLog.recursiveExit();
                        throw var7_17;
                    }
                    OracleLog.recursiveExit();
                }
                var1_7 = false;
                var12_18 = null;
                if (OracleCachedRowSet.TRACE == false) return var1_7;
                ** GOTO lbl107
            }
            if (this.isExecuteCalled()) {
                ++this.currentPage;
                this.execute();
            } else {
                this.populate(this.resultSet);
                ++this.currentPage;
            }
            v0 = var1_8 = this.isPopulateDone == false;
            if (OracleCachedRowSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + var1_8);
                    }
                    var10_30 = null;
                }
                catch (Throwable var9_32) {
                    var10_31 = null;
                    OracleLog.recursiveExit();
                    throw var9_32;
                }
                OracleLog.recursiveExit();
            }
            var2_3 = var1_8;
            ** GOTO lbl120
        }
        catch (Throwable var11_33) {
            var12_20 = null;
            if (OracleCachedRowSet.TRACE == false) throw var11_33;
            if (OracleLog.recursiveEnter() == false) throw var11_33;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var14_25 = null;
            }
            catch (Throwable var13_29) {
                var14_26 = null;
                OracleLog.recursiveExit();
                throw var13_29;
            }
lbl107:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var1_7;
            try {}
            catch (Throwable var13_27) {
                var14_22 = null;
                OracleLog.recursiveExit();
                throw var13_27;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var14_21 = null;
            OracleLog.recursiveExit();
            return var1_7;
lbl120:
            // 1 sources

            var12_19 = null;
            if (OracleCachedRowSet.TRACE == false) return var2_3;
            if (OracleLog.recursiveEnter() == false) return var2_3;
            try {}
            catch (Throwable var13_28) {
                var14_24 = null;
                OracleLog.recursiveExit();
                throw var13_28;
            }
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var14_23 = null;
            OracleLog.recursiveExit();
            return var2_3;
            OracleLog.recursiveExit();
            throw var11_33;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previousPage() throws SQLException {
        boolean bl;
        block33: {
            boolean bl2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.resultSet != null && this.resultSet.getType() == 1003) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 328);
                            Object var4_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 328);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.rows.size() == 0 && !this.isPopulateDone) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 329);
                            Object var6_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 329);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.currentPage != 0) break block33;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl2 = false;
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_25 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_21 = null;
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl2;
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        boolean bl3 = bl = this.currentPage != 0;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                }
                Object var10_30 = null;
            }
            catch (Throwable throwable) {
                Object var10_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl4 = bl;
        Object var12_19 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_23 = null;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetEvent) + ", " + OracleLog.argument(n2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 <= 0 || n2 < this.fetchSize) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 330);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 330);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.rowCount % n2 == 0) {
                this.rowsetEvent = new RowSetEvent(this);
                this.notifyRowSetChanged();
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowSetWarning getRowSetWarnings() throws SQLException {
        RowSetWarning rowSetWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowsetWarning);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rowSetWarning = this.rowsetWarning;
            Object var6_8 = null;
            if (!TRACE) return rowSetWarning;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return rowSetWarning;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return rowSetWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populate(ResultSet resultSet, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(resultSet) + ", " + OracleLog.argument(n2));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 331);
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 331);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (resultSet == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 332);
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 332);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = resultSet.getType();
            if (n3 == 1003) {
                int n4;
                boolean bl = false;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (resultSet.next()) continue;
                    bl = true;
                    break;
                }
                if (n4 < n2 && n2 > 0 && bl) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 333);
                            Object var10_18 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 333);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else if (n2 == 0) {
                resultSet.beforeFirst();
            } else {
                resultSet.absolute(n2);
            }
            this.populate(resultSet);
            Object var12_21 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_25 = null;
            }
            catch (Throwable throwable2) {
                Object var14_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoDelete() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowDelete();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoInsert() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowInsert();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoUpdate() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.cancelRowUpdates();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

