/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    protected static AtomicInteger UNNAMED_CACHE_COUNT;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    private OracleConnectionCacheManager() {
        UNNAMED_CACHE_COUNT = new AtomicInteger();
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        try {
            if (cacheManagerInstance == null) {
                cacheManagerInstance = new OracleConnectionCacheManager();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return cacheManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleDataSource) + ", " + OracleLog.argument(properties));
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String string = null;
            if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                ((Throwable)object).fillInStackTrace();
                throw object;
            }
            string = oracleDataSource.connCacheName != null ? oracleDataSource.connCacheName : oracleDataSource.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
            this.createCache(string, oracleDataSource, properties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = string;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createCache(String string, OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        try {
            Object object;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(oracleDataSource) + ", " + OracleLog.argument(properties));
                    }
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 138);
                        Object var9_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 138);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.m_connCache.containsKey(string)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 140);
                        Object var11_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 140);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl = oracleDataSource.getFastConnectionFailoverEnabled();
            if (bl && this.failoverEventHandlerThread == null) {
                object = oracleDataSource.getONSConfiguration();
                if (object != null && !((String)object).equals("")) {
                    OracleConnectionCacheManager oracleConnectionCacheManager = this;
                    synchronized (oracleConnectionCacheManager) {
                        if (!isONSInitializedForRemoteSubscription) {
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                                    final /* synthetic */ String val$onsConfigStr;
                                    {
                                        this.val$onsConfigStr = string;
                                    }

                                    public Object run() throws ONSException {
                                        ONS oNS = new ONS(this.val$onsConfigStr);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 175 + privilegedActionException);
                                        Object var13_23 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_24 = null;
                                        OracleLog.recursiveExit();
                                        throw throwable;
                                    }
                                    OracleLog.recursiveExit();
                                    {
                                    }
                                }
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 175, privilegedActionException);
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            isONSInitializedForRemoteSubscription = true;
                        }
                    }
                }
                this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
            }
            object = new OracleImplicitConnectionCache(oracleDataSource, properties);
            ((OracleImplicitConnectionCache)object).cacheName = string;
            oracleDataSource.odsCache = object;
            this.m_connCache.put(string, object);
            if (bl) {
                this.checkAndStartThread(this.failoverEventHandlerThread);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    Object var16_27 = null;
                }
                catch (Throwable throwable) {
                    Object var16_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var18_30 = null;
        }
        catch (Throwable throwable) {
            Object var18_31 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_34 = null;
            }
            catch (Throwable throwable2) {
                Object var20_35 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_32 = null;
        }
        catch (Throwable throwable) {
            Object var20_33 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String string, long l2) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(l2));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(string) : null;
            if (oracleImplicitConnectionCache != null) {
                oracleImplicitConnectionCache.disableConnectionCache();
                if (l2 > 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(l2 * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (oracleImplicitConnectionCache.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                    this.cleanupFCFThreads(oracleImplicitConnectionCache);
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleImplicitConnectionCache.closeConnectionCache(l2 < 0L ? 32 : 1);
            oracleImplicitConnectionCache = null;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeCache(String string, Properties properties) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(properties));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
            if (oracleImplicitConnectionCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.disableCache(string);
            oracleImplicitConnectionCache.reinitializeCacheConnections(properties);
            this.enableCache(string);
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsCache(String string) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = this.m_connCache.containsKey(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCache(String string) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
            if (oracleImplicitConnectionCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleImplicitConnectionCache.enableConnectionCache();
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCache(String string) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
            if (oracleImplicitConnectionCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleImplicitConnectionCache.disableConnectionCache();
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache(String string, int n2) throws SQLException {
        try {
            block22: {
                SQLException sQLException;
                block21: {
                    OracleImplicitConnectionCache oracleImplicitConnectionCache;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                            }
                            sQLException = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
                    if (oracleImplicitConnectionCache == null) break block21;
                    switch (n2) {
                        case 4096: 
                        case 8192: {
                            oracleImplicitConnectionCache.refreshCacheConnections(n2);
                            break block22;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                                    Object var6_7 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_8 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache(String string, boolean bl) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bl));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
            if (oracleImplicitConnectionCache == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleImplicitConnectionCache.purgeCacheConnections(bl, 1);
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCacheProperties(String string) throws SQLException {
        Serializable serializable;
        block15: {
            try {
                OracleImplicitConnectionCache oracleImplicitConnectionCache;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                        serializable = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
                if (oracleImplicitConnectionCache == null) break block15;
                serializable = oracleImplicitConnectionCache.getConnectionCacheProperties();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return serializable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                Object var5_14 = null;
            }
            catch (Throwable throwable) {
                Object var5_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        ((Throwable)serializable).fillInStackTrace();
        throw serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String[] getCacheNameList() throws SQLException {
        String[] stringArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    stringArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String[] stringArray2 = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringArray2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            stringArray = stringArray2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableConnections(String string) throws SQLException {
        SQLException sQLException;
        block15: {
            int n2;
            try {
                OracleImplicitConnectionCache oracleImplicitConnectionCache;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                        sQLException = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
                if (oracleImplicitConnectionCache == null) break block15;
                n2 = oracleImplicitConnectionCache.cacheSize;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                Object var5_15 = null;
            }
            catch (Throwable throwable) {
                Object var5_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfActiveConnections(String string) throws SQLException {
        SQLException sQLException;
        block15: {
            int n2;
            try {
                OracleImplicitConnectionCache oracleImplicitConnectionCache;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                        }
                        sQLException = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
                if (oracleImplicitConnectionCache == null) break block15;
                n2 = oracleImplicitConnectionCache.getNumberOfCheckedOutConnections();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                Object var5_15 = null;
            }
            catch (Throwable throwable) {
                Object var5_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionPoolDataSource(String string, ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            SQLException sQLException;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(connectionPoolDataSource));
                    }
                    sQLException = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleImplicitConnectionCache oracleImplicitConnectionCache2 = oracleImplicitConnectionCache = string != null ? (OracleImplicitConnectionCache)this.m_connCache.get(string) : null;
            if (oracleImplicitConnectionCache != null) {
                if (oracleImplicitConnectionCache.cacheSize > 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 78);
                            Object var6_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 78);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ((OracleConnectionPoolDataSource)connectionPoolDataSource).makeURL();
            ((OracleConnectionPoolDataSource)connectionPoolDataSource).setURL(((OracleConnectionPoolDataSource)connectionPoolDataSource).url);
            oracleImplicitConnectionCache.connectionPoolDS = (OracleConnectionPoolDataSource)connectionPoolDataSource;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAndHandleEvent(int n2, byte[] byArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n3 = 0;
        StringTokenizer stringTokenizer = null;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string7 = null;
            string6 = stringTokenizer.nextToken();
            if (string6.equals("=") && stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken();
            } else {
                string8 = string6;
            }
            if (string8.equalsIgnoreCase("version") && string7 != null && !string7.equals("1.0")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                        Object var14_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string8.equalsIgnoreCase("service") && string7 != null) {
                string = string7;
            }
            if (string8.equalsIgnoreCase("instance") && string7 != null && !string7.equals(" ")) {
                string2 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("database") && string7 != null) {
                string3 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("host") && string7 != null) {
                string4 = string7.toLowerCase().intern();
            }
            if (string8.equalsIgnoreCase("status") && string7 != null) {
                string5 = string7;
            }
            if (!string8.equalsIgnoreCase("card") || string7 == null) continue;
            try {
                n3 = Integer.parseInt(string7);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.invokeFailoverProcessingThreads(n2, string, string2, string3, string4, string5, n3);
        stringTokenizer = null;
    }

    private void invokeFailoverProcessingThreads(int n2, String string, String string2, String string3, String string4, String string5, int n3) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache2 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == 256) {
            bl = true;
        }
        if (n2 == 512) {
            bl2 = true;
        }
        for (OracleImplicitConnectionCache oracleImplicitConnectionCache2 : this.m_connCache.values()) {
            if ((!bl || !string.equalsIgnoreCase(oracleImplicitConnectionCache2.dataSourceServiceName)) && !bl2) continue;
            OracleFailoverWorkerThread oracleFailoverWorkerThread = new OracleFailoverWorkerThread(oracleImplicitConnectionCache2, n2, string2, string3, string4, string5, n3);
            this.checkAndStartThread(oracleFailoverWorkerThread);
            oracleImplicitConnectionCache2.failoverWorkerThread = oracleFailoverWorkerThread;
        }
    }

    protected void checkAndStartThread(Thread thread) throws SQLException {
        try {
            if (!thread.isAlive()) {
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    protected boolean failoverEnabledCacheExists() {
        return this.failoverEnabledCacheCount > 0;
    }

    protected void parseRuntimeLoadBalancingEvent(String string, byte[] byArray) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        Enumeration enumeration = this.m_connCache.elements();
        while (enumeration.hasMoreElements()) {
            try {
                oracleImplicitConnectionCache = (OracleImplicitConnectionCache)enumeration.nextElement();
                if (!string.equalsIgnoreCase(oracleImplicitConnectionCache.dataSourceServiceName)) continue;
                if (byArray == null) {
                    oracleImplicitConnectionCache.zapRLBInfo();
                    continue;
                }
                this.retrieveServiceMetrics(oracleImplicitConnectionCache, byArray);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveServiceMetrics(OracleImplicitConnectionCache oracleImplicitConnectionCache, byte[] byArray) throws SQLException {
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = null;
            string3 = stringTokenizer.nextToken();
            if (string3.equals("=") && stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            } else {
                if (string3.equals("}")) {
                    if (!bl) continue;
                    oracleImplicitConnectionCache.updateDatabaseInstance(string2, string, n2, n3);
                    bl = false;
                    continue;
                }
                if (string3.equals("{") || string3.equals(" ")) continue;
                string5 = string3;
                bl = true;
            }
            if (string5.equalsIgnoreCase("version") && string4 != null && !string4.equals("1.0")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                        Object var13_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string5.equalsIgnoreCase("database") && string4 != null) {
                string2 = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("instance") && string4 != null) {
                string = string4.toLowerCase().intern();
            }
            if (string5.equalsIgnoreCase("percent") && string4 != null) {
                try {
                    n2 = Integer.parseInt(string4);
                    if (n2 == 0) {
                        n2 = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!string5.equalsIgnoreCase("flag") || string4 == null) continue;
            if (string4.equalsIgnoreCase("good")) {
                n3 = 1;
                continue;
            }
            if (string4.equalsIgnoreCase("violating")) {
                n3 = 3;
                continue;
            }
            if (string4.equalsIgnoreCase("NO_DATA")) {
                n3 = 4;
                continue;
            }
            if (string4.equalsIgnoreCase("UNKNOWN")) {
                n3 = 2;
                continue;
            }
            if (!string4.equalsIgnoreCase("BLOCKED")) continue;
            n3 = 5;
        }
        oracleImplicitConnectionCache.processDatabaseInstances();
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.cleanupFCFWorkerThread(oracleImplicitConnectionCache);
        oracleImplicitConnectionCache.cleanupRLBThreads();
        if (this.failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.failoverEnabledCacheCount;
    }

    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        if (oracleImplicitConnectionCache.failoverWorkerThread != null) {
            try {
                if (oracleImplicitConnectionCache.failoverWorkerThread.isAlive()) {
                    oracleImplicitConnectionCache.failoverWorkerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            oracleImplicitConnectionCache.failoverWorkerThread = null;
        }
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        if (this.failoverEventHandlerThread != null) {
            try {
                this.failoverEventHandlerThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.failoverEventHandlerThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFatalConnectionError(SQLException sQLException) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sQLException));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = false;
            int n2 = sQLException.getErrorCode();
            if (n2 == 3113 || n2 == 3114 || n2 == 1033 || n2 == 1034 || n2 == 1089 || n2 == 1090 || n2 == 17002) {
                bl2 = true;
            }
            if (!bl2 && this.fatalErrorCodes != null) {
                for (bl = false; bl < this.fatalErrorCodes.length; bl += 1) {
                    if (n2 != this.fatalErrorCodes[bl]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl2);
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = bl2;
            Object var8_11 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_15 = null;
            }
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nArray));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (nArray != null) {
                this.fatalErrorCodes = nArray;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getConnectionErrorCodes() throws SQLException {
        int[] nArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fatalErrorCodes);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            nArray = this.fatalErrorCodes;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics(String string) throws SQLException {
        Map map;
        try {
            OracleImplicitConnectionCache oracleImplicitConnectionCache;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    oracleImplicitConnectionCache = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Map map2 = null;
            oracleImplicitConnectionCache = null;
            if (this.m_connCache != null && (oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string)) != null) {
                map2 = oracleImplicitConnectionCache.getStatistics();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map2);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            map = map2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return map;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

