/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

public class OracleLog {
    private static Vector registeredClassLOG = new Vector();
    private static final int maxPrintBytes = 512;
    public static boolean TRACE = false;
    private static ThreadLocal<Boolean> recursiveTrace = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Integer> callDepth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    public static final Level INTERNAL_ERROR = OracleLevel.INTERNAL_ERROR;
    public static final Level TRACE_1 = OracleLevel.TRACE_1;
    public static final Level TRACE_10 = OracleLevel.TRACE_10;
    public static final Level TRACE_16 = OracleLevel.TRACE_16;
    public static final Level TRACE_20 = OracleLevel.TRACE_20;
    public static final Level TRACE_30 = OracleLevel.TRACE_30;
    public static final Level TRACE_32 = OracleLevel.TRACE_32;
    static boolean securityExceptionWhileGettingSystemProperties;

    public static boolean isDebugZip() {
        boolean bl = true;
        bl = false;
        return bl;
    }

    public static boolean isPrivateLogAvailable() {
        boolean bl = false;
        return bl;
    }

    public static boolean isEnabled() {
        return TRACE;
    }

    public static boolean registerClassNameAndGetCurrentTraceSetting(Class clazz) {
        if (!registeredClassLOG.contains(clazz)) {
            registeredClassLOG.addElement(clazz);
        }
        return TRACE;
    }

    public static void setTrace(boolean bl) {
        Enumeration enumeration = registeredClassLOG.elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            try {
                clazz.getField("TRACE").setBoolean(null, bl);
            }
            catch (Exception exception) {}
        }
        TRACE = bl;
    }

    private static void initialize() {
        OracleLog.setupFromSystemProperties();
    }

    public static void setupFromSystemProperties() {
        boolean bl = false;
        securityExceptionWhileGettingSystemProperties = false;
        try {
            String string = null;
            string = OracleLog.getSystemProperty("oracle.jdbc.Trace", null);
            if (string != null && string.compareTo("true") == 0) {
                bl = true;
            }
        }
        catch (SecurityException securityException) {
            securityExceptionWhileGettingSystemProperties = true;
        }
        OracleLog.setTrace(bl);
    }

    private static String getSystemProperty(String string) {
        return OracleLog.getSystemProperty(string, null);
    }

    private static String getSystemProperty(String string, String string2) {
        if (string != null) {
            final String string3 = string;
            final String string4 = string2;
            final String[] stringArray = new String[]{string2};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    stringArray[0] = System.getProperty(string3, string4);
                    return null;
                }
            });
            return stringArray[0];
        }
        return string2;
    }

    public static String argument() {
        return "";
    }

    public static String argument(boolean bl) {
        return Boolean.toString(bl);
    }

    public static String argument(byte by) {
        return Byte.toString(by);
    }

    public static String argument(short s2) {
        return Short.toString(s2);
    }

    public static String argument(int n2) {
        return Integer.toString(n2);
    }

    public static String argument(long l2) {
        return Long.toString(l2);
    }

    public static String argument(float f2) {
        return Float.toString(f2);
    }

    public static String argument(double d2) {
        return Double.toString(d2);
    }

    public static String argument(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        return object.toString();
    }

    public static String byteToHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0xFF & by;
        if (n2 <= 15) {
            stringBuffer.append("0x0");
        } else {
            stringBuffer.append("0x");
        }
        stringBuffer.append(Integer.toHexString(n2));
        return stringBuffer.toString();
    }

    public static String bytesToPrintableForm(String string, byte[] byArray) {
        int n2 = byArray == null ? 0 : byArray.length;
        return OracleLog.bytesToPrintableForm(string, byArray, n2);
    }

    public static String bytesToPrintableForm(String string, byte[] byArray, int n2) {
        String string2 = null;
        string2 = byArray == null ? string + ": null" : string + " (" + byArray.length + " bytes):\n" + OracleLog.bytesToFormattedStr(byArray, n2, "  ");
        return string2;
    }

    public static String bytesToFormattedStr(byte[] byArray, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            string = new String("");
        }
        stringBuffer.append(string);
        if (byArray == null) {
            stringBuffer.append("byte [] is null");
            return stringBuffer.toString();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            if (i2 >= 512) {
                stringBuffer.append("\n" + string + "... last " + (n2 - 512) + " bytes were not printed to limit the output size");
                break;
            }
            if (i2 > 0 && i2 % 20 == 0) {
                stringBuffer.append("\n" + string);
            }
            if (i2 % 20 == 10) {
                stringBuffer.append(" ");
            }
            if ((n3 = 0xFF & byArray[i2]) <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n3) + " ");
        }
        return stringBuffer.toString();
    }

    public static byte[] strToUcs2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(string.toCharArray());
    }

    public static byte[] charsToUcs2Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n2) {
        if (cArray == null) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, n2, 0);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        if (n2 > cArray.length - n3) {
            n2 = cArray.length - n3;
        }
        if (n2 < 0) {
            return null;
        }
        byte[] byArray = new byte[2 * n2];
        int n4 = 0;
        for (int i2 = n3; i2 < n2; ++i2) {
            byArray[n4++] = (byte)(cArray[i2] >> 8 & 0xFF);
            byArray[n4++] = (byte)(cArray[i2] & 0xFF);
        }
        return byArray;
    }

    public static String toPrintableStr(String string, int n2) {
        if (string == null) {
            return "null";
        }
        if (string.length() > n2) {
            return string.substring(0, n2 - 1) + "\n ... the actual length was " + string.length();
        }
        return string;
    }

    public static boolean recursiveEnter() {
        if (recursiveTrace.get().booleanValue()) {
            return false;
        }
        recursiveTrace.set(true);
        return true;
    }

    public static void recursiveExit() {
        recursiveTrace.set(false);
    }

    public static boolean isPublic() {
        return callDepth.get() == 1;
    }

    public static boolean enter() {
        int n2 = callDepth.get();
        callDepth.set(n2 + 1);
        return n2 == 0;
    }

    public static boolean exit() {
        int n2 = callDepth.get() - 1;
        callDepth.set(n2);
        return n2 == 0;
    }

    public static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return OracleLog.toHex(l2 >> 32, 4) + OracleLog.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    public static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    public static String toHex(short s2) {
        return OracleLog.toHex(s2, 2);
    }

    public static String toHex(int n2) {
        return OracleLog.toHex(n2, 4);
    }

    public static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + OracleLog.toHex(byArray[i2]) + " ";
        }
        if (n3 < n2) {
            string = string + "...";
        }
        return string + "]";
    }

    public static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return OracleLog.toHex(byArray, byArray.length);
    }

    static {
        OracleLog.initialize();
    }

    private static class OracleLevel
    extends Level {
        static final OracleLevel INTERNAL_ERROR = new OracleLevel("INTERNAL_ERROR", 1100);
        static final OracleLevel TRACE_1 = new OracleLevel("TRACE_1", Level.FINE.intValue());
        static final OracleLevel TRACE_10 = new OracleLevel("TRACE_10", 446);
        static final OracleLevel TRACE_16 = new OracleLevel("TRACE_16", Level.FINER.intValue());
        static final OracleLevel TRACE_20 = new OracleLevel("TRACE_20", 376);
        static final OracleLevel TRACE_30 = new OracleLevel("TRACE_30", 316);
        static final OracleLevel TRACE_32 = new OracleLevel("TRACE_32", Level.FINEST.intValue());

        OracleLevel(String string, int n2) {
            super(string, n2);
        }
    }
}

