/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.XSEvent;

class NTFXSEvent
extends XSEvent {
    private final byte[] sid_kpuzxsss;
    private final KeywordValueLongI[] sess_kpuzxsss;
    private final int flg_kpuzxsss;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    NTFXSEvent(T4CConnection t4CConnection) throws SQLException, IOException {
        super(t4CConnection);
        T4CMAREngine t4CMAREngine = t4CConnection.getMarshalEngine();
        this.sid_kpuzxsss = t4CMAREngine.unmarshalDALC();
        int n2 = (int)t4CMAREngine.unmarshalUB4();
        byte by = (byte)t4CMAREngine.unmarshalUB1();
        this.sess_kpuzxsss = new KeywordValueLongI[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sess_kpuzxsss[i2] = KeywordValueLongI.unmarshal(t4CMAREngine);
        }
        this.flg_kpuzxsss = (int)t4CMAREngine.unmarshalUB4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSessionId() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sid_kpuzxsss);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.sid_kpuzxsss;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeywordValueLong[] getDetails() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (KeywordValueLong[])this.sess_kpuzxsss);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            KeywordValueLong[] keywordValueLongArray = this.sess_kpuzxsss;
            return keywordValueLongArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlags() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.flg_kpuzxsss);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.flg_kpuzxsss;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("sid_kpuzxsss  : " + NTFAQEvent.byteBufferToHexString(this.sid_kpuzxsss, 50) + "\n");
            stringBuffer.append("sess_kpuzxsss : \n");
            stringBuffer.append("  size : " + this.sess_kpuzxsss.length + "\n");
            for (int i2 = 0; i2 < this.sess_kpuzxsss.length; ++i2) {
                stringBuffer.append("  sess_kpuzxsss #" + i2 + " : \n");
                if (this.sess_kpuzxsss[i2] == null) {
                    stringBuffer.append("null\n");
                    continue;
                }
                stringBuffer.append(this.sess_kpuzxsss[i2].toString());
            }
            stringBuffer.append("flg_kpuzxsss  : " + this.flg_kpuzxsss + "\n");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stringBuffer.toString());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFXSEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

