/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryDoubleAccessor
extends Accessor {
    static final int MAXLENGTH = 8;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    BinaryDoubleAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 101, 101, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BinaryDoubleAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 101, 101, s2, false);
        this.initForDescribe(101, n2, bl, n3, n4, n5, n6, n7, s2, null);
        int n8 = oracleStatement.maxFieldSize;
        if (n8 > 0 && (n2 == 0 || n8 < n2)) {
            n2 = n8;
        }
        this.initForDataAccess(0, n2, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDataAccess(n5, n4, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9, short s2) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDescribe(n2, n4, bl, n5, n6, n7, n8, n9, s2, null);
        int n10 = oracleStatement.maxFieldSize;
        if (n10 > 0 && (n4 == 0 || n10 < n4)) {
            n4 = n10;
        }
        this.initForDataAccess(0, n4, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 8;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getDouble(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0.0;
        }
        int n3 = this.columnIndex + this.byteLength * n2;
        int n4 = this.rowSpaceByte[n3];
        int n5 = this.rowSpaceByte[n3 + 1];
        int n6 = this.rowSpaceByte[n3 + 2];
        int n7 = this.rowSpaceByte[n3 + 3];
        int n8 = this.rowSpaceByte[n3 + 4];
        int n9 = this.rowSpaceByte[n3 + 5];
        int n10 = this.rowSpaceByte[n3 + 6];
        int n11 = this.rowSpaceByte[n3 + 7];
        if ((n4 & 0x80) != 0) {
            n4 &= 0x7F;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
            n9 &= 0xFF;
            n10 &= 0xFF;
            n11 &= 0xFF;
        } else {
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
            n9 = ~n9 & 0xFF;
            n10 = ~n10 & 0xFF;
            n11 = ~n11 & 0xFF;
        }
        int n12 = n4 << 24 | n5 << 16 | n6 << 8 | n7;
        int n13 = n8 << 24 | n9 << 16 | n10 << 8 | n11;
        long l2 = (long)n12 << 32 | (long)n13 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return Double.toString(this.getDouble(n2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new Double(this.getDouble(n2));
        }
        return null;
    }

    Object getObject(int n2, Map map) throws SQLException {
        return new Double(this.getDouble(n2));
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getBINARY_DOUBLE(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BINARY_DOUBLE getBINARY_DOUBLE(int n2) throws SQLException {
        BINARY_DOUBLE bINARY_DOUBLE = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            bINARY_DOUBLE = new BINARY_DOUBLE(byArray);
        }
        return bINARY_DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NUMBER getNUMBER(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new NUMBER(this.getDouble(n2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInteger getBigInteger(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new BigInteger(this.getString(n2));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    BinaryDoubleAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new BigDecimal(this.getString(n2));
        }
        return null;
    }

    byte getByte(int n2) throws SQLException {
        return (byte)this.getDouble(n2);
    }

    short getShort(int n2) throws SQLException {
        return (short)this.getDouble(n2);
    }

    int getInt(int n2) throws SQLException {
        return (int)this.getDouble(n2);
    }

    long getLong(int n2) throws SQLException {
        return (long)this.getDouble(n2);
    }

    float getFloat(int n2) throws SQLException {
        return (float)this.getDouble(n2);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BinaryDoubleAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

