/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.jdbc.connector.OracleLocalTransaction;
import oracle.jdbc.connector.OracleManagedConnectionMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;

public class OracleManagedConnection
implements ManagedConnection {
    private OracleXAConnection xaConnection = null;
    private Hashtable connectionListeners = null;
    private Connection connection = null;
    private PrintWriter logWriter = null;
    private PasswordCredential passwordCredential = null;
    private OracleLocalTransaction localTxn = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleManagedConnection(XAConnection xAConnection) {
        this.xaConnection = (OracleXAConnection)xAConnection;
        this.connectionListeners = new Hashtable(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(connectionRequestInfo));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                this.connection = this.xaConnection.getConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Connection connection = this.connection;
                return connection;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.xaConnection != null) {
                    Connection connection = this.xaConnection.getPhysicalHandle();
                    if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)connection).getTxnMode() == 1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleManagedConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalStateException: " + "Could not close connection while transaction is active");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new IllegalStateException("Could not close connection while transaction is active");
                    }
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                if (this.xaConnection != null) {
                    this.xaConnection.close();
                }
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        block22: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    if (this.connection == null) break block22;
                    if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)this.connection).getTxnMode() == 1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleManagedConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalStateException: " + "Could not close connection while transaction is active");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new IllegalStateException("Could not close connection while transaction is active");
                    }
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                    eISSystemException.setLinkedException((Exception)sQLException);
                    throw eISSystemException;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object object) {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connectionListeners.put(connectionEventListener, connectionEventListener);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionEventListener));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connectionListeners.remove(connectionEventListener);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XAResource xAResource = this.xaConnection.getXAResource();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xAResource);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            XAResource xAResource2 = xAResource;
            return xAResource2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTransaction getLocalTransaction() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.localTxn == null) {
                this.localTxn = new OracleLocalTransaction(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.localTxn);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleLocalTransaction oracleLocalTransaction = this.localTxn;
            return oracleLocalTransaction;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleManagedConnectionMetaData oracleManagedConnectionMetaData = new OracleManagedConnectionMetaData(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleManagedConnectionMetaData);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleManagedConnectionMetaData oracleManagedConnectionMetaData2 = oracleManagedConnectionMetaData;
            return oracleManagedConnectionMetaData2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(printWriter));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.logWriter = printWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getLogWriter() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.logWriter);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PrintWriter printWriter = this.logWriter;
            return printWriter;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    Connection getPhysicalConnection() throws ResourceException {
        try {
            return this.xaConnection.getPhysicalHandle();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    void setPasswordCredential(PasswordCredential passwordCredential) {
        this.passwordCredential = passwordCredential;
    }

    PasswordCredential getPasswordCredential() {
        return this.passwordCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eventOccurred(int n2) throws ResourceException {
        Enumeration enumeration = this.connectionListeners.keys();
        block10: while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n2);
            switch (n2) {
                case 1: {
                    connectionEventListener.connectionClosed(connectionEvent);
                    continue block10;
                }
                case 2: {
                    connectionEventListener.localTransactionStarted(connectionEvent);
                    continue block10;
                }
                case 3: {
                    connectionEventListener.localTransactionCommitted(connectionEvent);
                    continue block10;
                }
                case 4: {
                    connectionEventListener.localTransactionRolledback(connectionEvent);
                    continue block10;
                }
                case 5: {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                    continue block10;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "Illegal eventType in eventOccurred(): " + n2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new IllegalArgumentException("Illegal eventType in eventOccurred(): " + n2);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

