/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.opmn;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.ons.BodyBlock;
import oracle.ons.BodyElement;
import oracle.ons.BodySegment;
import oracle.ons.HeaderBlock;
import oracle.ons.opmn.ProcReadyApp;
import oracle.ons.opmn.ProcReadyPort;

public final class OpmnProcReady {
    private HashMap appMap = new HashMap();
    private HashMap portMap = new HashMap();
    private HashMap specMap = new HashMap();
    private String procID;
    private String specSegName;
    private int generationNum = (int)(Calendar.getInstance().getTimeInMillis() & 0xFFFFFFFFFFFFFFFFL);
    private boolean generationIterated = false;
    private static String OPMNDMS_SEG = "OpmnDms";
    static final String DMS_BB_NAME = "DMS";

    public OpmnProcReady(String processId) {
        this.specSegName = "opmn_" + processId + "_proc";
        this.procID = this.specSegName + "@specialized/";
    }

    public void newMessage() {
        this.generationIterated = false;
        this.specMap.clear();
    }

    public void addApplication(ProcReadyApp newApp) {
        ProcReadyApp oldApp = this.appMap.put(newApp.prName, newApp);
        if (oldApp != null) {
            if (!this.generationIterated && !oldApp.equals(newApp)) {
                ++this.generationNum;
                this.generationIterated = true;
            }
        } else {
            ++this.generationNum;
            this.generationIterated = true;
        }
    }

    public void addPort(ProcReadyPort newPort) {
        ProcReadyPort oldPort = this.portMap.put(newPort.prName, newPort);
        if (oldPort != null) {
            if (!this.generationIterated && !oldPort.equals(newPort)) {
                ++this.generationNum;
                this.generationIterated = true;
            }
        } else {
            ++this.generationNum;
            this.generationIterated = true;
        }
    }

    public void addSpecialized(String key, String val) {
        this.specMap.put(key, val);
    }

    public void addToProcReady(HeaderBlock hBlock, BodyBlock addBlock) {
        BodySegment nuSeg;
        LinkedList<String> unsedKeys = new LinkedList<String>();
        BodySegment opmnDMSSeg = OpmnProcReady.getOPMNDMSSegment(addBlock);
        Iterator<Object> it = this.appMap.values().iterator();
        if (it.hasNext()) {
            nuSeg = new BodySegment("opmn_app");
            while (it.hasNext()) {
                ProcReadyApp curApp = (ProcReadyApp)it.next();
                if (curApp.visited) {
                    curApp.addToAppSegment(nuSeg);
                    curApp.visited = false;
                    continue;
                }
                unsedKeys.add(curApp.prName);
            }
            opmnDMSSeg.addSegment(nuSeg);
            it = unsedKeys.iterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    this.appMap.remove(it.next());
                }
                if (!this.generationIterated) {
                    ++this.generationNum;
                    this.generationIterated = true;
                }
            }
            unsedKeys.clear();
        }
        it = this.portMap.values().iterator();
        BodySegment dmsSeg = null;
        if (it.hasNext()) {
            nuSeg = new BodySegment("opmn_connect");
            while (it.hasNext()) {
                ProcReadyPort curPort = (ProcReadyPort)it.next();
                if (curPort.visited) {
                    curPort.addToPortSegment(nuSeg);
                    if (curPort.isCompatibilityPort()) {
                        if (dmsSeg == null) {
                            dmsSeg = OpmnProcReady.getDMSSegment(addBlock);
                        }
                        curPort.addOldFormat(dmsSeg);
                    }
                    curPort.visited = false;
                    continue;
                }
                unsedKeys.add(curPort.prName);
            }
            opmnDMSSeg.addSegment(nuSeg);
            it = unsedKeys.iterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    this.portMap.remove(it.next());
                }
                unsedKeys.clear();
                if (!this.generationIterated) {
                    ++this.generationNum;
                    this.generationIterated = true;
                }
            }
        }
        if ((it = this.specMap.keySet().iterator()).hasNext()) {
            dmsSeg = new BodySegment(this.specSegName);
            BodySegment oc4jSpecSegment = new BodySegment("specialized");
            OpmnProcReady.getOPMNDMSSegment(addBlock).addSegment(dmsSeg);
            dmsSeg.addSegment(oc4jSpecSegment);
            dmsSeg = OpmnProcReady.getDMSSegment(addBlock);
            while (it.hasNext()) {
                String newKey = (String)it.next();
                dmsSeg.addElement(new BodyElement(this.procID + newKey, (String)this.specMap.get(newKey)));
                oc4jSpecSegment.addElement(new BodyElement(newKey, (String)this.specMap.get(newKey)));
            }
        }
        hBlock.putHeaderElement("GenNum", Integer.toString(this.generationNum));
        this.generationIterated = false;
    }

    private static BodySegment getDMSSegment(BodyBlock sBlock) {
        return OpmnProcReady.getBodySegment(sBlock, DMS_BB_NAME);
    }

    public static BodySegment getOPMNDMSSegment(BodyBlock sBlock) {
        return OpmnProcReady.getBodySegment(sBlock, OPMNDMS_SEG);
    }

    public static BodySegment getBodySegment(BodyBlock sBlock, String segName) {
        BodySegment opmnBodySeg2 = null;
        for (BodySegment opmnBodySeg2 : sBlock.getSegmentList()) {
            if (!segName.equals(opmnBodySeg2.getName())) continue;
            return opmnBodySeg2;
        }
        opmnBodySeg2 = new BodySegment(segName);
        sBlock.addSegment(opmnBodySeg2);
        return opmnBodySeg2;
    }
}

