/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.ons.InputBuffer;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.ReceiverThread;
import oracle.ons.SenderThread;
import oracle.security.pki.OracleWallet;

public class Connection {
    private ONS ons;
    private String host;
    private int port;
    private String id;
    private Object socketlock;
    private int waiters;
    private boolean shutdown;
    private int serverVersion;
    protected static final String RequestPrefix = "POST /connect HTTP/1.1\r\nContent-Length: 0\r\nOPMNtype: pm\r\nOPMNrequest: /";
    protected static final String RequestFormFactor = "\r\nFormFactor: ";
    protected static final String RequestSuffix = "\r\n\r\n";
    protected static final String ResponseOK = "HTTP/1.1 200 OK";
    protected Socket socket;
    protected ReceiverThread receiver;
    protected SenderThread sender;

    protected Connection(ONS cOns, String cHost, int cPort) {
        this.ons = cOns;
        this.host = cHost;
        this.port = cPort;
        this.socketlock = new Object();
        this.socket = null;
        this.shutdown = false;
        this.waiters = 0;
        this.id = new String(this.host + ":" + Integer.toString(this.port));
        this.serverVersion = 4;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.id;
    }

    public void setServerVersion(int version) {
        this.serverVersion = version;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        Status status = Status.Idle;
        Object object = this.socketlock;
        synchronized (object) {
            if (this.shutdown) {
                status = Status.Shutdown;
            } else if (this.socket != null) {
                status = Status.Connected;
            } else if (this.receiver != null) {
                status = Status.Connecting;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingServer() {
        boolean status;
        Socket sock;
        try {
            sock = this.connect();
        }
        catch (SocketTimeoutException stoe) {
            return false;
        }
        if (sock == null) {
            return false;
        }
        try {
            status = this.sendRequest(sock, "ping");
            if (status && !(status = this.checkResponse(sock)) && this.ons.walletfile != null) {
                status = true;
            }
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException iOException) {}
        }
        return status;
    }

    protected void setClientReceiver(ReceiverThread recv) {
        this.receiver = recv;
    }

    protected void setClientSender(SenderThread send) {
        this.sender = send;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket getClientSocket(boolean block) {
        Socket ret = null;
        Object object = this.socketlock;
        synchronized (object) {
            ++this.waiters;
            while (!this.shutdown && block && this.socket == null) {
                try {
                    this.socketlock.wait();
                }
                catch (Exception e) {}
            }
            --this.waiters;
            ret = this.socket;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientSocket(Socket sock) {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        Object object = this.socketlock;
        synchronized (object) {
            this.socket = sock;
            if (this.waiters > 0) {
                this.socketlock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeClientSocket() {
        Socket sock;
        Object object = this.socketlock;
        synchronized (object) {
            sock = this.socket;
            this.socket = null;
        }
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.serverVersion = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientShutdown(boolean shut) {
        Object object = this.socketlock;
        synchronized (object) {
            this.shutdown = shut;
            if (shut && this.waiters > 0) {
                this.socketlock.notifyAll();
            }
        }
    }

    protected Socket connect() throws SocketTimeoutException {
        Socket sock;
        block19: {
            sock = null;
            try {
                SSLSocketFactory factory;
                if (this.ons.walletfile != null) {
                    if (ONS.debug) {
                        ONS.outstream.println("Connection::establishConnection[" + this.id + "] ==> " + "SSL: walletfile=" + this.ons.walletfile);
                    }
                    SSLContext context = SSLContext.getInstance("SSL");
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    OracleWallet owallet = new OracleWallet();
                    owallet.open(this.ons.walletfile, this.ons.password);
                    KeyStore ks = owallet.getKeyStore();
                    kmf.init(ks, this.ons.password);
                    tmf.init(ks);
                    context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                    factory = context.getSocketFactory();
                } else {
                    if (ONS.debug) {
                        ONS.outstream.println("Connection::establishConnection[" + this.id + "] ==> no SSL");
                    }
                    factory = null;
                }
                int contimeout = 0;
                if (!ONS.localConn) {
                    if (ONS.remoteIOtimeout != 0) {
                        contimeout = ONS.remoteIOtimeout * 2;
                    }
                }
                InetAddress addr = InetAddress.getByName(this.host);
                InetSocketAddress sockaddr = new InetSocketAddress(addr, this.port);
                sock = new Socket();
                sock.connect(sockaddr, contimeout);
                if (!ONS.localConn) {
                    if (ONS.remoteIOtimeout != 0) {
                        sock.setSoTimeout(ONS.remoteIOtimeout);
                    }
                }
                sock.setSoLinger(true, 5);
                if (factory != null) {
                    Socket raw = sock;
                    sock = factory.createSocket(raw, this.host, this.port, true);
                }
            }
            catch (SocketTimeoutException stoe) {
                if (ONS.debug) {
                    ONS.errstream.println("Timeout Connection::establishConnection[" + this.id + "]");
                    stoe.printStackTrace(ONS.errstream);
                }
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    sock = null;
                }
                throw stoe;
            }
            catch (Exception e) {
                if (ONS.debug) {
                    ONS.errstream.println("Exception Connection::establishConnection[" + this.id + "]");
                    e.printStackTrace(ONS.errstream);
                }
                if (sock == null) break block19;
                try {
                    sock.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                sock = null;
            }
        }
        return sock;
    }

    private boolean sendRequest(Socket sock, String request) {
        boolean status;
        try {
            OutputBuffer oBuf = new OutputBuffer(sock.getOutputStream());
            oBuf.putString(RequestPrefix);
            oBuf.putString(request);
            if (ONS.localConn) {
                oBuf.putString(RequestFormFactor);
                oBuf.putString(this.ons.getFormFactor(this.ons.oraclehome));
            }
            oBuf.putString(RequestSuffix);
            oBuf.flush();
            if (ONS.debug) {
                ONS.outstream.println("Connection::sendRequest[" + this.id + "] ==> sent: " + request);
            }
            status = true;
        }
        catch (IOException e) {
            if (ONS.debug) {
                ONS.outstream.println("Connection::sendRequest[" + this.id + "] ==> IO exception: " + request);
                e.printStackTrace(ONS.errstream);
            }
            status = false;
        }
        return status;
    }

    private boolean checkResponse(Socket sock) {
        boolean status;
        try {
            InputBuffer iBuf = new InputBuffer(new BufferedInputStream(sock.getInputStream()));
            String response = iBuf.getNextString();
            if (ONS.debug) {
                ONS.outstream.println("Connection::checkResponse[" + this.id + "] ==> response: " + response);
            }
            status = response.startsWith(ResponseOK);
        }
        catch (IOException e) {
            if (ONS.debug) {
                ONS.outstream.println("Connection::checkResponse[" + this.id + "] ==> IO exception");
                e.printStackTrace(ONS.errstream);
            }
            status = false;
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        Idle,
        Connecting,
        Connected,
        Shutdown;

    }
}

