/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgx.config.internal.EmbeddingConfigDeserializer;
import oracle.pgx.config.internal.GraphWiseBaseConvLayerConfigDeserializer;
import oracle.pgx.config.internal.categorymapping.CategoryMappingConfig;
import oracle.pgx.config.mllib.GraphWiseBaseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseBaseModelConfig;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.GraphWiseEmbeddingConfig;
import oracle.pgx.config.mllib.GraphWiseModelConfig;
import oracle.pgx.config.mllib.GraphWiseValidationConfig;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;

public class UnsupervisedGraphWiseModelConfig
extends GraphWiseModelConfig {
    public static final LossFunction DEFAULT_LOSS_FUNCTION = LossFunction.SIGMOID_CROSS_ENTROPY;
    public static final GraphWiseDgiLayerConfig DEFAULT_DGI_LAYER_CONFIG = new GraphWiseDgiLayerConfig();
    private LossFunction lossFunction = DEFAULT_LOSS_FUNCTION;
    private GraphWiseDgiLayerConfig dgiLayerConfig = DEFAULT_DGI_LAYER_CONFIG;
    @JsonDeserialize(using=EmbeddingConfigDeserializer.class)
    private GraphWiseEmbeddingConfig embeddingConfig = DEFAULT_DGI_LAYER_CONFIG;

    public UnsupervisedGraphWiseModelConfig() {
    }

    @JsonCreator
    public UnsupervisedGraphWiseModelConfig(@JsonProperty(required=true, value="batchSize") int batchSize, @JsonProperty(required=true, value="numEpochs") int numEpochs, @JsonProperty(required=true, value="learningRate") double learningRate, @JsonProperty(required=false, value="weightDecay") double weightDecay, @JsonProperty(required=true, value="embeddingDim") int embeddingDim, @JsonProperty(required=true, value="seed") Integer seed, @JsonDeserialize(contentUsing=GraphWiseBaseConvLayerConfigDeserializer.class) @JsonProperty(required=true, value="convLayerConfigs") GraphWiseBaseConvLayerConfig[] convLayerConfigs, @JsonProperty(required=true, value="standardize") boolean standardize, @JsonProperty(required=false, value="normalize") boolean normalize, @JsonProperty(required=true, value="shuffle") boolean shuffle, @JsonProperty(required=true, value="vertexInputPropertyNames") List<String> vertexInputPropertyNames, @JsonProperty(required=false, value="edgeInputPropertyNames") List<String> edgeInputPropertyNames, @JsonProperty(required=false, value="vertexInputPropertyConfigs") Map<String, InputPropertyConfig> vertexInputPropertyConfigs, @JsonProperty(required=false, value="edgeInputPropertyConfigs") Map<String, InputPropertyConfig> edgeInputPropertyConfigs, @JsonProperty(required=false, value="categoryMappingConfig") CategoryMappingConfig categoryMappingConfig, @JsonProperty(required=false, value="targetVertexLabelSets") List<Set<String>> targetVertexLabels, @JsonProperty(required=true, value="fitted") boolean fitted, @JsonProperty(required=true, value="trainingLoss") double trainingLoss, @JsonProperty(required=true, value="inputFeatureDim") int inputFeatureDim, @JsonProperty(required=false, value="inputEdgeFeatureDim") int inputEdgeFeatureDim, @JsonProperty(required=true, value="lossFunction") LossFunction lossFunction, @JsonProperty(required=false, value="dgiLayerConfig") GraphWiseDgiLayerConfig dgiLayerConfig, @JsonProperty(required=false, value="embeddingConfig") GraphWiseEmbeddingConfig embeddingConfig, @JsonProperty(required=true, value="backend") GraphWiseBaseModelConfig.Backend backend, @JsonProperty(required=false, value="variant") GraphWiseModelConfig.GraphConvModelVariant variant, @JsonProperty(required=false, value="enableAccelerator") boolean enableAccelerator, @JsonProperty(required=false, value="validationConfig") GraphWiseValidationConfig validationConfig) {
        super(batchSize, numEpochs, learningRate, weightDecay, embeddingDim, seed, convLayerConfigs, standardize, normalize, shuffle, vertexInputPropertyNames, edgeInputPropertyNames, vertexInputPropertyConfigs, edgeInputPropertyConfigs, categoryMappingConfig, fitted, trainingLoss, inputFeatureDim, inputEdgeFeatureDim, targetVertexLabels, backend, variant, enableAccelerator, validationConfig);
        this.lossFunction = lossFunction;
        this.dgiLayerConfig = dgiLayerConfig;
        this.embeddingConfig = embeddingConfig;
        if (embeddingConfig == null && dgiLayerConfig == null) {
            throw new IllegalStateException("Invalid Model Config");
        }
    }

    public UnsupervisedGraphWiseModelConfig(UnsupervisedGraphWiseModelConfig source) {
        super(source);
        this.setLossFunction(source.getLossFunction());
        this.setDgiLayerConfig(source.getDgiLayerConfig());
        this.setEmbeddingConfig(source.getEmbeddingConfig());
    }

    public UnsupervisedGraphWiseModelConfig(UnsupervisedGraphWiseModelConfig source, CategoryMappingConfig categoryMappingConfig) {
        this(source);
        this.setCategoryMappingConfig(categoryMappingConfig);
    }

    @Deprecated
    public GraphWiseDgiLayerConfig getDgiLayerConfig() {
        return this.dgiLayerConfig;
    }

    @Deprecated
    public final void setDgiLayerConfig(GraphWiseDgiLayerConfig dgiLayerConfig) {
        this.dgiLayerConfig = dgiLayerConfig;
    }

    public GraphWiseEmbeddingConfig getEmbeddingConfig() {
        return this.embeddingConfig;
    }

    public final void setEmbeddingConfig(GraphWiseEmbeddingConfig embeddingConfig) {
        this.embeddingConfig = embeddingConfig;
    }

    public LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public final void setLossFunction(LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public boolean isRegression() {
        return false;
    }

    public static enum LossFunction {
        SIGMOID_CROSS_ENTROPY;

    }
}

