/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal.categorymapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.config.internal.categorymapping.CategoryMap;

public class CategoryMapSet {
    private final Map<String, CategoryMap> categoryMaps;
    private final Map<String, Integer> cardinalityMap;

    @JsonCreator
    public CategoryMapSet(@JsonProperty(required=true, value="categoryMaps") Map<String, CategoryMap> categoryMaps, @JsonProperty(required=true, value="cardinalityMap") Map<String, Integer> cardinalityMap) {
        this.categoryMaps = categoryMaps;
        this.cardinalityMap = cardinalityMap;
    }

    public CategoryMapSet() {
        this.categoryMaps = new HashMap<String, CategoryMap>();
        this.cardinalityMap = new HashMap<String, Integer>();
    }

    public CategoryMapSet(Map<String, CategoryMap> categoryMaps) {
        this.categoryMaps = categoryMaps;
        this.cardinalityMap = new HashMap<String, Integer>();
        for (Map.Entry<String, CategoryMap> entry : categoryMaps.entrySet()) {
            this.cardinalityMap.put(entry.getKey(), entry.getValue().getSize());
        }
    }

    @JsonIgnore
    public void addCategoryMap(String propertyName, CategoryMap categoryMap) {
        this.categoryMaps.put(propertyName, categoryMap);
        this.cardinalityMap.put(propertyName, categoryMap.getSize());
    }

    public Map<String, Integer> getCardinalityMap() {
        return this.cardinalityMap;
    }

    public Map<String, CategoryMap> getCategoryMaps() {
        return this.categoryMaps;
    }

    @JsonIgnore
    public boolean containsPropertyName(String propertyName) {
        return this.categoryMaps.containsKey(propertyName);
    }

    @JsonIgnore
    public int getSize() {
        return this.categoryMaps.size();
    }

    @JsonIgnore
    public long getCategoryIndex(String propertyName, String propertyValue) {
        return this.categoryMaps.get(propertyName).getCategoryIndex(propertyValue);
    }

    @JsonIgnore
    public boolean equals(Object o) {
        if (o instanceof CategoryMapSet) {
            CategoryMapSet otherMapSet = (CategoryMapSet)o;
            return Objects.equals(this.categoryMaps, otherMapSet.getCategoryMaps()) && this.cardinalityMap.equals(otherMapSet.getCardinalityMap());
        }
        return false;
    }
}

