/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.mllib.inputconfig.CategoricalEmbeddingType;
import oracle.pgx.config.mllib.inputconfig.ContinuousPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.EmbeddingTableConfig;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.OneHotEncodingConfig;

public class InputPropertyConfigDeserializer
extends JsonDeserializer<InputPropertyConfig> {
    public InputPropertyConfig deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        boolean isCategorical = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "categorical"), Boolean.class);
        String propertyName = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "propertyName"), String.class);
        if (!isCategorical) {
            return new ContinuousPropertyConfig(propertyName);
        }
        CategoricalEmbeddingType type = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "categoricalEmbeddingType"), CategoricalEmbeddingType.class);
        boolean isShared = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "shared"), Boolean.class);
        Integer maxVocabularySize = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "maxVocabularySize"), Integer.class);
        switch (type) {
            case EMBEDDING_TABLE: {
                Integer embeddingDim = null;
                Double outOfVocabularyProbability = null;
                EmbeddingTableConfig embeddingTableConfig = new EmbeddingTableConfig(propertyName);
                embeddingTableConfig.setShared(isShared);
                embeddingTableConfig.setMaxVocabularySize(maxVocabularySize);
                if (node.has("embeddingDimension") && !node.get("embeddingDimension").isNull()) {
                    embeddingDim = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "embeddingDimension"), Integer.class);
                    embeddingTableConfig.setEmbeddingDimension(embeddingDim);
                }
                if (node.has("outOfVocabularyProbability") && !node.get("outOfVocabularyProbability").isNull()) {
                    outOfVocabularyProbability = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "outOfVocabularyProbability"), Double.class);
                    embeddingTableConfig.setOutOfVocabularyProbability(outOfVocabularyProbability);
                }
                return embeddingTableConfig;
            }
            case ONE_HOT_ENCODING: {
                OneHotEncodingConfig oneHotEncodingConfig = new OneHotEncodingConfig(propertyName);
                oneHotEncodingConfig.setShared(isShared);
                oneHotEncodingConfig.setMaxVocabularySize(maxVocabularySize);
                return oneHotEncodingConfig;
            }
        }
        throw new IllegalEnumConstantException((Enum)type);
    }
}

