/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractUdfFunctionConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.UdfFunctionArgumentConfig;
import oracle.pgx.config.UdfLanguage;

public class UdfFunctionConfig
extends AbstractUdfFunctionConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static UdfFunctionConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return UdfFunctionConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static UdfFunctionConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return UdfFunctionConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static UdfFunctionConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new UdfFunctionConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static UdfFunctionConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new UdfFunctionConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static UdfFunctionConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new UdfFunctionConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected UdfFunctionConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public String getNamespace() {
        return (String)this.values.get(Field.NAMESPACE);
    }

    @Override
    public String getFunctionName() {
        return (String)this.values.get(Field.FUNCTION_NAME);
    }

    @Override
    public UdfLanguage getLanguage() {
        return (UdfLanguage)((Object)this.values.get(Field.LANGUAGE));
    }

    @Override
    public String getSourceLocation() {
        return (String)this.values.get(Field.SOURCE_LOCATION);
    }

    @Override
    public String getSourceCode() {
        return (String)this.values.get(Field.SOURCE_CODE);
    }

    @Override
    public String getImplementationReference() {
        return (String)this.values.get(Field.IMPLEMENTATION_REFERENCE);
    }

    @Override
    public String getSourceFunctionName() {
        return (String)this.values.get(Field.SOURCE_FUNCTION_NAME);
    }

    @Override
    public PropertyType getReturnType() {
        return (PropertyType)this.values.get(Field.RETURN_TYPE);
    }

    @Override
    public List<UdfFunctionArgumentConfig> getArguments() {
        return (List)this.values.get(Field.ARGUMENTS);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UdfFunctionConfig other = (UdfFunctionConfig)obj;
        if (!Objects.equals(this.getNamespace(), other.getNamespace())) {
            return false;
        }
        if (!Objects.equals(this.getFunctionName(), other.getFunctionName())) {
            return false;
        }
        if (!Objects.equals((Object)this.getLanguage(), (Object)other.getLanguage())) {
            return false;
        }
        if (!Objects.equals(this.getSourceLocation(), other.getSourceLocation())) {
            return false;
        }
        if (!Objects.equals(this.getSourceCode(), other.getSourceCode())) {
            return false;
        }
        if (!Objects.equals(this.getImplementationReference(), other.getImplementationReference())) {
            return false;
        }
        if (!Objects.equals(this.getSourceFunctionName(), other.getSourceFunctionName())) {
            return false;
        }
        if (!Objects.equals(this.getReturnType(), other.getReturnType())) {
            return false;
        }
        return Objects.equals(this.getArguments(), other.getArguments());
    }

    public static enum Field implements ConfigField
    {
        NAMESPACE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        FUNCTION_NAME(Collections.emptyList(), Collections.emptyList(), String.class, true, null, false, false, false, false),
        LANGUAGE(Collections.emptyList(), Collections.emptyList(), UdfLanguage.class, true, null, false, false, false, false),
        SOURCE_LOCATION(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        SOURCE_CODE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        IMPLEMENTATION_REFERENCE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SOURCE_FUNCTION_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        RETURN_TYPE(Collections.emptyList(), Collections.emptyList(), PropertyType.class, true, null, false, false, false, false),
        ARGUMENTS(Collections.emptyList(), Collections.emptyList(), UdfFunctionArgumentConfig.class, false, Collections.emptyList(), true, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("udf.function.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

