/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.CommonLoadableConfig;
import oracle.pgx.config.GraphPropertyConfig;

public class GraphFormatConfig {
    public static List<DateTimeFormatter> getDefaultFormats(CommonLoadableConfig loadableConfig, PropertyType type) {
        switch (type) {
            case LOCAL_DATE: {
                return loadableConfig.createLocalDateFormat();
            }
            case TIME: {
                return loadableConfig.createTimeFormat();
            }
            case TIMESTAMP: {
                return loadableConfig.createTimestampFormat();
            }
            case TIME_WITH_TIMEZONE: {
                return loadableConfig.createTimeWithTimezoneFormat();
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return loadableConfig.createTimestampWithTimezoneFormat();
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NOT_A_TEMPORAL_TYPE", (Object[])new Object[]{type.toString()}));
    }

    public static List<DateTimeFormatter> getFormats(GraphPropertyConfig graphPropertyConfig) {
        return graphPropertyConfig.getFormat().stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
    }
}

