/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractFileGraphStoringConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.vfs.CompressionScheme;

public class FileGraphStoringConfig
extends AbstractFileGraphStoringConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static FileGraphStoringConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return FileGraphStoringConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static FileGraphStoringConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return FileGraphStoringConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static FileGraphStoringConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new FileGraphStoringConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static FileGraphStoringConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new FileGraphStoringConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static FileGraphStoringConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new FileGraphStoringConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected FileGraphStoringConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getBasePath() {
        return (String)this.values.get(Field.BASE_PATH);
    }

    @Override
    public Integer getNumPartitions() {
        return (Integer)this.values.get(Field.NUM_PARTITIONS);
    }

    @Override
    public Character getDelimiter() {
        return (Character)this.values.get(Field.DELIMITER);
    }

    @Override
    public Integer getInitialPartitionIndex() {
        return (Integer)this.values.get(Field.INITIAL_PARTITION_INDEX);
    }

    @Override
    public String getVertexExtension() {
        return (String)this.values.get(Field.VERTEX_EXTENSION);
    }

    @Override
    public String getEdgeExtension() {
        return (String)this.values.get(Field.EDGE_EXTENSION);
    }

    @Override
    public String getRowExtension() {
        return (String)this.values.get(Field.ROW_EXTENSION);
    }

    @Override
    public CompressionScheme getCompressionScheme() {
        return (CompressionScheme)this.values.get(Field.COMPRESSION_SCHEME);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileGraphStoringConfig other = (FileGraphStoringConfig)obj;
        if (!Objects.equals(this.getBasePath(), other.getBasePath())) {
            return false;
        }
        if (!Objects.equals(this.getNumPartitions(), other.getNumPartitions())) {
            return false;
        }
        if (!Objects.equals(this.getDelimiter(), other.getDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.getInitialPartitionIndex(), other.getInitialPartitionIndex())) {
            return false;
        }
        if (!Objects.equals(this.getVertexExtension(), other.getVertexExtension())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeExtension(), other.getEdgeExtension())) {
            return false;
        }
        if (!Objects.equals(this.getRowExtension(), other.getRowExtension())) {
            return false;
        }
        return Objects.equals(this.getCompressionScheme(), other.getCompressionScheme());
    }

    public static enum Field implements ConfigField
    {
        BASE_PATH(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        NUM_PARTITIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1, false, false, false, false),
        DELIMITER(Arrays.asList("separator"), Collections.emptyList(), Character.class, false, null, false, false, false, false),
        INITIAL_PARTITION_INDEX(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1, false, false, false, false),
        VERTEX_EXTENSION(Arrays.asList("extension"), Collections.emptyList(), String.class, false, "nodes", false, false, false, false),
        EDGE_EXTENSION(Collections.emptyList(), Collections.emptyList(), String.class, false, "edges", false, false, false, false),
        ROW_EXTENSION(Collections.emptyList(), Collections.emptyList(), String.class, false, "rows", false, false, false, false),
        COMPRESSION_SCHEME(Collections.emptyList(), Collections.emptyList(), CompressionScheme.class, false, CompressionScheme.NONE, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("file.graph.storing.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

