/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.Format;

public class FileGraphConfigFactory
extends AbstractGraphConfigFactory<FileGraphConfig> {
    private final boolean strict;

    public FileGraphConfigFactory() {
        this(true);
    }

    public FileGraphConfigFactory(boolean strict) {
        this.strict = strict;
    }

    FileGraphConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected boolean supports(Format format) {
        return format.isFileFormat();
    }

    @Override
    protected FileGraphConfig fromMap(Map<String, Object> raw, String parentPath) throws IOException {
        if (!this.hasValue(FileGraphConfig.Field.VERTEX_ID_TYPE, raw::get)) {
            raw.put(FileGraphConfig.Field.VERTEX_ID_TYPE.toKey(), IdType.INTEGER);
        }
        return FileGraphConfig.parse(raw, this.strict, parentPath, this.parseHiddenValues);
    }

    @Override
    public FileGraphConfig fromProperties(Properties props) {
        if (!this.hasValue(FileGraphConfig.Field.VERTEX_ID_TYPE, props::getProperty)) {
            props.setProperty(FileGraphConfig.Field.VERTEX_ID_TYPE.toKey(), IdType.INTEGER.toKey());
        }
        return FileGraphConfig.parse(props, this.strict);
    }
}

