/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.util.TemporalTypeUtils;
import oracle.pgx.config.GraphErrorHandlingConfig;

public interface CommonLoadableConfig<FormatType> {
    public FormatType getFormat();

    public Map getAttributes();

    public String getKeystoreAlias();

    public GraphErrorHandlingConfig getErrorHandling();

    public String getName();

    public List<String> getLocalDateFormat();

    public List<String> getTimeFormat();

    public List<String> getTimestampFormat();

    public List<String> getTimeWithTimezoneFormat();

    public List<String> getTimestampWithTimezoneFormat();

    public Character getVectorComponentDelimiter();

    default public List<DateTimeFormatter> createLocalDateFormat() {
        return TemporalTypeUtils.createDateTimeFormatterList(this.getLocalDateFormat());
    }

    default public List<DateTimeFormatter> createTimeFormat() {
        return TemporalTypeUtils.createDateTimeFormatterList(this.getTimeFormat());
    }

    default public List<DateTimeFormatter> createTimestampFormat() {
        return TemporalTypeUtils.createDateTimeFormatterList(this.getTimestampFormat());
    }

    default public List<DateTimeFormatter> createTimeWithTimezoneFormat() {
        return TemporalTypeUtils.createDateTimeFormatterList(this.getTimeWithTimezoneFormat());
    }

    default public List<DateTimeFormatter> createTimestampWithTimezoneFormat() {
        return TemporalTypeUtils.createDateTimeFormatterList(this.getTimestampWithTimezoneFormat());
    }
}

