/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.List;
import java.util.Objects;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.Constants;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.RdfGraphConfig;
import oracle.pgx.config.RdfGraphConfigBuilder;
import oracle.pgx.config.RdfGraphPrefixConfig;

public abstract class AbstractRdfGraphConfig
extends GraphConfig {
    @Override
    public RdfGraphConfigBuilder toGraphConfigBuilder() {
        return new RdfGraphConfigBuilder().copyFrom((RdfGraphConfig)this);
    }

    private String getPassword() {
        Object pwd = ((RdfGraphConfig)this).getValues().get(RdfGraphConfig.Field.PASSWORD);
        return (String)pwd;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getDataSourceId() == null && this.getJdbcUrl() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EITHER_ONE_OR_OTHER_NEEDS_TO_BE_SET", (Object[])new Object[]{RdfGraphConfig.Field.DATA_SOURCE_ID, RdfGraphConfig.Field.JDBC_URL}));
        }
        this.validateJdbcUrl();
        if (!Constants.ID_SANITIZATION_REGEX_PATTERN.matcher(this.getName()).matches()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_RDF_MODEL_NAME", (Object[])new Object[]{this.getName()}));
        }
        if (!this.isVertexLabelsLoadingEnabled() && this.getVertexLabelPredicates().size() > 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SET_VERTEX_LABEL_PREDICATES_WITHOUT_HAVING_VERTEX_LABELS", (Object[])new Object[0]));
        }
        if (this.getVertexIdType() != IdType.LONG && this.getVertexIdType() != IdType.STRING) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{this.getVertexIdType()}));
        }
        if (this.getEdgeProps().size() > 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SHOULD_HAVE_ZERO_EDGE_PROPERTIES", (Object[])new Object[0]));
        }
        if (this.getAcceptedPredicates().size() > 0 && this.getIgnoredPredicates().size() > 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SPECIFY_BOTH_IGNORE_AND_ACCEPTED_PREDICATE", (Object[])new Object[0]));
        }
    }

    private void validateJdbcUrl() {
        if (this.getJdbcUrl() == null) {
            return;
        }
        if (this.getDataSourceId() != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATA_SOURCE_ID_CANNOT_BE_COMBINED_WITH_JDBC", (Object[])new Object[0]));
        }
        if (this.getPassword() == null && this.getKeystoreAlias() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEYSTORE_OR_PWD_REQUIRED", (Object[])new Object[0]));
        }
        if (!this.getJdbcUrl().toLowerCase().startsWith("jdbc:oracle:thin:@")) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_JDBC_URI", (Object[])new Object[]{this.getJdbcUrl()}));
        }
    }

    public abstract String getJdbcUrl();

    public abstract String getUsername();

    public abstract List<String> getVertexLabelPredicates();

    public abstract List<String> getIgnoredPredicates();

    public abstract List<String> getAcceptedPredicates();

    public abstract List<RdfGraphPrefixConfig> getPrefixes();

    public abstract String getDataSourceId();

    public boolean isBlackListMode() {
        return this.getAcceptedPredicates().size() == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRdfGraphConfig that = (AbstractRdfGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), that.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getName(), that.getName())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), that.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), that.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.getPrefixes(), that.getPrefixes())) {
            return false;
        }
        if (!Objects.equals(this.getVertexLabelPredicates(), that.getVertexLabelPredicates())) {
            return false;
        }
        if (!Objects.equals(this.getIgnoredPredicates(), that.getIgnoredPredicates())) {
            return false;
        }
        return Objects.equals(this.getAcceptedPredicates(), that.getAcceptedPredicates());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.getJdbcUrl() != null) {
            code += this.getJdbcUrl().hashCode();
        }
        if (this.getName() != null) {
            code += this.getName().hashCode();
        }
        if (this.getUsername() != null) {
            code += this.getUsername().hashCode();
        }
        if (this.getKeystoreAlias() != null) {
            code += this.getKeystoreAlias().hashCode();
        }
        if (this.getPrefixes() != null) {
            for (RdfGraphPrefixConfig prefix : this.getPrefixes()) {
                code += prefix.getPrefix().hashCode();
                code += prefix.getValue().hashCode();
            }
        }
        if (this.getVertexLabelPredicates() != null) {
            for (String predicate : this.getVertexLabelPredicates()) {
                code += predicate.hashCode();
            }
        }
        if (this.getIgnoredPredicates() != null) {
            for (String predicate : this.getIgnoredPredicates()) {
                code += predicate.hashCode();
            }
        }
        if (this.getAcceptedPredicates() != null) {
            for (String predicate : this.getAcceptedPredicates()) {
                code += predicate.hashCode();
            }
        }
        return code;
    }
}

