/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.StringPoolingStrategy;

public abstract class AbstractGraphPropertyConfig
extends AbstractConfig
implements Serializable {
    private Object parsedDefault;
    private boolean inMemory;
    private boolean external;

    public abstract Object getName();

    public abstract List<String> getFormat();

    abstract Object getDefault();

    public abstract PropertyType getType();

    abstract Integer getDimension();

    public abstract Object getColumn();

    public Object getSourceColumn() {
        Object propColumn = this.getColumn();
        if (propColumn == null) {
            return this.getName();
        }
        return propColumn;
    }

    public abstract List<Map> getStores();

    public Object getParsedDefaultValue() {
        return this.parsedDefault;
    }

    @Override
    protected void initialize() {
        this.validate();
        this.setMemoryFlags();
    }

    @Override
    protected void validate() {
        this.parsedDefault = this.getDefault() == null ? AbstractGraphPropertyConfig.getDefaultDefault(this.getType()) : AbstractGraphPropertyConfig.parseDefault(this.getType(), this.getDefault());
    }

    private static Object parseDefault(PropertyType type, Object defaultVal) {
        assert (defaultVal != null);
        defaultVal = ConfigParser.replaceWildcards(type.getTypeClass(), defaultVal);
        try {
            switch (type) {
                case BOOLEAN: {
                    if (defaultVal.getClass() == Boolean.class) {
                        return defaultVal;
                    }
                    return PropertyType.parseBoolean((String)defaultVal.toString());
                }
                case STRING: {
                    if (defaultVal.getClass() == String.class) {
                        return defaultVal;
                    }
                    return defaultVal.toString();
                }
                case RO_STRING_SET: {
                    return Collections.EMPTY_SET;
                }
                case LOCAL_DATE: {
                    return TemporalTypeUtils.getAsLocalDate((Object)defaultVal);
                }
                case TIME: {
                    return TemporalTypeUtils.getAsLocalTime((Object)defaultVal);
                }
                case TIMESTAMP: {
                    return TemporalTypeUtils.getAsLocalDateTime((Object)defaultVal);
                }
                case TIME_WITH_TIMEZONE: {
                    return TemporalTypeUtils.getAsOffsetTime((Object)defaultVal);
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    return TemporalTypeUtils.getAsOffsetDateTime((Object)defaultVal);
                }
                case POINT2D: {
                    double lat;
                    double lng;
                    if (defaultVal.getClass() == Point2D.class) {
                        return defaultVal;
                    }
                    String location = defaultVal.toString();
                    String[] point = location.split(" ");
                    if (point.length != 2) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"WRONG_POINT_FORMAT", (Object[])new Object[]{location}));
                    }
                    try {
                        lng = Double.parseDouble(point[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"WRONG_POINT_VALUE_TYPE", (Object[])new Object[]{"\"" + point[0] + "\""}), e);
                    }
                    try {
                        lat = Double.parseDouble(point[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"WRONG_POINT_VALUE_TYPE", (Object[])new Object[]{"\"" + point[1] + "\""}), e);
                    }
                    return new Point2D(lng, lat);
                }
                case DOUBLE: {
                    if (defaultVal.getClass() == Double.class) {
                        return defaultVal;
                    }
                    return Double.parseDouble(defaultVal.toString());
                }
                case FLOAT: {
                    if (defaultVal.getClass() == Float.class) {
                        return defaultVal;
                    }
                    return Float.valueOf(Float.parseFloat(defaultVal.toString()));
                }
                case VERTEX: {
                    return defaultVal;
                }
                case INTEGER: {
                    if (defaultVal.getClass() == Integer.class) {
                        return defaultVal;
                    }
                    return Integer.parseInt(defaultVal.toString());
                }
                case EDGE: 
                case LONG: {
                    if (defaultVal.getClass() == Long.class) {
                        return defaultVal;
                    }
                    return Long.parseLong(defaultVal.toString());
                }
            }
            throw new UnsupportedOperationException("unknown type " + type);
        }
        catch (NumberFormatException | GmParseException e) {
            throw new IllegalArgumentException("invalid default value " + defaultVal + ". Doesn't match type " + type);
        }
    }

    private static Object getDefaultDefault(PropertyType type) {
        switch (type) {
            case BOOLEAN: 
            case STRING: 
            case RO_STRING_SET: 
            case LOCAL_DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: 
            case POINT2D: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: {
                return type.getDefaultValue();
            }
            case VERTEX: {
                return 0;
            }
            case EDGE: {
                return 0L;
            }
        }
        throw new UnsupportedOperationException("unknown type " + type);
    }

    private void setMemoryFlags() {
        if (this.getStores().size() == 0) {
            this.inMemory = true;
            this.external = false;
            return;
        }
        Set externalStores = this.getStores().stream().map(m -> m.get("name")).map(String.class::cast).collect(Collectors.toSet());
        this.inMemory = externalStores.contains("memory");
        this.external = externalStores.contains("memory") && externalStores.size() > 1 || !externalStores.contains("memory") && externalStores.size() > 0;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public boolean isExternal() {
        return this.external;
    }

    abstract StringPoolingStrategy getStringPoolingStrategy();

    public boolean isStringPoolEnabled() {
        return this.getStringPoolingStrategy() != StringPoolingStrategy.NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractGraphPropertyConfig that = (AbstractGraphPropertyConfig)o;
        if (!Objects.equals(this.getName(), that.getName())) {
            return false;
        }
        if (!Objects.equals(this.getFormat(), that.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getType(), that.getType())) {
            return false;
        }
        if (!Objects.equals(this.getDimension(), that.getDimension())) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), that.getColumn())) {
            return false;
        }
        return Objects.equals(this.getDefault(), that.getDefault());
    }

    public int hashCode() {
        int code = this.getName().hashCode();
        code += this.getFormat().hashCode();
        code += this.getType().hashCode();
        code += this.getDimension().hashCode();
        code += this.getColumn() == null ? 0 : this.getColumn().hashCode();
        return code += this.getDefault() == null ? 0 : this.getDefault().hashCode();
    }
}

