/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractFileGraphConfig;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.Format;

public abstract class AbstractFileGraphConfigBuilder<T extends AbstractFileGraphConfigBuilder<T, GC>, GC extends AbstractFileGraphConfig>
extends AbstractGraphConfigBuilder<T, GC> {
    private final List<String> vertexUris = new ArrayList<String>();
    private final List<String> edgeUris = new ArrayList<String>();

    public AbstractFileGraphConfigBuilder() {
        this.values.put(FileGraphConfig.Field.VERTEX_URIS.toKey(), this.vertexUris);
        this.values.put(FileGraphConfig.Field.EDGE_URIS.toKey(), this.edgeUris);
        this.setVertexIdType(IdType.INTEGER);
    }

    @Override
    public T copyFrom(GC graphConfig) {
        super.copyFrom(graphConfig);
        this.setSeparator(((AbstractFileGraphConfig)graphConfig).getSeparator());
        this.hasHeader(((AbstractFileGraphConfig)graphConfig).isHeader());
        this.detectGzip(((AbstractFileGraphConfig)graphConfig).isDetectGzip());
        this.setVertexUris(((AbstractFileGraphConfig)graphConfig).getVertexUris());
        this.setEdgeUris(((AbstractFileGraphConfig)graphConfig).getEdgeUris());
        this.setStoringConfig(((AbstractFileGraphConfig)graphConfig).getStoring());
        this.setVertexIdColumn(((AbstractFileGraphConfig)graphConfig).getVertexIdColumn());
        this.setVertexLabelsColumn(((AbstractFileGraphConfig)graphConfig).getVertexLabelsColumn());
        this.setEdgeIdColumn(((AbstractFileGraphConfig)graphConfig).getEdgeIdColumn());
        this.setEdgeSourceColumn(((AbstractFileGraphConfig)graphConfig).getEdgeSourceColumn());
        this.setEdgeDestinationColumn(((AbstractFileGraphConfig)graphConfig).getEdgeDestinationColumn());
        this.setEdgeLabelColumn(((AbstractFileGraphConfig)graphConfig).getEdgeLabelColumn());
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setFormat(Format format) {
        this.values.put(FileGraphConfig.Field.FORMAT.toKey(), format.toString());
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setSeparator(String separator) {
        this.values.put(FileGraphConfig.Field.SEPARATOR.toKey(), separator);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setVectorComponentDelimiter(Character delimiter) {
        this.values.put(FileGraphConfig.Field.VECTOR_COMPONENT_DELIMITER.toKey(), delimiter);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T hasHeader(boolean hasHeader) {
        this.values.put(FileGraphConfig.Field.HEADER.toKey(), hasHeader);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T detectGzip(boolean detectGzip) {
        this.values.put(FileGraphConfig.Field.DETECT_GZIP.toKey(), detectGzip);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setUri(String uri) {
        this.setUris(uri);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T addUri(String uri) {
        return this.addVertexUri(uri);
    }

    public T addVertexUri(String uri) {
        this.vertexUris.add(uri);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T addEdgeUri(String uri) {
        this.edgeUris.add(uri);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setUris(Iterable<String> uris) {
        return this.setVertexUris(uris);
    }

    public T setUris(String ... uris) {
        return this.setVertexUris(uris);
    }

    public T setVertexUris(Iterable<String> uris) {
        this.vertexUris.clear();
        uris.forEach(this.vertexUris::add);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setVertexUris(String ... uris) {
        this.vertexUris.clear();
        Arrays.stream(uris).forEach(this.vertexUris::add);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeUris(Iterable<String> uris) {
        this.edgeUris.clear();
        uris.forEach(this.edgeUris::add);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeUris(String ... uris) {
        this.edgeUris.clear();
        Arrays.stream(uris).forEach(this.edgeUris::add);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setStoringOptions(FileGraphStoringConfig storingConfig) {
        this.values.put(FileGraphConfig.Field.STORING.toKey(), storingConfig);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    @Deprecated
    public T setStoringConfig(FileGraphStoringConfig storingConfig) {
        return this.setStoringOptions(storingConfig);
    }

    public T setVertexIdColumn(Object column) {
        this.values.put(FileGraphConfig.Field.VERTEX_ID_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setVertexLabelsColumn(Object column) {
        this.values.put(FileGraphConfig.Field.VERTEX_LABELS_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeIdColumn(Object column) {
        this.values.put(FileGraphConfig.Field.EDGE_ID_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeSourceColumn(Object column) {
        this.values.put(FileGraphConfig.Field.EDGE_SOURCE_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeDestinationColumn(Object column) {
        this.values.put(FileGraphConfig.Field.EDGE_DESTINATION_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }

    public T setEdgeLabelColumn(Object column) {
        this.values.put(FileGraphConfig.Field.EDGE_LABEL_COLUMN.toKey(), column);
        return (T)((AbstractFileGraphConfigBuilder)this.getThis());
    }
}

