/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.DataMemoryLimit;
import oracle.pgx.config.DataMemoryLimitType;
import oracle.pgx.config.DataMemoryLimitsConfig;

public abstract class AbstractDataMemoryLimitsConfig
extends AbstractConfig {
    @Override
    public void validate() {
        super.validate();
        this.validateDataMemoryLimits();
    }

    public abstract String getMaxTotalDataMemorySize();

    public abstract Double getMaxTotalDataMemoryRatio();

    public abstract String getMaxTotalPrivateDataMemorySize();

    public abstract Double getMaxTotalPrivateDataMemoryRatio();

    public abstract String getMaxTotalSharedDataMemorySize();

    public abstract Double getMaxTotalSharedDataMemoryRatio();

    public abstract String getMaxPerUserDataMemorySize();

    public abstract Double getMaxPerUserDataMemoryRatio();

    public abstract String getMaxPerSessionDataMemorySize();

    public abstract Double getMaxPerSessionDataMemoryRatio();

    public abstract boolean hasDefaultValue(DataMemoryLimitsConfig.Field var1);

    public boolean isMaxTotalDataMemoryRatioSet() {
        return !this.hasDefaultValue(DataMemoryLimitsConfig.Field.MAX_TOTAL_DATA_MEMORY_RATIO);
    }

    public boolean isMaxTotalPrivateDataMemoryRatioSet() {
        return !this.hasDefaultValue(DataMemoryLimitsConfig.Field.MAX_TOTAL_PRIVATE_DATA_MEMORY_RATIO);
    }

    public boolean isMaxTotalSharedDataMemoryRatioSet() {
        return !this.hasDefaultValue(DataMemoryLimitsConfig.Field.MAX_TOTAL_SHARED_DATA_MEMORY_RATIO);
    }

    public boolean isMaxPerUserDataMemoryRatioSet() {
        return !this.hasDefaultValue(DataMemoryLimitsConfig.Field.MAX_PER_SESSION_DATA_MEMORY_RATIO);
    }

    public boolean isMaxPerSessionDataMemoryRatioSet() {
        return !this.hasDefaultValue(DataMemoryLimitsConfig.Field.MAX_PER_SESSION_DATA_MEMORY_RATIO);
    }

    public DataMemoryLimit getMaxDataMemoryLimit(DataMemoryLimitType limit) {
        switch (limit) {
            case MAX_TOTAL_DATA_MEMORY: {
                return new DataMemoryLimit(limit, this.getMaxTotalDataMemorySize(), this.getMaxTotalDataMemoryRatio(), this.isMaxTotalDataMemoryRatioSet());
            }
            case MAX_TOTAL_PRIVATE_DATA_MEMORY: {
                return new DataMemoryLimit(limit, this.getMaxTotalPrivateDataMemorySize(), this.getMaxTotalPrivateDataMemoryRatio(), this.isMaxTotalPrivateDataMemoryRatioSet());
            }
            case MAX_TOTAL_SHARED_DATA_MEMORY: {
                return new DataMemoryLimit(limit, this.getMaxTotalSharedDataMemorySize(), this.getMaxTotalSharedDataMemoryRatio(), this.isMaxTotalSharedDataMemoryRatioSet());
            }
            case MAX_PER_USER_DATA_MEMORY: {
                return new DataMemoryLimit(limit, this.getMaxPerUserDataMemorySize(), this.getMaxPerUserDataMemoryRatio(), this.isMaxPerUserDataMemoryRatioSet());
            }
            case MAX_PER_SESSION_DATA_MEMORY: {
                return new DataMemoryLimit(limit, this.getMaxPerSessionDataMemorySize(), this.getMaxPerSessionDataMemoryRatio(), this.isMaxPerSessionDataMemoryRatioSet());
            }
        }
        throw new IllegalArgumentException("cannot parse limit field type " + limit.toString());
    }

    public void validateMaxDataMemoryLimit(DataMemoryLimitType limit) {
        switch (limit) {
            case MAX_TOTAL_DATA_MEMORY: {
                DataMemoryLimit.validateInput(limit, this.getMaxTotalDataMemorySize(), this.getMaxTotalDataMemoryRatio(), this.isMaxTotalDataMemoryRatioSet());
                break;
            }
            case MAX_TOTAL_PRIVATE_DATA_MEMORY: {
                DataMemoryLimit.validateInput(limit, this.getMaxTotalPrivateDataMemorySize(), this.getMaxTotalPrivateDataMemoryRatio(), this.isMaxTotalPrivateDataMemoryRatioSet());
                break;
            }
            case MAX_TOTAL_SHARED_DATA_MEMORY: {
                DataMemoryLimit.validateInput(limit, this.getMaxTotalSharedDataMemorySize(), this.getMaxTotalSharedDataMemoryRatio(), this.isMaxTotalSharedDataMemoryRatioSet());
                break;
            }
            case MAX_PER_USER_DATA_MEMORY: {
                DataMemoryLimit.validateInput(limit, this.getMaxPerUserDataMemorySize(), this.getMaxPerUserDataMemoryRatio(), this.isMaxPerUserDataMemoryRatioSet());
                break;
            }
            case MAX_PER_SESSION_DATA_MEMORY: {
                DataMemoryLimit.validateInput(limit, this.getMaxPerSessionDataMemorySize(), this.getMaxPerSessionDataMemoryRatio(), this.isMaxPerSessionDataMemoryRatioSet());
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot parse limit field type " + limit.toString());
            }
        }
    }

    private void validateDataMemoryLimits() {
        for (DataMemoryLimitType limitType : DataMemoryLimitType.getGlobalLimitTypes()) {
            this.validateMaxDataMemoryLimit(limitType);
        }
    }
}

