/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import oracle.pgx.common.types.PropertyType;

public class DeepWalkModelConfig {
    private int minWordFrequency = 1;
    private int batchSize = 128;
    private int numEpochs = 2;
    private int layerSize = 200;
    private double learningRate = 0.025;
    private double minLearningRate = 1.0E-4;
    private int windowSize = 5;
    private int walkLength = 5;
    private int walksPerVertex = 4;
    private double sampleRate = 0.0;
    private int negativeSample = 10;
    private Double trainingLoss = null;
    private double validationFraction = 0.05;
    private PropertyType vertexIdPropertyType = PropertyType.STRING;
    private Long seed = null;
    private boolean shuffle = false;
    private boolean ignoreIsolated = true;

    public DeepWalkModelConfig() {
    }

    @JsonCreator
    public DeepWalkModelConfig(@JsonProperty(required=true, value="minWordFrequency") int minWordFrequency, @JsonProperty(required=true, value="batchSize") int batchSize, @JsonProperty(required=true, value="numEpochs") int numEpochs, @JsonProperty(required=true, value="layerSize") int layerSize, @JsonProperty(required=true, value="learningRate") double learningRate, @JsonProperty(required=true, value="minLearningRate") double minLearningRate, @JsonProperty(required=true, value="windowSize") int windowSize, @JsonProperty(required=true, value="walkLength") int walkLength, @JsonProperty(required=true, value="walksPerVertex") int walksPerVertex, @JsonProperty(required=true, value="sampleRate") double sampleRate, @JsonProperty(required=true, value="negativeSample") int negativeSample, @JsonProperty(value="loss") Double trainingLoss, @JsonProperty(required=true, value="validationFraction") double validationFraction, @JsonProperty(required=true, value="vertexIdPropertyType") PropertyType vertexIdPropertyType, @JsonProperty(required=true, value="seed") Long seed, @JsonProperty(required=true, value="shuffle") boolean shuffle) {
        this.minWordFrequency = minWordFrequency;
        this.batchSize = batchSize;
        this.numEpochs = numEpochs;
        this.layerSize = layerSize;
        this.learningRate = learningRate;
        this.minLearningRate = minLearningRate;
        this.windowSize = windowSize;
        this.walkLength = walkLength;
        this.walksPerVertex = walksPerVertex;
        this.sampleRate = sampleRate;
        this.negativeSample = negativeSample;
        this.trainingLoss = trainingLoss;
        this.validationFraction = validationFraction;
        this.vertexIdPropertyType = vertexIdPropertyType;
        this.seed = seed;
        this.shuffle = shuffle;
    }

    public Double getLoss() {
        return this.trainingLoss;
    }

    public void setLoss(Double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getWalkLength() {
        return this.walkLength;
    }

    public void setWalkLength(int walkLength) {
        this.walkLength = walkLength;
    }

    public int getWalksPerVertex() {
        return this.walksPerVertex;
    }

    public void setWalksPerVertex(int walksPerVertex) {
        this.walksPerVertex = walksPerVertex;
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public int getLayerSize() {
        return this.layerSize;
    }

    public void setLayerSize(int layerSize) {
        this.layerSize = layerSize;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getNegativeSample() {
        return this.negativeSample;
    }

    public void setNegativeSample(int negativeSample) {
        this.negativeSample = negativeSample;
    }

    public double getValidationFraction() {
        return this.validationFraction;
    }

    public void setValidationFraction(double validationFraction) {
        this.validationFraction = validationFraction;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public PropertyType getVertexIdPropertyType() {
        return this.vertexIdPropertyType;
    }

    public void setVertexIdPropertyType(PropertyType vertexIdPropertyType) {
        this.vertexIdPropertyType = vertexIdPropertyType;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public boolean isIgnoreIsolated() {
        return this.ignoreIsolated;
    }

    public void setIgnoreIsolated(boolean ignoreIsolated) {
        this.ignoreIsolated = ignoreIsolated;
    }
}

