/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;

public class GenericConfigBuilder<C extends AbstractConfig, F extends Enum<F>> {
    private final Map<String, Object> values;
    private final ConfigParser<C> parser;

    public GenericConfigBuilder(ConfigParser<C> parser, Class<F> enumValues) {
        this(parser);
    }

    public GenericConfigBuilder(ConfigParser<C> parser) {
        this.parser = parser;
        this.values = new HashMap<String, Object>();
    }

    public GenericConfigBuilder(ConfigParser<C> parser, Map<String, Object> initialValues) {
        this.parser = parser;
        this.values = initialValues;
    }

    public GenericConfigBuilder<C, F> put(F field, Object value) {
        this.values.put(((ConfigField)field).toKey(), value);
        return this;
    }

    public GenericConfigBuilder<C, F> putAll(Map<? extends F, Object> values) {
        values.forEach(this::put);
        return this;
    }

    public GenericConfigBuilder<C, F> clear() {
        this.values.clear();
        return this;
    }

    public C build(boolean strict, String parent) {
        return this.parser.parse(this.values, strict, parent);
    }

    public C build() {
        return this.build(true, null);
    }

    public Map<String, Object> getRawValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @FunctionalInterface
    public static interface ConfigParser<C extends AbstractConfig> {
        public C parse(Map<String, Object> var1, boolean var2, String var3);
    }
}

