/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AuthorizationEntityConfig;

public final class AuthorizationEntityConfigBuilder {
    private final Map<AuthorizationEntityConfig.Field, Object> values = new HashMap<AuthorizationEntityConfig.Field, Object>();

    public static AuthorizationEntityConfig buildAuthorizationEntityConfig(Consumer<AuthorizationEntityConfigBuilder> builderSetup) {
        AuthorizationEntityConfigBuilder builder = new AuthorizationEntityConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public AuthorizationEntityConfigBuilder() {
    }

    public AuthorizationEntityConfigBuilder(Map<AuthorizationEntityConfig.Field, Object> values) {
        this.putAll(values);
    }

    public AuthorizationEntityConfigBuilder(AuthorizationEntityConfig config) {
        this.putAll(config);
    }

    public AuthorizationEntityConfigBuilder(AuthorizationEntityConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public AuthorizationEntityConfigBuilder putAll(Map<AuthorizationEntityConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public AuthorizationEntityConfigBuilder putAll(AuthorizationEntityConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public AuthorizationEntityConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public AuthorizationEntityConfig build(String parentPath) {
        try {
            return AuthorizationEntityConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public AuthorizationEntityConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<AuthorizationEntityConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "AuthorizationEntityConfigBuilder" + this.values;
    }

    public AuthorizationEntityConfigBuilder setPgxUser(String pgxUser) {
        this.values.put(AuthorizationEntityConfig.Field.PGX_USER, pgxUser);
        return this;
    }

    public AuthorizationEntityConfigBuilder setPgxRole(String pgxRole) {
        this.values.put(AuthorizationEntityConfig.Field.PGX_ROLE, pgxRole);
        return this;
    }

    public AuthorizationEntityConfigBuilder setPgxPermissions(Object ... pgxPermissions) {
        this.values.put(AuthorizationEntityConfig.Field.PGX_PERMISSIONS, pgxPermissions);
        return this;
    }

    public AuthorizationEntityConfigBuilder setMaxDataMemorySize(String maxDataMemorySize) {
        this.values.put(AuthorizationEntityConfig.Field.MAX_DATA_MEMORY_SIZE, maxDataMemorySize);
        return this;
    }

    public AuthorizationEntityConfigBuilder setMaxDataMemoryRatio(double maxDataMemoryRatio) {
        this.values.put(AuthorizationEntityConfig.Field.MAX_DATA_MEMORY_RATIO, maxDataMemoryRatio);
        return this;
    }

    public AuthorizationEntityConfigBuilder setPgxPermissions(List<?> pgxPermissions) {
        this.values.put(AuthorizationEntityConfig.Field.PGX_PERMISSIONS, pgxPermissions);
        return this;
    }
}

