/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.OnAddExistingElement;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.OnRequiredConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidChangeHandler.class);
    public static final String MESSAGE_DELIMITER = " - ";
    private final AtomicBoolean loggedAddExistingEdge = new AtomicBoolean(false);
    private final AtomicBoolean loggedAddExistingVertex = new AtomicBoolean(false);
    private final AtomicBoolean loggedVertexIdConversion = new AtomicBoolean(false);
    private final AtomicBoolean loggedVertexCollision = new AtomicBoolean(false);
    private final AtomicBoolean loggedEdgeCollision = new AtomicBoolean(false);
    private final AtomicBoolean loggedVertexIdMismatch = new AtomicBoolean(false);
    private final Set<String> loggedVertexPropTypeMismatch;
    private final Set<String> loggedEdgePropTypeMismatch;
    private final Set<String> loggedPropTypeMismatch;
    private final AtomicBoolean loggedNonExistentVertexProvider;
    private final AtomicBoolean loggedNonExistentEdgeProvider;
    private final AtomicBoolean loggedNonExistentVertex;
    private final AtomicBoolean loggedNonExistentEdge;
    private final AtomicBoolean loggedPropertyDoesNotExist;
    private final AtomicBoolean loggedVertexAlreadyExists;
    private final AtomicBoolean loggedEdgeAlreadyExists;
    private final AtomicBoolean loggedAddEdgeSrcOrDstDoesNotExist;
    private OnAddExistingElement addExistingVertexPolicy;
    private OnAddExistingElement addExistingEdgePolicy;
    private OnRequiredConversion requiredConversionPolicy;
    private OnInvalidChange invalidChangePolicy;

    private static String concatSubmessagesIgnoreEmpty(String ... messages) {
        StringJoiner stringJoiner = new StringJoiner(MESSAGE_DELIMITER);
        for (String message : messages) {
            if (message == null || message.isEmpty()) continue;
            stringJoiner.add(message);
        }
        return stringJoiner.toString();
    }

    private static String getVertexCollisionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_COLLISION_ADD", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_COLLISION_MODIFY", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_COLLISION_REMOVE", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getEdgeCollisionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_COLLISION_ADD", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_COLLISION_MODIFY", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_COLLISION_REMOVE", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getConflictingVertexActionMessage(ChangeType action, VertexLocation vertexLocation) {
        switch (vertexLocation) {
            case UNSPECIFIED: 
            case STANDALONE: {
                return InvalidChangeHandler.getConflictingVertexActionMessage(action);
            }
            case EDGE_SOURCE: {
                return InvalidChangeHandler.getConflictingSourceVertexActionMessage(action);
            }
            case EDGE_DESTINATION: {
                return InvalidChangeHandler.getConflictingDestinationVertexActionMessage(action);
            }
        }
        throw new IllegalEnumConstantException((Enum)vertexLocation);
    }

    private static String getConflictingVertexActionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_ADD_VERTEX", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_MODIFY_VERTEX", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_REMOVE_VERTEX", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getConflictingDestinationVertexActionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_ADD_VERTEX_DESTINATION", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_MODIFY_VERTEX_DESTINATION", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_REMOVE_VERTEX_DESTINATION", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getConflictingSourceVertexActionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_ADD_VERTEX_SOURCE", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_MODIFY_VERTEX_SOURCE", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_REMOVE_VERTEX_SOURCE", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getVertexLocationMessage(VertexLocation vertexLocation) {
        switch (vertexLocation) {
            case UNSPECIFIED: 
            case STANDALONE: {
                return null;
            }
            case EDGE_SOURCE: {
                return ErrorMessages.getMessage((String)"VERTEX_LOCATION_EDGE_SOURCE", (Object[])new Object[0]);
            }
            case EDGE_DESTINATION: {
                return ErrorMessages.getMessage((String)"VERTEX_LOCATION_EDGE_DESTINATION", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)vertexLocation);
    }

    private static String getConflictingEdgeActionMessage(ChangeType action) {
        switch (action) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_ADD_EDGE", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_MODIFY_EDGE", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_CONFLICTING_ACTION_REMOVE_EDGE", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)action);
    }

    private static String getIgnoredChangeMessage(ChangeType actionOrNull) {
        if (actionOrNull == null) {
            return ErrorMessages.getMessage((String)"CHANGES_IGNORE_ACTION", (Object[])new Object[0]);
        }
        switch (actionOrNull) {
            case ADD: {
                return ErrorMessages.getMessage((String)"CHANGES_IGNORE_ACTION_ADD", (Object[])new Object[0]);
            }
            case MODIFY: {
                return ErrorMessages.getMessage((String)"CHANGES_IGNORE_ACTION_MODIFY", (Object[])new Object[0]);
            }
            case REMOVE: {
                return ErrorMessages.getMessage((String)"CHANGES_IGNORE_ACTION_REMOVE", (Object[])new Object[0]);
            }
        }
        return ErrorMessages.getMessage((String)"CHANGES_IGNORE_ACTION", (Object[])new Object[0]);
    }

    private static String getPropTypeMismatchMessage(PropertyType expectedPropType, PropertyType actualPropTypeOrNull, EntityType entityTypeOrNull) {
        if (entityTypeOrNull == null) {
            return actualPropTypeOrNull == null ? ErrorMessages.getMessage((String)"PROPERTY_UNKNOWN_TYPE", (Object[])new Object[]{expectedPropType}) : ErrorMessages.getMessage((String)"PROPERTY_UNEXPECTED_TYPE_NO_PII", (Object[])new Object[]{expectedPropType, actualPropTypeOrNull});
        }
        switch (entityTypeOrNull) {
            case VERTEX: {
                return InvalidChangeHandler.getVertexPropTypeMismatchMessage(expectedPropType, actualPropTypeOrNull);
            }
            case EDGE: {
                return InvalidChangeHandler.getEdgePropTypeMismatchMessage(expectedPropType, actualPropTypeOrNull);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityTypeOrNull);
    }

    private static String getVertexPropTypeMismatchMessage(PropertyType expectedPropType, PropertyType actualPropTypeOrNull) {
        if (actualPropTypeOrNull == null) {
            return ErrorMessages.getMessage((String)"PROPERTY_UNKNOWN_TYPE_VERTEX", (Object[])new Object[]{expectedPropType});
        }
        return ErrorMessages.getMessage((String)"PROPERTY_UNEXPECTED_TYPE_VERTEX", (Object[])new Object[]{expectedPropType, actualPropTypeOrNull});
    }

    private static String getEdgePropTypeMismatchMessage(PropertyType expectedPropType, PropertyType actualPropTypeOrNull) {
        if (actualPropTypeOrNull == null) {
            return ErrorMessages.getMessage((String)"PROPERTY_UNKNOWN_TYPE_EDGE", (Object[])new Object[]{expectedPropType});
        }
        return ErrorMessages.getMessage((String)"PROPERTY_UNEXPECTED_TYPE_EDGE", (Object[])new Object[]{expectedPropType, actualPropTypeOrNull});
    }

    private static String getEntityDoesNotExistMessage(EntityType entityType) {
        switch (entityType) {
            case VERTEX: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_DOES_NOT_EXIST_IN_GRAPH", (Object[])new Object[0]);
            }
            case EDGE: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_DOES_NOT_EXIST_IN_GRAPH", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    private static String getEntityProviderDoesNotExistMessage(EntityType entityType) {
        switch (entityType) {
            case VERTEX: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_PROVIDER_DOES_NOT_EXIST_IN_GRAPH", (Object[])new Object[0]);
            }
            case EDGE: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_PROVIDER_DOES_NOT_EXIST_IN_GRAPH", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    private static String getEntityProviderWasNullMessage(EntityType entityType) {
        switch (entityType) {
            case VERTEX: {
                return ErrorMessages.getMessage((String)"CHANGES_VERTEX_PROVIDER_WAS_NULL", (Object[])new Object[0]);
            }
            case EDGE: {
                return ErrorMessages.getMessage((String)"CHANGES_EDGE_PROVIDER_WAS_NULL", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    private static String getSrcOrDstDoesNotExistMessage(VertexLocation vertexLocation) {
        switch (vertexLocation) {
            case EDGE_SOURCE: {
                return ErrorMessages.getMessage((String)"CHANGES_SOURCE_VERTEX_NOT_FOUND", (Object[])new Object[0]);
            }
            case EDGE_DESTINATION: {
                return ErrorMessages.getMessage((String)"CHANGES_DESTINATION_VERTEX_NOT_FOUND", (Object[])new Object[0]);
            }
            case UNSPECIFIED: 
            case STANDALONE: {
                return ErrorMessages.getMessage((String)"CHANGES_SOURCE_AND_DESTINATION_VERTEX_NOT_FOUND", (Object[])new Object[0]);
            }
        }
        throw new IllegalEnumConstantException((Enum)vertexLocation);
    }

    public InvalidChangeHandler() {
        new ConcurrentHashMap();
        this.loggedVertexPropTypeMismatch = ConcurrentHashMap.newKeySet();
        new ConcurrentHashMap();
        this.loggedEdgePropTypeMismatch = ConcurrentHashMap.newKeySet();
        new ConcurrentHashMap();
        this.loggedPropTypeMismatch = ConcurrentHashMap.newKeySet();
        this.loggedNonExistentVertexProvider = new AtomicBoolean(false);
        this.loggedNonExistentEdgeProvider = new AtomicBoolean(false);
        this.loggedNonExistentVertex = new AtomicBoolean(false);
        this.loggedNonExistentEdge = new AtomicBoolean(false);
        this.loggedPropertyDoesNotExist = new AtomicBoolean(false);
        this.loggedVertexAlreadyExists = new AtomicBoolean(false);
        this.loggedEdgeAlreadyExists = new AtomicBoolean(false);
        this.loggedAddEdgeSrcOrDstDoesNotExist = new AtomicBoolean(false);
        this.addExistingVertexPolicy = OnAddExistingElement.IGNORE;
        this.addExistingEdgePolicy = OnAddExistingElement.IGNORE;
        this.requiredConversionPolicy = OnRequiredConversion.ERROR;
        this.invalidChangePolicy = OnInvalidChange.ERROR;
    }

    private void resetLoggedAddExistingVertexPolicy() {
        this.loggedAddExistingVertex.set(false);
    }

    private void resetLoggedAddExistingEdgePolicy() {
        this.loggedAddExistingEdge.set(false);
    }

    private void resetLoggedInvalidChangePolicy() {
        this.loggedVertexCollision.set(false);
        this.loggedEdgeCollision.set(false);
        this.loggedVertexIdMismatch.set(false);
        this.loggedVertexPropTypeMismatch.clear();
        this.loggedEdgePropTypeMismatch.clear();
        this.loggedPropTypeMismatch.clear();
        this.loggedNonExistentVertex.set(false);
        this.loggedNonExistentEdge.set(false);
        this.loggedNonExistentVertexProvider.set(false);
        this.loggedNonExistentEdgeProvider.set(false);
        this.loggedPropertyDoesNotExist.set(false);
        this.loggedVertexAlreadyExists.set(false);
        this.loggedEdgeAlreadyExists.set(false);
        this.loggedAddEdgeSrcOrDstDoesNotExist.set(false);
    }

    private void resetLoggedRquiredConversionPolicy() {
        this.loggedVertexIdConversion.set(false);
    }

    public OnInvalidChange getInvalidChangePolicy() {
        return this.invalidChangePolicy;
    }

    public void setInvalidChangePolicy(OnInvalidChange invalidChangePolicy) {
        this.resetLoggedInvalidChangePolicy();
        this.invalidChangePolicy = invalidChangePolicy;
    }

    public OnRequiredConversion getRquiredConversionPolicy() {
        return this.requiredConversionPolicy;
    }

    public void setRquiredConversionPolicy(OnRequiredConversion requiredConversionPolicy) {
        this.resetLoggedRquiredConversionPolicy();
        this.requiredConversionPolicy = requiredConversionPolicy;
    }

    public OnAddExistingElement getAddExistingEdgePolicy() {
        return this.addExistingEdgePolicy;
    }

    public void setAddExistingEdgePolicy(OnAddExistingElement addExistingEdgePolicy) {
        this.resetLoggedAddExistingEdgePolicy();
        this.addExistingEdgePolicy = addExistingEdgePolicy;
    }

    public OnAddExistingElement getAddExistingVertexPolicy() {
        return this.addExistingVertexPolicy;
    }

    public void setAddExistingVertexPolicy(OnAddExistingElement addExistingVertexPolicy) {
        this.resetLoggedAddExistingVertexPolicy();
        this.addExistingVertexPolicy = addExistingVertexPolicy;
    }

    private void logOrThrowOnInvalidChange(AtomicBoolean loggedInvalidChange, String errorMsg, String logMsg) {
        switch (this.invalidChangePolicy) {
            case IGNORE: {
                break;
            }
            case IGNORE_AND_LOG: {
                LOG.debug(logMsg);
                break;
            }
            case IGNORE_AND_LOG_ONCE: {
                if (loggedInvalidChange.getAndSet(true)) break;
                LOG.debug(logMsg);
                break;
            }
            case ERROR: {
                throw new IllegalArgumentException(errorMsg);
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.invalidChangePolicy);
            }
        }
    }

    private void logOrThrowOnPropTypeMismatch(Set<String> loggedInvalidChange, String propName, String errorMsg, String logMsg) {
        switch (this.invalidChangePolicy) {
            case IGNORE: {
                break;
            }
            case IGNORE_AND_LOG: {
                LOG.debug(logMsg);
                break;
            }
            case IGNORE_AND_LOG_ONCE: {
                if (!loggedInvalidChange.add(propName)) break;
                LOG.debug(logMsg);
                break;
            }
            case ERROR: {
                throw new IllegalArgumentException(errorMsg);
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.invalidChangePolicy);
            }
        }
    }

    private void logOrThrowOnAddExistingVertex(AtomicBoolean loggedAddExistingVertex, String errorMsg, String logMsg) {
        switch (this.addExistingVertexPolicy) {
            case ERROR: {
                throw new IllegalArgumentException(errorMsg);
            }
            case WARN: {
                LOG.debug(logMsg);
                break;
            }
            case WARN_ONCE: {
                if (loggedAddExistingVertex.getAndSet(true)) break;
                LOG.debug(logMsg);
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.addExistingVertexPolicy);
            }
        }
    }

    private void logOrThrowOnAddExistingEdge(AtomicBoolean loggedAddExistingEdge, String errorMsg, String logMsg) {
        switch (this.addExistingEdgePolicy) {
            case ERROR: {
                throw new IllegalArgumentException(errorMsg);
            }
            case WARN: {
                LOG.debug(logMsg);
                break;
            }
            case WARN_ONCE: {
                if (loggedAddExistingEdge.getAndSet(true)) break;
                LOG.debug(logMsg);
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.addExistingEdgePolicy);
            }
        }
    }

    private void logOrThrowOnRequiredConversion(AtomicBoolean loggedConversion, String errorMsg, String logMsg) {
        switch (this.requiredConversionPolicy) {
            case CONVERT: {
                break;
            }
            case CONVERT_AND_LOG: {
                LOG.debug(logMsg);
                break;
            }
            case CONVERT_AND_LOG_ONCE: {
                if (loggedConversion.getAndSet(true)) break;
                LOG.debug(logMsg);
                break;
            }
            case ERROR: {
                throw new IllegalArgumentException(errorMsg);
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.requiredConversionPolicy);
            }
        }
    }

    public void handleAddExistingVertex(ChangeType existingAction) {
        ChangeType newAction = ChangeType.ADD;
        String newActionMsg = InvalidChangeHandler.getVertexCollisionMessage(newAction);
        String conflictingActionMsg = InvalidChangeHandler.getConflictingVertexActionMessage(existingAction, VertexLocation.UNSPECIFIED);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg, ignoredActionMsg);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg);
        this.logOrThrowOnAddExistingVertex(this.loggedAddExistingVertex, errorMsg, logMsg);
    }

    public void handleVertexAlreadyExistsInGraph(boolean isSameTable) {
        String errorMsg = isSameTable ? ErrorMessages.getMessage((String)"CHANGES_VERTEX_ALREADY_EXISTS", (Object[])new Object[0]) : ErrorMessages.getMessage((String)"CHANGES_VERTEX_ALREADY_EXISTS_IN_ANOTHER_PROVIDER", (Object[])new Object[0]);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(ChangeType.ADD);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnAddExistingVertex(this.loggedVertexAlreadyExists, errorMsg, logMsg);
    }

    public void handleAddExistingEdge(ChangeType existingAction) {
        ChangeType newAction = ChangeType.ADD;
        String newActionMsg = InvalidChangeHandler.getEdgeCollisionMessage(newAction);
        String conflictingActionMsg = InvalidChangeHandler.getConflictingEdgeActionMessage(existingAction);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg, ignoredActionMsg);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg);
        this.logOrThrowOnAddExistingEdge(this.loggedAddExistingEdge, errorMsg, logMsg);
    }

    public void handleEdgeAlreadyExistsInGraph() {
        String errorMsg = ErrorMessages.getMessage((String)"CHANGES_EDGE_ALREADY_EXISTS", (Object[])new Object[0]);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(ChangeType.ADD);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnAddExistingEdge(this.loggedEdgeAlreadyExists, errorMsg, logMsg);
    }

    public void handleRemoveVertexThatIsUsedByEdge(long numEdgesWhereSrc, long numEdgesWhereDst) {
        String conflictMsg = ErrorMessages.getMessage((String)"CHANGES_CANNOT_REMOVE_VERTEX", (Object[])new Object[]{numEdgesWhereSrc, numEdgesWhereDst});
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(ChangeType.REMOVE);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(conflictMsg, ignoredActionMsg);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(conflictMsg);
        this.logOrThrowOnInvalidChange(this.loggedVertexCollision, errorMsg, logMsg);
    }

    public void handleAddEdgeWhereVertexWasRemoved(ChangeType newChange, ChangeType existingChange, VertexLocation vertexLocation) {
        this.handleVertexCollision(newChange, existingChange, vertexLocation, true);
    }

    public void handleVertexCollision(ChangeType newAction, ChangeType existingAction) {
        this.handleVertexCollision(newAction, existingAction, VertexLocation.UNSPECIFIED, false);
    }

    private void handleVertexCollision(ChangeType newAction, ChangeType existingAction, VertexLocation vertexLocation, boolean newActionIsEdgeAction) {
        String newActionMsg = newActionIsEdgeAction ? InvalidChangeHandler.getEdgeCollisionMessage(newAction) : InvalidChangeHandler.getVertexCollisionMessage(newAction);
        String conflictingActionMsg = InvalidChangeHandler.getConflictingVertexActionMessage(existingAction, vertexLocation);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg, ignoredActionMsg);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedVertexCollision, errorMsg, logMsg);
    }

    public void handleVertexDoesNotExist(ChangeType newAction) {
        String errorMsg = InvalidChangeHandler.getEntityDoesNotExistMessage(EntityType.VERTEX);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedNonExistentVertex, errorMsg, logMsg);
    }

    public void handleEdgeDoesNotExist(ChangeType newAction) {
        String errorMsg = InvalidChangeHandler.getEntityDoesNotExistMessage(EntityType.EDGE);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedNonExistentEdge, errorMsg, logMsg);
    }

    public void handleVertexProviderDoesNotExistOrWasNull(ChangeType newAction, boolean providerWasNull) {
        String errorMsg = providerWasNull ? InvalidChangeHandler.getEntityProviderWasNullMessage(EntityType.VERTEX) : InvalidChangeHandler.getEntityProviderDoesNotExistMessage(EntityType.VERTEX);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedNonExistentVertexProvider, errorMsg, logMsg);
    }

    public void handleEdgeProviderDoesNotExistOrWasNull(ChangeType newAction, boolean providerWasNull) {
        String errorMsg = providerWasNull ? InvalidChangeHandler.getEntityProviderWasNullMessage(EntityType.EDGE) : InvalidChangeHandler.getEntityProviderDoesNotExistMessage(EntityType.EDGE);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedNonExistentEdgeProvider, errorMsg, logMsg);
    }

    public void handlePropertyDoesNotExist(EntityType entityType, PropertyType propertyType) {
        String errorMsg = ErrorMessages.getMessage((String)"CHANGES_PROPERTY_DOES_NOT_EXIST_IN_GRAPH", (Object[])new Object[]{entityType.toString(), propertyType.toString()});
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, InvalidChangeHandler.getIgnoredChangeMessage(null));
        this.logOrThrowOnInvalidChange(this.loggedPropertyDoesNotExist, errorMsg, logMsg);
    }

    public void handleEdgeCollision(ChangeType newAction, ChangeType existingAction) {
        String newActionMsg = InvalidChangeHandler.getEdgeCollisionMessage(newAction);
        String conflictingActionMsg = InvalidChangeHandler.getConflictingEdgeActionMessage(existingAction);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(newAction);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg, ignoredActionMsg);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(newActionMsg, conflictingActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedEdgeCollision, errorMsg, logMsg);
    }

    public void handleAddEdgeSrcOrDstDoesNotExist(VertexLocation vertexLocation) {
        String errorMsg = InvalidChangeHandler.getSrcOrDstDoesNotExistMessage(vertexLocation);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(ChangeType.ADD);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedAddEdgeSrcOrDstDoesNotExist, errorMsg, logMsg);
    }

    public void handleVertexIdMismatch(IdType expectedVertexIdType, Object vid, ChangeType actionOrNull, VertexLocation vertexLocation) {
        IdType actualIdType;
        if (vid == null) {
            actualIdType = null;
        } else {
            try {
                actualIdType = IdType.getTypeFor(vid.getClass());
            }
            catch (IllegalArgumentException e) {
                actualIdType = null;
            }
        }
        this.handleVertexIdMismatch(expectedVertexIdType, actualIdType, actionOrNull, vertexLocation);
    }

    public void handleVertexIdMismatch(IdType expectedVertexIdType, IdType actualIdTypeOrNull, ChangeType actionOrNull, VertexLocation vertexLocation) {
        String vertexIdMismatchMsg = actualIdTypeOrNull == null ? ErrorMessages.getMessage((String)"NODE_ID_UNKNOWN_TYPE", (Object[])new Object[]{expectedVertexIdType}) : ErrorMessages.getMessage((String)"NODE_ID_UNEXPECTED_TYPE", (Object[])new Object[]{expectedVertexIdType, actualIdTypeOrNull});
        String vertexLocationMsg = InvalidChangeHandler.getVertexLocationMessage(vertexLocation);
        String ignoredActionMsg = actionOrNull == null ? null : InvalidChangeHandler.getIgnoredChangeMessage(actionOrNull);
        String errorMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(vertexIdMismatchMsg, vertexLocationMsg);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        this.logOrThrowOnInvalidChange(this.loggedVertexIdMismatch, errorMsg, logMsg);
    }

    public void handlePropTypeMismatch(String propertyName, PropertyType givenPropTypeOrNull, EntityType entityTypeOrNull, PropertyType expectedPropType) {
        String errorMsg = InvalidChangeHandler.getPropTypeMismatchMessage(expectedPropType, givenPropTypeOrNull, entityTypeOrNull);
        String ignoredActionMsg = InvalidChangeHandler.getIgnoredChangeMessage(null);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(errorMsg, ignoredActionMsg);
        Set<String> loggedTypeMismatch = this.loggedPropTypeMismatch;
        if (entityTypeOrNull != null && entityTypeOrNull == EntityType.VERTEX) {
            loggedTypeMismatch = this.loggedVertexPropTypeMismatch;
        } else if (entityTypeOrNull != null && entityTypeOrNull == EntityType.EDGE) {
            loggedTypeMismatch = this.loggedEdgePropTypeMismatch;
        }
        this.logOrThrowOnPropTypeMismatch(loggedTypeMismatch, propertyName, errorMsg, logMsg);
    }

    public void handleVertexIdConversion(IdType givenType, IdType targetType, VertexLocation vertexLocation) {
        String conversionMsg = ErrorMessages.getMessage((String)"VERTEX_ID_CONVERSION", (Object[])new Object[]{givenType, targetType});
        String vertexLocationMsg = InvalidChangeHandler.getVertexLocationMessage(vertexLocation);
        String logMsg = InvalidChangeHandler.concatSubmessagesIgnoreEmpty(conversionMsg, vertexLocationMsg);
        String errorMsg = ErrorMessages.getMessage((String)"VERTEX_ID_CONVERSION_DISABLED", (Object[])new Object[]{givenType, targetType});
        this.logOrThrowOnRequiredConversion(this.loggedVertexIdConversion, errorMsg, logMsg);
    }

    public static enum VertexLocation {
        UNSPECIFIED,
        STANDALONE,
        EDGE_SOURCE,
        EDGE_DESTINATION;

    }
}

