/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.internal.PgxFrameImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.mllib.EdgeWiseModel;
import oracle.pgx.api.mllib.FileModelStorer;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.UnsupervisedEdgeWiseModelConfig;

public class UnsupervisedEdgeWiseModel
extends EdgeWiseModel<UnsupervisedEdgeWiseModelConfig, UnsupervisedEdgeWiseModelMetadata, UnsupervisedEdgeWiseModel> {
    public static final String ALGORITHM_NAME = "UnsupervisedEdgeWise";

    public UnsupervisedEdgeWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor, UnsupervisedEdgeWiseModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, modelMetadata, graphConstructor);
    }

    public UnsupervisedEdgeWiseModel(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor, ModelMetadata modelMetadata) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier, null, graphConstructor);
        if (modelMetadata.getModelKind() != this.getModelKind()) {
            ErrorMessages.throwException(IllegalArgumentException::new, (String)"UNEXPECTED_MODEL_KIND", (Object[])new Object[]{this.getModelKind(), modelMetadata.getModelKind()});
        } else {
            this.modelMetadata = (UnsupervisedEdgeWiseModelMetadata)modelMetadata;
        }
    }

    @Override
    protected UnsupervisedEdgeWiseModel getThis() {
        return this;
    }

    @Override
    protected ModelKind getModelKind() {
        return ModelKind.UNSUPERVISED_EDGEWISE;
    }

    @Override
    public PgxFuture<Double> fitAsync(PgxGraph graph) {
        return this.core.fitUnsupervisedEdgeWiseModel(this.session.getSessionContext(), ((UnsupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId()).thenApply(metadata -> {
            this.modelMetadata = metadata;
            return ((UnsupervisedEdgeWiseModelConfig)metadata.getConfig()).getTrainingLoss();
        });
    }

    @Override
    public PgxFuture<Double> fitAsync(PgxGraph trainGraph, PgxGraph valGraph) {
        return this.core.fitUnsupervisedEdgeWiseModel(this.session.getSessionContext(), ((UnsupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), trainGraph.getId(), valGraph.getId()).thenApply(metadata -> {
            this.modelMetadata = metadata;
            return ((UnsupervisedEdgeWiseModelConfig)metadata.getConfig()).getTrainingLoss();
        });
    }

    @Override
    public PgxFuture<PgxFrame> getTrainingLogAsync() {
        return this.core.getTrainingLogUnsupervisedEdgeWiseModel(this.session.getSessionContext(), ((UnsupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName()).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    @Override
    public PgxFuture<PgxFrame> inferEmbeddingsAsync(PgxGraph graph, Iterable<PgxEdge> edges) {
        return this.core.inferEmbeddingsUnsupervisedEdgeWiseModel(this.session.getSessionContext(), ((UnsupervisedEdgeWiseModelMetadata)this.modelMetadata).getModelName(), graph.getId(), this.serializeEdges(edges)).thenApply(frameMetaData -> new PgxFrameImpl(this.session, this.core, (FrameMetaData)((Object)frameMetaData), this.keystorePathSupplier, this.keystorePasswordSupplier));
    }

    public PgxFuture<Void> storeAsync(String path, String key) throws ExecutionException, InterruptedException {
        return this.storeAsync(path, key, false);
    }

    public PgxFuture<Void> storeAsync(String path, String key, boolean overwrite) {
        return ((FileModelStorer)this.export().file().path(path).key(key).overwrite(overwrite)).storeAsync();
    }

    public void store(String path, String key) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key).get();
    }

    public void store(String path, String key, boolean overwrite) throws ExecutionException, InterruptedException {
        this.storeAsync(path, key, overwrite).get();
    }

    public UnsupervisedEdgeWiseModelConfig.LossFunction getLossFunction() {
        return ((UnsupervisedEdgeWiseModelConfig)this.getConfig()).getLossFunction();
    }

    public List<Set<String>> getTargetEdgeLabels() {
        return ((UnsupervisedEdgeWiseModelConfig)this.getConfig()).getTargetEdgeLabelSets();
    }

    public GraphWiseDgiLayerConfig getDgiLayerConfigs() {
        return ((UnsupervisedEdgeWiseModelConfig)this.getConfig()).getDgiLayerConfig();
    }

    public static enum UnsupervisedEdgeWiseInferenceType {
        INFER_EMBEDDINGS;

    }
}

