/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackVersionsOperation;
import oracle.pgx.common.types.EntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlashbackQueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FlashbackQueryFactory.class);

    private FlashbackQueryFactory() {
    }

    public static String selectAddedVertices(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsPreparedQuery(config, FlashbackVersionsOperation.INSERT, EntityType.VERTEX);
    }

    public static String selectAddedEdges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsPreparedQuery(config, FlashbackVersionsOperation.INSERT, EntityType.EDGE);
    }

    public static String selectVertexChanges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsPreparedQuery(config, FlashbackVersionsOperation.UPDATE, EntityType.VERTEX);
    }

    public static String selectEdgeChanges(FlashbackConfig config) {
        return FlashbackQueryFactory.getChangedElementsPreparedQuery(config, FlashbackVersionsOperation.UPDATE, EntityType.EDGE);
    }

    public static String selectRemovedVertices(FlashbackConfig config) {
        return FlashbackQueryFactory.getRemovedElementsPreparedQuery(config, EntityType.VERTEX);
    }

    public static String selectRemovedEdges(FlashbackConfig config) {
        return FlashbackQueryFactory.getRemovedElementsPreparedQuery(config, EntityType.EDGE);
    }

    public static PreparedStatement createPreparedStatementWithScnArguments(Connection connection, String query, Long startScn, Long lastScn) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(query);
        statement.setLong(1, startScn);
        statement.setLong(2, lastScn);
        return statement;
    }

    private static String getChangedElementsPreparedQuery(FlashbackConfig config, FlashbackVersionsOperation operation, EntityType entityType) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT /*+ parallel(").append(config.getParallelHint()).append(") */ ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn())).append(", versions_operation vo ");
        for (FlashbackPropertyConfig property : config.getProperties()) {
            String propertyName = property.getName();
            String columnExpression = property.getColumnExpression();
            if (columnExpression == null) {
                columnExpression = PgqlUtils.printIdentifier((String)propertyName);
            }
            sb.append(", " + columnExpression + " AS " + PgqlUtils.printIdentifier((String)propertyName) + " ");
        }
        sb.append(", versions_startscn, versions_endscn, versions_xid");
        if (entityType == EntityType.EDGE) {
            sb.append(", ").append(PgqlUtils.printIdentifier((String)config.getSourceColumn())).append(", ").append(PgqlUtils.printIdentifier((String)config.getDestinationColumn()));
        }
        sb.append(" from ").append(config.printTableName()).append(" versions between scn :1 and :2").append(" where versions_operation = '").append(operation.getAlias()).append("'").append(" order by versions_startscn");
        String query = sb.toString();
        LOG.debug("running {} query {}", (Object)operation.getAlias(), (Object)query);
        return query;
    }

    private static String getRemovedElementsPreparedQuery(FlashbackConfig config, EntityType entityType) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT /*+ parallel(").append(config.getParallelHint()).append(") */ ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn()));
        if (entityType == EntityType.EDGE) {
            sb.append(", ").append(PgqlUtils.printIdentifier((String)config.getSourceColumn())).append(" AS v_src").append(", ").append(PgqlUtils.printIdentifier((String)config.getDestinationColumn())).append(" AS v_dst");
        }
        sb.append(", versions_operation vo").append(" from ").append(config.printTableName()).append(" versions between scn :1 and :2").append(" where versions_operation = 'D'").append(" order by ").append(PgqlUtils.printIdentifier((String)config.getKeyColumn()));
        String query = sb.toString();
        LOG.debug("running delete query {}", (Object)query);
        return query;
    }
}

