/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.SnapshotsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LoadingUtils.class);

    public static PgxFuture<Graph> readGraph(SessionContext context, Core core, long maxAge, TimeUnit maxAgeTimeUnit, boolean blockIfFull, GraphConfig loadingConfig, String graphName) {
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)core.loadGraphWithProperties(context, loadingConfig, graphName).cancelOn(promise).thenCompose(gr -> {
            if (Objects.equals(SnapshotsSource.CHANGE_SET, loadingConfig.getLoadingOptions().getSnapshotsSource())) {
                LOG.debug("==> change sets as snapshot source. Returning graph loaded by the engine");
                return PgxFuture.completedFuture(gr).cancelOn(promise);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("engine reports latest snapshot is {} milli-seconds old. Max age is {} milli-seconds", (Object)TimeUnit.MILLISECONDS.convert(gr.getAgeMs(), TimeUnit.MILLISECONDS), (Object)TimeUnit.MILLISECONDS.convert(maxAge, maxAgeTimeUnit));
            }
            if (gr.getAgeMs() <= TimeUnit.MILLISECONDS.convert(maxAge, maxAgeTimeUnit)) {
                LOG.debug("==> within range. Return snapshot");
                return PgxFuture.completedFuture(gr).cancelOn(promise);
            }
            LOG.debug("==> try to check out newer snapshot");
            return core.refresh(context, gr.getGraphId(), blockIfFull).cancelOn(promise);
        })).thenComplete(promise);
    }
}

