/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.api.EntryIterable;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.PropertyProxy;
import oracle.pgx.common.Entry;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public abstract class Property<ID, K extends PgxEntity<ID>, V>
extends PgxManagedObject
implements Cloneable {
    protected final Core core;
    protected final SessionContext sessionContext;
    protected final PgxGraph graph;
    protected final PgxId graphId;
    protected final EntityType entityType;
    protected final PropertyType type;
    protected final int dimension;
    protected final boolean transientFlag;
    protected final boolean labelFlag;
    protected final AtomicReference<PropertyProxy<V>> cachedProxy;
    private final PgxId propertyId;
    protected final AtomicReference<String> propertyName;

    protected static Collection<PgxId> getIds(Collection<? extends Property<?, ?, ?>> col) {
        if (col == null) {
            return null;
        }
        return col.stream().map(Property::getPropertyId).collect(Collectors.toList());
    }

    Property(PgxGraph graph, oracle.pgx.api.internal.Property pr) {
        this(graph, pr, false);
    }

    Property(PgxGraph graph, oracle.pgx.api.internal.Property pr, boolean label) {
        this.graph = graph;
        this.sessionContext = graph.getSession().getSessionContext();
        this.core = this.graph.getSession().getCore();
        this.graphId = graph.getId();
        this.entityType = pr.getEntityType();
        this.type = pr.getType();
        this.dimension = pr.getDimension();
        this.propertyId = pr.getPropertyId();
        this.propertyName = new AtomicReference<String>(pr.getName());
        this.transientFlag = pr.isTransient();
        this.labelFlag = label;
        this.cachedProxy = new AtomicReference();
    }

    public final PgxId getPropertyId() {
        return this.propertyId;
    }

    protected abstract K getEntity(Object var1);

    public PgxGraph getGraph() {
        return this.graph;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public String getName() {
        return this.propertyName.get();
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isVectorProperty() {
        return this.getDimension() > 0;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyProperty(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType);
    }

    public PropertyType getType() {
        return this.type;
    }

    public PgxFuture<Void> setAsync(K key, V value) {
        return this.setValuesAsync(Collections.singletonMap(key, value));
    }

    public PgxFuture<Void> setValuesAsync(Map<K, V> values) {
        return this.setValuesAsync(values, null);
    }

    public PgxFuture<Void> setValuesAsync(Map<K, V> values, V defaultValue) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(values.size());
        for (Map.Entry<K, V> entry : values.entrySet()) {
            map.put(((PgxEntity)entry.getKey()).serialize(), Property.unwrap(entry.getValue()));
        }
        return this.core.setProperty(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType, map, Property.unwrap(defaultValue));
    }

    public PgxFuture<Void> fillAsync(V value) {
        return this.core.fillProperty(this.sessionContext, this.graphId, this.getPropertyId(), Property.unwrap(value), this.entityType);
    }

    public PgxFuture<Void> renameAsync(String newPropertyName) {
        return this.core.renameProperty(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType, newPropertyName).thenAccept(arg -> this.propertyName.set(newPropertyName));
    }

    public PgxFuture<Void> publishAsync() {
        return this.core.publishProperty(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType);
    }

    public PgxFuture<Boolean> isPublishedAsync() {
        return this.core.isPropertyPublished(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return this.getPropertyId().equals((Object)other.getPropertyId());
    }

    @Override
    public int hashCode() {
        return this.getPropertyId().hashCode();
    }

    public String toString() {
        return this.toString(Property.entry("name", this.getName()), Property.entry("type", this.getType().toKey()), Property.entry("graph", this.getGraph().getName()));
    }

    public PgxFuture<Long> sizeAsync() {
        return this.getProxy().thenApply(PropertyProxy::size);
    }

    public PgxFuture<V> getAsync(ID id) {
        return this.getProxy().thenApply(proxy -> Property.wrap(proxy.getValueFor(id), this.getType(), this.graph));
    }

    public PgxFuture<V> getAsync(K key) {
        return this.getProxy().thenApply(proxy -> Property.wrap(proxy.getValueFor(key.serialize()), this.getType(), this.graph));
    }

    public PgxFuture<EntryIterable<ID, K, V>> getValuesAsync() {
        return this.getProxy().thenApply(proxy -> new ProxyIterable(proxy.getValues()));
    }

    public PgxFuture<EntryIterable<ID, K, V>> getTopKValuesAsync(int k) {
        return this.getProxy().thenApply(proxy -> new ProxyIterable(proxy.getTopKValues(k)));
    }

    public PgxFuture<EntryIterable<ID, K, V>> getBottomKValuesAsync(int k) {
        return this.getProxy().thenApply(proxy -> new ProxyIterable(proxy.getBottomKValues(k)));
    }

    protected <P extends Property<ID, K, V>> PgxFuture<P> internalClone(String newPropertyName, Function<oracle.pgx.api.internal.Property, P> constructor) {
        return this.core.cloneProperty(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType, newPropertyName).thenApply(constructor::apply);
    }

    protected <S, P extends Property<ID, K, S>> PgxFuture<List<P>> internalExpand(Function<oracle.pgx.api.internal.Property, P> constructor, String namePrefix) {
        if (!this.isVectorProperty()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalStateException(ErrorMessages.getMessage((String)"CANNOT_EXPAND_SCALAR_PROPERTY", (Object[])new Object[0])));
        }
        return this.core.expand(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType, namePrefix).thenApply(prs -> {
            ArrayList<Property> props = new ArrayList<Property>(prs.size());
            for (oracle.pgx.api.internal.Property pr : prs) {
                props.add((Property)constructor.apply(pr));
            }
            return props;
        });
    }

    protected PgxFuture<PropertyProxy<V>> getProxy() {
        PropertyProxy<V> cached = this.cachedProxy.get();
        if (cached != null) {
            return PgxFuture.completedFuture(cached);
        }
        return this.core.getPropertyProxy(this.sessionContext, this.graphId, this.getPropertyId(), this.entityType, this.labelFlag).thenApply(proxy -> {
            this.cachedProxy.set((PropertyProxy<PropertyProxy>)proxy);
            return proxy;
        });
    }

    public static <V> V wrap(V value, PropertyType type, PgxGraph graph) {
        switch (type) {
            case VERTEX: {
                return (V)PgxVertex.deserialize(graph, value);
            }
            case EDGE: {
                return (V)PgxEdge.deserialize(graph, value);
            }
        }
        return value;
    }

    public void set(K key, V value) {
        this.setAsync(key, value).join();
    }

    public void setValues(Map<K, V> values) {
        this.setValuesAsync(values).join();
    }

    public void setValues(Map<K, V> values, V defaultValue) {
        this.setValuesAsync(values, defaultValue).join();
    }

    public void fill(V value) throws ExecutionException, InterruptedException {
        this.fillAsync(value).get();
    }

    public void rename(String newPropertyName) {
        this.renameAsync(newPropertyName).join();
    }

    public long size() {
        return this.sizeAsync().join();
    }

    public V get(ID id) {
        return this.getAsync((K)id).join();
    }

    public V get(K key) {
        return this.getAsync(key).join();
    }

    public EntryIterable<ID, K, V> getValues() {
        return this.getValuesAsync().join();
    }

    public EntryIterable<ID, K, V> getTopKValues(int k) {
        return this.getTopKValuesAsync(k).join();
    }

    public EntryIterable<ID, K, V> getBottomKValues(int k) {
        return this.getBottomKValuesAsync(k).join();
    }

    public void publish() {
        this.publishAsync().join();
    }

    public boolean isPublished() {
        return this.isPublishedAsync().join();
    }

    private class ProxyIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, V>> wrapped;

        ProxyIterator(Iterator<Map.Entry<Object, V>> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = this.wrapped.next();
            Object key = Property.this.getEntity(entry.getKey());
            return new Entry(key, Property.wrap(entry.getValue(), Property.this.getType(), Property.this.graph));
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }
    }

    protected class ProxyIterable
    implements EntryIterable<ID, K, V> {
        private final Iterable<Map.Entry<Object, V>> wrapped;

        ProxyIterable(Iterable<Map.Entry<Object, V>> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ProxyIterator(this.wrapped.iterator());
        }
    }
}

