/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import oracle.pgx.api.filter.BinaryGraphFilterOperation;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.GraphFilterWithExpression;
import oracle.pgx.api.filter.PathFindingFilter;
import oracle.pgx.api.filter.internal.EdgeCollectionFilter;
import oracle.pgx.api.filter.internal.ResultSetEdgeFilter;
import oracle.pgx.api.filter.internal.ResultSetVertexFilter;
import oracle.pgx.api.filter.internal.VertexCollectionFilter;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;

public class GraphFilterDeserializer
extends JsonDeserializer<GraphFilter> {
    public GraphFilter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return GraphFilterDeserializer.parseGraphFilter((JsonNode)jp.readValueAsTree());
    }

    public static GraphFilter parseGraphFilter(JsonNode node) throws IOException, JsonParseException, JsonMappingException {
        FilterType type = (FilterType)JsonUtil.fromJsonNode((JsonNode)node.get("type"), FilterType.class);
        switch (type) {
            case EDGE: 
            case VERTEX: {
                String filterExpression = node.get("filterExpression").textValue();
                if (GraphFilterDeserializer.isResultSetFilter(node)) {
                    String resultSetId = node.get("resultSetId").textValue();
                    String columnName = node.get("columnName").textValue();
                    return GraphFilterDeserializer.fromResultSet(type, resultSetId, columnName);
                }
                if (GraphFilterDeserializer.isCollectionFilter(node)) {
                    String collectionId = node.get("collectionId").textValue();
                    return GraphFilterDeserializer.fromCollection(type, PgxId.fromString((String)collectionId));
                }
                return GraphFilterWithExpression.fromTypeAndExpression((FilterType)type, (String)filterExpression);
            }
            case INTERSECTION: 
            case UNION: {
                GraphFilter leftFilter = GraphFilterDeserializer.parseGraphFilter(node.get("leftFilter"));
                GraphFilter rightFilter = GraphFilterDeserializer.parseGraphFilter(node.get("rightFilter"));
                return BinaryGraphFilterOperation.fromTypeAndFilters((FilterType)type, (GraphFilter)leftFilter, (GraphFilter)rightFilter);
            }
            case PATH_FINDING: {
                Object destinationVertex;
                Object sourceVertex;
                GraphFilter filter = GraphFilterDeserializer.parseGraphFilter(node.get("graphFilter"));
                try {
                    sourceVertex = JsonUtil.fromJsonNode((JsonNode)node.get("sourceVertex"), Vertex.class);
                    destinationVertex = JsonUtil.fromJsonNode((JsonNode)node.get("destinationVertex"), Vertex.class);
                }
                catch (MismatchedInputException e) {
                    sourceVertex = JsonUtil.fromJsonNode((JsonNode)node.get("sourceVertex"), Object.class);
                    destinationVertex = JsonUtil.fromJsonNode((JsonNode)node.get("destinationVertex"), Object.class);
                }
                return new PathFindingFilter(filter, sourceVertex, destinationVertex);
            }
        }
        throw new IllegalEnumConstantException((Enum)type);
    }

    private static GraphFilter fromResultSet(FilterType type, String resultSetId, String columnName) {
        switch (type) {
            case EDGE: {
                return new ResultSetEdgeFilter(resultSetId, columnName);
            }
            case VERTEX: {
                return new ResultSetVertexFilter(resultSetId, columnName);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_EXPRESSION_FILTER", (Object[])new Object[]{type.toString().toLowerCase()}));
    }

    private static boolean isResultSetFilter(JsonNode node) {
        JsonNode resultSetIdNode = node.get("resultSetId");
        if (resultSetIdNode == null) {
            return false;
        }
        String resultSetId = resultSetIdNode.textValue();
        return resultSetId != null && !resultSetId.isEmpty();
    }

    private static GraphFilter fromCollection(FilterType type, PgxId collectionId) {
        switch (type) {
            case EDGE: {
                return new EdgeCollectionFilter(collectionId);
            }
            case VERTEX: {
                return new VertexCollectionFilter(collectionId);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_EXPRESSION_FILTER", (Object[])new Object[]{type.toString().toLowerCase()}));
    }

    private static boolean isCollectionFilter(JsonNode node) {
        JsonNode collectionId = node.get("collectionId");
        if (collectionId == null) {
            return false;
        }
        String id = collectionId.textValue();
        return id != null && !id.isEmpty();
    }
}

